/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRotatable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityTrommel;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLogicTrommel
extends BlockLogicRotatable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static boolean keepTrommelInventory = false;
    private final boolean isActive;

    public BlockLogicTrommel(@NotNull Block<?> block, @NotNull Material material, boolean isActive) {
        super(block, material);
        this.isActive = isActive;
        block.withEntity(TileEntityTrommel::new);
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case EXPLOSION: 
            case PROPER_TOOL: 
            case SILK_TOUCH: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(Blocks.TROMMEL_IDLE);
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            TileEntityTrommel tileEntityTrommel = (TileEntityTrommel)world.getTileEntity(tilePos);
            player.displayTrommelScreen(tileEntityTrommel);
        }
        return true;
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        if (!this.isActive) {
            return;
        }
        double xPos = (double)tilePos.x() + (double)rand.nextFloat();
        double yPos = (double)tilePos.y() + (double)rand.nextFloat() * 0.5 + 1.0;
        double zPos = (double)tilePos.z() + (double)rand.nextFloat();
        world.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
    }

    public static void updateTrommelBlockState(@NotNull World world, @NotNull TilePos tilepos, boolean lit) {
        int data = world.getBlockData(tilepos);
        TileEntity tileEntity = world.getTileEntity(tilepos);
        if (tileEntity == null) {
            String msg = "Trommel is missing Tile Entity at " + String.valueOf(tilepos) + ", block will be removed!";
            if (Global.BUILD_CHANNEL.isUnstableBuild()) {
                throw new RuntimeException(msg);
            }
            world.setBlockIdNotify(tilepos, 0);
            LOGGER.warn(msg);
            return;
        }
        keepTrommelInventory = true;
        if (lit) {
            world.setBlockIdNotify(tilepos, Blocks.TROMMEL_ACTIVE.id());
        } else {
            world.setBlockIdNotify(tilepos, Blocks.TROMMEL_IDLE.id());
        }
        keepTrommelInventory = false;
        world.setBlockDataNotify(tilepos, data);
        tileEntity.validate();
        world.setTileEntity(tilepos, tileEntity);
    }
}

