/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.wire;

import net.minecraft.core.current.util.BlockState;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

class WorldHelper {
    private static final int Y_MIN = 0;

    WorldHelper() {
    }

    @NotNull
    static BlockState getBlockState(@NotNull World world, @NotNull TilePosc pos) {
        if (pos.y() < 0 || pos.y() >= world.getHeightBlocks()) {
            return BlockState.AIR;
        }
        int blockId = world.getBlockId(pos);
        if (blockId == 0) {
            return BlockState.AIR;
        }
        return new BlockState(blockId, world.getBlockData(pos));
    }

    static boolean setWireState(@NotNull World world, @NotNull TilePos pos, @NotNull BlockState state) {
        int prevMetadata;
        int prevBlockId;
        if (pos.y < 0 || pos.y >= world.getHeightBlocks()) {
            return false;
        }
        int blockId = state.getBlockId();
        if (blockId != (prevBlockId = world.getBlockId(pos))) {
            return false;
        }
        int metadata = state.get();
        if (metadata == (prevMetadata = world.getBlockData(pos))) {
            return false;
        }
        world.setBlockData(pos, metadata);
        world.notifyBlockChange(pos, blockId);
        world.markBlockDirty(pos);
        return true;
    }
}

