/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFarmland;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSeeds
extends Item {
    @NotNull
    private final Block<?> cropsBlock;

    public ItemSeeds(@NotNull String name, @NotNull String namespaceId, int id, @NotNull Block<?> cropsBlock) {
        super(name, namespaceId, id);
        this.cropsBlock = cropsBlock;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (world.getBlockId(blockPos.down(new TilePos())) == Blocks.FARMLAND_DIRT.id() && world.canPlaceInsideBlock(blockPos) && world.setBlockIdNotify(blockPos, this.cropsBlock.id())) {
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, this.cropsBlock, EnumBlockSoundEffectType.PLACE);
            selfStack.consumeItem(player);
            return true;
        }
        return false;
    }

    @Override
    public void onUseByActivator(@NotNull ItemStack selfStack, @NotNull World world, @NotNull TileEntityActivator activator, @NotNull Random random, @NotNull TilePosc blockPos, @NotNull Direction direction, double offX, double offY, double offZ) {
        blockPos = blockPos.add(direction, new TilePos());
        Block<?> b = world.getBlock(blockPos);
        boolean isFarmland = Block.hasLogicClass(b, BlockLogicFarmland.class);
        if (b == null || isFarmland || BlockTags.PLACE_OVERWRITES.appliesTo(b)) {
            this.onUseOnBlock(selfStack, world, null, blockPos.add(0, isFarmland ? 1 : 0, 0, new TilePos()), direction.getSide(), 0.5, 0.5);
        }
    }
}

