/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemSign
extends Item {
    public ItemSign(@NotNull String name, @NotNull String namespaceId, int id) {
        super(name, namespaceId, id);
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (player == null || side == Side.BOTTOM || !world.getBlockMaterial(blockPos).isSolid()) {
            return false;
        }
        if (!world.canPlaceInsideBlock(blockPos)) {
            blockPos = blockPos.add(side.getDirection(), new TilePos());
        }
        if (blockPos.y() < 0 || blockPos.y() >= world.getHeightBlocks() || !Blocks.SIGN_POST_PLANKS_OAK.canPlaceAt(world, blockPos)) {
            return false;
        }
        if (side == Side.TOP) {
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.SIGN_POST_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            world.setBlockIdDataNotify(blockPos, Blocks.SIGN_POST_PLANKS_OAK.id(), MathHelper.floor((double)((player.yRot + 180.0f) * 16.0f / 360.0f) + 0.5) & 0xF);
        } else {
            world.playBlockSoundEffect(player, (float)blockPos.x() + 0.5f, (float)blockPos.y() + 0.5f, (float)blockPos.z() + 0.5f, Blocks.SIGN_WALL_PLANKS_OAK, EnumBlockSoundEffectType.PLACE);
            world.setBlockIdDataNotify(blockPos, Blocks.SIGN_WALL_PLANKS_OAK.id(), side.getId());
        }
        selfStack.consumeItem(player);
        TileEntity tileEntity = world.getTileEntity(blockPos);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign sign = (TileEntitySign)tileEntity;
            if (selfStack.getData().containsKey("tileEntityData")) {
                sign.readAdditionalData(selfStack.getData().getCompound("tileEntityData"));
            } else {
                sign.setOwner(player);
                player.displaySignEditorScreen(sign);
            }
        }
        return true;
    }
}

