/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.tool;

import net.minecraft.core.block.Block;
import net.minecraft.core.data.tag.Tag;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.material.ToolMaterial;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class ItemTool
extends Item {
    private final Tag<Block<?>> tagEffectiveAgainst;
    private final int damageVsEntity;
    protected ToolMaterial material;

    protected ItemTool(@NotNull String name, @NotNull String namespaceId, int id, int damageDealt, @NotNull ToolMaterial toolMaterial, @NotNull Tag<Block<?>> tagEffectiveAgainst) {
        super(name, namespaceId, id);
        this.material = toolMaterial;
        this.tagEffectiveAgainst = tagEffectiveAgainst;
        this.withTags(ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS);
        this.maxStackSize = 1;
        this.setMaxDamage(toolMaterial.getDurability());
        this.damageVsEntity = damageDealt + toolMaterial.getDamage();
    }

    @Override
    public float getStrVsBlock(@NotNull ItemStack selfStack, @NotNull Block<?> block) {
        if (block.hasTag(this.tagEffectiveAgainst)) {
            return this.material.getEfficiency(false);
        }
        return 1.0f;
    }

    @Override
    public boolean hitEntity(@NotNull ItemStack selfStack, @NotNull Mob target, @NotNull Mob attacker) {
        selfStack.damageItem(2, attacker);
        return true;
    }

    @Override
    public boolean onBlockDestroyed(@NotNull ItemStack selfStack, @NotNull World world, @NotNull Mob mob, @NotNull Block<?> removedBlock, @NotNull TilePos blockPos, @NotNull Side side) {
        if (removedBlock.getHardness() > 0.0f || this.isSilkTouch()) {
            selfStack.damageItem(1, mob);
        }
        return true;
    }

    @Override
    public int getDamageVsEntity(@NotNull ItemStack selfStack, @NotNull Entity entity) {
        return this.damageVsEntity;
    }

    @Override
    public boolean isSilkTouch() {
        return this.material.isSilkTouch();
    }

    public ToolMaterial getMaterial() {
        return this.material;
    }
}

