/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import java.util.Random;
import net.minecraft.core.world.World;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;

public class AuroraProvider {
    private final ImprovedPerlinNoise noise;
    private final World world;

    public AuroraProvider(World world, long seed) {
        this.world = world;
        this.noise = new ImprovedPerlinNoise(new Random(seed));
    }

    public double getAuroraPresence(double x, double z, long worldTime, float celestialAngle) {
        double auroraLevel = 0.0;
        double auroraRadius = 0.03f;
        if (celestialAngle < 0.25f || celestialAngle > 0.75f) {
            return 0.0;
        }
        celestialAngle = (celestialAngle - 0.25f) * 2.0f;
        celestialAngle = celestialAngle * 2.0f - 1.0f;
        celestialAngle = Math.abs(celestialAngle);
        celestialAngle = -celestialAngle + 1.0f;
        double mult = celestialAngle;
        double sample = this.noise.getValue(x / 1000.0, (double)worldTime / 5000.0, z / 1000.0);
        if ((sample += this.noise.getValue(x / 30.0, (double)worldTime / 50.0, z / 30.0) * 0.05) < auroraLevel - auroraRadius || sample > auroraLevel + auroraRadius) {
            return 0.0;
        }
        sample -= auroraLevel;
        sample /= auroraRadius;
        sample = Math.abs(sample);
        sample = -sample;
        return (sample += 1.0) * mult;
    }

    public double getAuroraHeightOffset(double x, double z, double worldTime) {
        return this.noise.getValue(x / 100.0, worldTime / 5000.0, z / 100.0) * 25.0;
    }

    public float getAuroraRedOffset(double x, double z, double worldTime) {
        double sample = this.noise.getValue(x / 500.0, worldTime / 5000.0 + 10000.0, z / 500.0);
        double sample2 = this.noise.getValue(x / 200.0, worldTime / 5000.0, z / 200.0);
        if (sample < 0.0) {
            sample = 0.0;
        }
        if (sample > 0.25) {
            sample = 0.25;
        }
        if (sample2 < 0.0) {
            sample2 = 0.0;
        }
        if (sample2 > (double)0.1f) {
            sample2 = 0.1f;
        }
        return (float)(sample * 3.0 + sample2 * 2.0);
    }

    public float getAuroraGreenOffset(double x, double z, double worldTime) {
        double sample = this.noise.getValue(x / 500.0, worldTime / 5000.0 + 10000.0, z / 500.0);
        double sample2 = this.noise.getValue(x / 500.0, worldTime / 5000.0, z / 500.0);
        if (sample < 0.0) {
            sample = 0.0;
        }
        if (sample > 0.125) {
            sample = 0.125;
        }
        if (sample2 < 0.0) {
            sample2 = 0.0;
        }
        if (sample2 > 0.25) {
            sample2 = 0.25;
        }
        return (float)(sample * 4.0 - sample2 * 2.0);
    }

    public float getAuroraBlueOffset(double x, double z, double worldTime) {
        double sample = this.noise.getValue(x / 500.0, worldTime / 5000.0, z / 500.0);
        if (sample < 0.0) {
            sample = 0.0;
        }
        if (sample > 0.25) {
            sample = 0.25;
        }
        return (float)sample;
    }
}

