/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ShortArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ShortMap;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.ArtType;
import net.minecraft.core.enums.EnumSignPicture;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketAnimate;
import net.minecraft.core.net.packet.PacketBlockUpdate;
import net.minecraft.core.net.packet.PacketBoatControl;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketCommandManager;
import net.minecraft.core.net.packet.PacketContainerAck;
import net.minecraft.core.net.packet.PacketContainerClick;
import net.minecraft.core.net.packet.PacketContainerClose;
import net.minecraft.core.net.packet.PacketContainerSetSlot;
import net.minecraft.core.net.packet.PacketCustomPayload;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketEntityInteract;
import net.minecraft.core.net.packet.PacketGuidebook;
import net.minecraft.core.net.packet.PacketKeepAlive;
import net.minecraft.core.net.packet.PacketMovePlayer;
import net.minecraft.core.net.packet.PacketPlayerAction;
import net.minecraft.core.net.packet.PacketPlayerConfig;
import net.minecraft.core.net.packet.PacketRequestCommandManager;
import net.minecraft.core.net.packet.PacketRespawn;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketSetItemName;
import net.minecraft.core.net.packet.PacketSetMobSpawner;
import net.minecraft.core.net.packet.PacketSetPaintingArt;
import net.minecraft.core.net.packet.PacketSignUpdate;
import net.minecraft.core.net.packet.PacketUpdateCreativeInventory;
import net.minecraft.core.net.packet.PacketUpdatePlayerProfile;
import net.minecraft.core.net.packet.PacketUpdatePlayerState;
import net.minecraft.core.net.packet.PacketUseOrPlaceItemStack;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.menu.MenuFlag;
import net.minecraft.core.player.inventory.menu.MenuInventoryCreative;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.phys.HitResult;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.command.ServerCommandSource;
import net.minecraft.server.player.PlayerListBox;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.primitives.AABBd;
import org.slf4j.Logger;

public class PacketHandlerServer
extends PacketHandler
implements ICommandListener {
    public static Logger LOGGER = LogUtils.getLogger();
    public NetworkManager netManager;
    public boolean connectionClosed = false;
    private final MinecraftServer mcServer;
    private PlayerServer playerEntity;
    private int field_15_f;
    private int field_22004_g;
    private int playerInAirTime;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean hasMoved = true;
    private final Int2ShortMap guiIdMap = new Int2ShortArrayMap();

    public PacketHandlerServer(MinecraftServer minecraftserver, NetworkManager networkManager, PlayerServer player) {
        this.mcServer = minecraftserver;
        this.netManager = networkManager;
        networkManager.setNetHandler(this);
        this.playerEntity = player;
        player.playerNetServerHandler = this;
    }

    public void handlePackets() {
        this.netManager.processReadPackets();
        if (this.field_15_f - this.field_22004_g > 20) {
            this.sendPacket(new PacketKeepAlive());
        }
    }

    public boolean canInteract() {
        return this.playerEntity.canInteract();
    }

    public void kickPlayer(String s) {
        this.playerEntity.func_30002_A();
        this.sendPacket(new PacketDisconnect(s));
        this.netManager.serverShutdown();
        this.mcServer.playerList.sendPacketToAllPlayers(new PacketChat(this.playerEntity.getDisplayName() + String.valueOf(TextFormatting.YELLOW) + " was kicked from the game."));
        this.mcServer.playerList.updatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator());
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerListBox.updateList();
    }

    @Override
    public void handleSetMobSpawner(@NotNull PacketSetMobSpawner packet) {
        TileEntity tileentity;
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (this.playerEntity.getGamemode() == Gamemodes.CREATIVE && world.isBlockLoaded(packet.tilePos) && (tileentity = world.getTileEntity(packet.tilePos)) instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)tileentity;
            spawner.setMobId(packet.dispatcherEntry == null ? "none" : packet.dispatcherEntry.stringID);
            spawner.setChanged();
            world.markBlockNeedsUpdate(packet.tilePos);
        }
    }

    @Override
    public void handlePlayerConfig(@NotNull PacketPlayerConfig packetPlayerConfig) {
        if (this.playerEntity.playerConfig.config != packetPlayerConfig.config) {
            this.playerEntity.playerConfig.config = packetPlayerConfig.config;
            packetPlayerConfig.entityId = this.playerEntity.id;
            this.mcServer.playerList.sendPacketToAllPlayersInDimension(packetPlayerConfig, this.playerEntity.dimension);
        }
    }

    @Override
    public void handleMovePlayer(@NotNull PacketMovePlayer packetMovePlayer) {
        boolean sitting;
        if (!this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (!this.hasMoved) {
            double dx = packetMovePlayer.x - this.playerEntity.x;
            double dy = packetMovePlayer.y - this.playerEntity.y;
            double dz = packetMovePlayer.z - this.playerEntity.z;
            if (dx * dx > 0.01 || dy * dy > 0.01 || dz * dz > 0.01) {
                this.hasMoved = true;
            }
        }
        if (!this.hasMoved) {
            return;
        }
        float yRot = this.playerEntity.yRot;
        float xRot = this.playerEntity.xRot;
        if (packetMovePlayer.hasRotation) {
            yRot = MathHelper.normalizeRotation(packetMovePlayer.yaw);
            xRot = MathHelper.normalizeRotation(packetMovePlayer.pitch);
        }
        boolean sleeping = this.playerEntity.isPlayerSleeping();
        boolean bl = sitting = this.playerEntity.vehicle != null && !(this.playerEntity.vehicle instanceof Entity);
        if (sleeping || sitting) {
            if (sitting) {
                this.playerEntity.vehicle.positionRider();
            }
            this.playerEntity.onUpdateEntity();
            this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, this.playerEntity.yRot, this.playerEntity.xRot);
            worldserver.updateEntity(this.playerEntity);
            return;
        }
        if (this.playerEntity.vehicle instanceof Entity) {
            this.playerEntity.vehicle.positionRider();
            double xd = 0.0;
            double zd = 0.0;
            if (packetMovePlayer.hasPosition && packetMovePlayer.y == -999.0) {
                xd = packetMovePlayer.x;
                zd = packetMovePlayer.z;
            }
            this.playerEntity.onGround = packetMovePlayer.onGround;
            this.playerEntity.onUpdateEntity();
            this.playerEntity.move(xd, 0.0, zd);
            this.playerEntity.absMoveTo(this.playerEntity.x, this.playerEntity.y, this.playerEntity.z, yRot, xRot);
            this.playerEntity.xd = xd;
            this.playerEntity.zd = zd;
            worldserver.updateEntityWithOptionalForce((Entity)this.playerEntity.vehicle, false);
            this.playerEntity.vehicle.positionRider();
            this.mcServer.playerList.onPlayerMoved(this.playerEntity);
            return;
        }
        this.lastPosX = this.playerEntity.x;
        this.lastPosY = this.playerEntity.y;
        this.lastPosZ = this.playerEntity.z;
        double newPosX = this.playerEntity.x;
        double newPosY = this.playerEntity.y;
        double oldPosY = this.playerEntity.y;
        double newPosZ = this.playerEntity.z;
        if (packetMovePlayer.hasPosition && packetMovePlayer.y == -999.0) {
            packetMovePlayer.hasPosition = false;
        }
        if (packetMovePlayer.hasPosition) {
            newPosX = packetMovePlayer.x;
            newPosY = packetMovePlayer.y;
            newPosZ = packetMovePlayer.z;
            if (Math.abs(packetMovePlayer.x) > 3.2E7 || Math.abs(packetMovePlayer.z) > 3.2E7 || Double.isNaN(packetMovePlayer.x) || Double.isNaN(packetMovePlayer.y) || Double.isNaN(packetMovePlayer.z)) {
                LOGGER.warn("{} tried to move to an illegal position", (Object)this.playerEntity.username);
                this.teleport(this.lastPosX, this.lastPosY, this.lastPosZ);
                return;
            }
        }
        this.playerEntity.onUpdateEntity();
        this.playerEntity.ySlideOffset = 0.0f;
        this.playerEntity.absMoveTo(this.lastPosX, this.lastPosY, this.lastPosZ, yRot, xRot);
        if (!this.hasMoved) {
            return;
        }
        double dx = newPosX - this.playerEntity.x;
        double dy = newPosY - this.playerEntity.y;
        double dz = newPosZ - this.playerEntity.z;
        double velSquared = dx * dx + dy * dy + dz * dz;
        if (velSquared > 100.0) {
            LOGGER.warn("{} moved too quickly!", (Object)this.playerEntity.username);
            this.teleport(this.lastPosX, this.lastPosY, this.lastPosZ);
            return;
        }
        float bb_expand = 0.0625f;
        boolean insideBlockOld = worldserver.getCubes(this.playerEntity, MathHelper.aabbInsetBoundingBox(this.playerEntity.bb, bb_expand, bb_expand, bb_expand, new AABBd())).isEmpty();
        this.playerEntity.move(dx, dy, dz);
        dx = newPosX - this.playerEntity.x;
        double ndy = Math.max(newPosY - this.playerEntity.y, -0.0784);
        dz = newPosZ - this.playerEntity.z;
        velSquared = dx * dx + ndy * ndy + dz * dz;
        boolean movedWrong = false;
        if (this.playerEntity.pushTime < 0.1f && !this.playerEntity.getGamemode().hasPlayerFlight() && velSquared > 0.0625 && !this.playerEntity.isPlayerSleeping()) {
            movedWrong = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.playerEntity.username);
            LOGGER.warn("Got position {}, {}, {}", newPosX, newPosY, newPosZ);
            LOGGER.warn("Expected {}, {}, {}", this.playerEntity.x, this.playerEntity.y, this.playerEntity.z);
        }
        this.playerEntity.absMoveTo(newPosX, newPosY, newPosZ, yRot, xRot);
        boolean insideBlockNew = worldserver.getCubes(this.playerEntity, MathHelper.aabbInsetBoundingBox(this.playerEntity.bb, bb_expand, bb_expand, bb_expand, new AABBd())).isEmpty();
        if (this.playerEntity.pushTime < 0.1f && !this.playerEntity.getGamemode().hasPlayerFlight() && insideBlockOld && (movedWrong || !insideBlockNew) && !this.playerEntity.isPlayerSleeping()) {
            this.teleport(this.lastPosX, this.lastPosY, this.lastPosZ);
            return;
        }
        AABBd aabb = MathHelper.aabbGrow(this.playerEntity.bb, bb_expand, bb_expand, bb_expand, new AABBd());
        MathHelper.aabbExpand(aabb, 0.0, -0.55, 0.0, aabb);
        if (!(this.playerEntity.getGamemode().hasPlayerFlight() || this.mcServer.allowFlight || worldserver.getIsAnySolidGround(aabb))) {
            if (dy > -0.03125) {
                ++this.playerInAirTime;
                if (this.playerInAirTime > 100) {
                    LOGGER.warn(this.playerEntity.username + " was kicked for floating too long!");
                    this.kickPlayer("Flying is not enabled on this server");
                    return;
                }
            }
        } else {
            this.playerInAirTime = 0;
        }
        this.playerEntity.onGround = packetMovePlayer.onGround;
        this.mcServer.playerList.onPlayerMoved(this.playerEntity);
        this.playerEntity.handleFalling(this.playerEntity.y - oldPosY, packetMovePlayer.onGround);
    }

    public void teleport(double x, double y, double z) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, this.playerEntity.yRot, this.playerEntity.xRot);
        this.playerEntity.playerNetServerHandler.sendPacket(new PacketMovePlayer.Pos(x, y, z, false));
    }

    public void teleportAndRotate(double x, double y, double z, float yaw, float pitch) {
        this.hasMoved = false;
        this.lastPosX = x;
        this.lastPosY = y;
        this.lastPosZ = z;
        this.playerEntity.absMoveTo(x, y, z, yaw, pitch);
        this.playerEntity.playerNetServerHandler.sendPacket(new PacketMovePlayer.PosRot(x, y, z, yaw, pitch, false));
    }

    @Override
    public void handlePlayerAction(@NotNull PacketPlayerAction packetPlayerAction) {
        int spawnDistZ;
        int x = packetPlayerAction.xPosition;
        int y = packetPlayerAction.yPosition;
        int z = packetPlayerAction.zPosition;
        if (!this.canInteract() || this.playerEntity.getHeldObject() != null) {
            return;
        }
        WorldServer world = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        switch (packetPlayerAction.action) {
            case 4: {
                this.playerEntity.dropCurrentItem(false);
                return;
            }
            case 5: {
                this.playerEntity.dropCurrentItem(true);
                return;
            }
            case 6: {
                this.playerEntity.pickBlock(x, y, z, false);
                return;
            }
            case 7: {
                this.playerEntity.pickBlock(x, y, z, true);
                return;
            }
        }
        double playerDistX = this.playerEntity.x - ((double)x + 0.5);
        double playerDistY = this.playerEntity.y - ((double)y + 0.5);
        double playerDistZ = this.playerEntity.z - ((double)z + 0.5);
        double playerDist = playerDistX * playerDistX + playerDistY * playerDistY + playerDistZ * playerDistZ;
        if (playerDist > 44.0) {
            return;
        }
        boolean ignoreSpawnProtection = this.mcServer.spawnProtectionRange <= 0 || world.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        TilePos spawnPos = world.getSpawnPoint();
        int spawnDistX = (int)MathHelper.abs(x - spawnPos.x);
        int distanceFromSpawn = Math.max(spawnDistX, spawnDistZ = (int)MathHelper.abs(z - spawnPos.z));
        if (distanceFromSpawn <= this.mcServer.spawnProtectionRange && !ignoreSpawnProtection) {
            this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x, y, z, world));
            return;
        }
        if (packetPlayerAction.action == 0) {
            this.playerEntity.playerController.startMining(x, y, z, packetPlayerAction.side);
        } else if (packetPlayerAction.action == 1) {
            this.playerEntity.playerController.hitBlock(x, y, z, packetPlayerAction.side, packetPlayerAction.xHit, packetPlayerAction.yHit);
        } else if (packetPlayerAction.action == 2 && !this.playerEntity.playerController.destroyBlock(x, y, z, packetPlayerAction.side)) {
            this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x, y, z, world));
        }
    }

    public void handleSendInitialPlayerList() {
        for (PlayerServer playerServer : this.mcServer.playerList.playerEntities) {
            this.sendPacket(new PacketUpdatePlayerProfile(playerServer.username, playerServer.nickname, playerServer.uuid, playerServer.score, playerServer.chatColor, true, playerServer.isOperator()));
        }
        PlayerListBox.updateList();
    }

    @Override
    public void handleUseOrPlaceItem(@NotNull PacketUseOrPlaceItemStack packet) {
        if (!this.canInteract()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        ItemStack itemstack = this.playerEntity.inventory.getCurrentItem();
        boolean ignoreSpawnProtection = this.mcServer.spawnProtectionRange <= 0 || worldserver.dimension.id != 0 || this.mcServer.playerList.isOp(this.playerEntity.uuid);
        switch (packet.type) {
            case 0: {
                int x = packet.xPosition;
                int y = packet.yPosition;
                int z = packet.zPosition;
                Direction direction = packet.direction;
                double xPlaced = packet.xPlaced;
                double yPlaced = packet.yPlaced;
                TilePos chunkcoordinates = worldserver.getSpawnPoint();
                int i1 = (int)MathHelper.abs(x - chunkcoordinates.x);
                int j1 = (int)MathHelper.abs(z - chunkcoordinates.z);
                if (i1 > j1) {
                    j1 = i1;
                }
                if (this.hasMoved && this.playerEntity.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || ignoreSpawnProtection)) {
                    this.playerEntity.playerController.useOrPlaceItemStackOnTile(this.playerEntity, worldserver, itemstack, x, y, z, direction.getSide(), xPlaced, yPlaced);
                }
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x, y, z, worldserver));
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), worldserver));
                break;
            }
            case 1: {
                if (itemstack == null) {
                    return;
                }
                this.playerEntity.playerController.useItemStackOnNothing(this.playerEntity, worldserver, itemstack);
                break;
            }
            case 2: {
                int x = packet.xPosition;
                int y = packet.yPosition;
                int z = packet.zPosition;
                Direction direction = packet.direction;
                double xPlaced = packet.xPlaced;
                double yPlaced = packet.yPlaced;
                TilePos chunkcoordinates = worldserver.getSpawnPoint();
                int i1 = (int)MathHelper.abs(x - chunkcoordinates.x);
                int j1 = (int)MathHelper.abs(z - chunkcoordinates.z);
                if (i1 > j1) {
                    j1 = i1;
                }
                if (this.hasMoved && this.playerEntity.distanceToSqr((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 64.0 && (j1 > this.mcServer.spawnProtectionRange || ignoreSpawnProtection)) {
                    this.playerEntity.playerController.placeItemStackOnTile(this.playerEntity, worldserver, itemstack, x, y, z, direction.getSide(), xPlaced, yPlaced);
                }
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x, y, z, worldserver));
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketBlockUpdate(x += direction.getOffsetX(), y += direction.getOffsetY(), z += direction.getOffsetZ(), worldserver));
                break;
            }
        }
        itemstack = this.playerEntity.inventory.getCurrentItem();
        if (itemstack != null && itemstack.stackSize <= 0) {
            this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentSlot()] = null;
        }
        this.playerEntity.isChangingQuantityOnly = true;
        this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentSlot()] = ItemStack.copyItemStack(this.playerEntity.inventory.mainInventory[this.playerEntity.inventory.getCurrentSlot()]);
        Slot slot = this.playerEntity.craftingInventory.getSlotFor(this.playerEntity.inventory, this.playerEntity.inventory.getCurrentSlot());
        this.playerEntity.craftingInventory.broadcastChanges();
        this.playerEntity.isChangingQuantityOnly = false;
        if (slot == null) {
            LOGGER.warn("Couldn't find slot for index '{}' in {}'s inventory while they were in the {} container!", this.playerEntity.inventory.getCurrentSlot(), this.playerEntity.username, this.playerEntity.craftingInventory.getClass().getSimpleName());
            return;
        }
        if (!ItemStack.areItemStacksEqual(this.playerEntity.inventory.getCurrentItem(), packet.itemStack)) {
            this.sendPacket(new PacketContainerSetSlot(this.playerEntity.craftingInventory.containerId, slot.index, this.playerEntity.inventory.getCurrentItem()));
        }
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        LOGGER.info(this.playerEntity.username + " lost connection: " + message);
        this.mcServer.playerList.sendPacketToAllPlayers(new PacketChat(this.playerEntity.getDisplayName() + String.valueOf(TextFormatting.YELLOW) + " left the game."));
        this.mcServer.playerList.updatePlayerProfile(this.playerEntity.username, this.playerEntity.nickname, this.playerEntity.uuid, this.playerEntity.score, this.playerEntity.chatColor, false, this.playerEntity.isOperator());
        this.mcServer.playerList.playerLoggedOut(this.playerEntity);
        this.connectionClosed = true;
        if (MinecraftServer.statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
        }
        PlayerListBox.updateList();
    }

    @Override
    public void handleInvalidPacket(@NotNull Packet packet) {
        LOGGER.warn("{} wasn't prepared to deal with a {}", (Object)this.getClass(), (Object)packet.getClass());
        this.kickPlayer("Protocol error, unexpected packet");
    }

    public void sendPacket(Packet packet) {
        this.netManager.addToSendQueue(packet);
        this.field_22004_g = this.field_15_f;
    }

    @Override
    public void handleSetCarriedItem(@NotNull PacketSetCarriedItem packetSetCarriedItem) {
        if (packetSetCarriedItem.id < 0 || packetSetCarriedItem.id > 36) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.playerEntity.username);
        } else {
            this.playerEntity.inventory.setCurrentSlot(packetSetCarriedItem.id, false);
            if (packetSetCarriedItem.id != this.playerEntity.inventory.getCurrentSlot()) {
                this.sendPacket(new PacketSetCarriedItem(packetSetCarriedItem.id));
            }
        }
    }

    @Override
    public void handleChat(@NotNull PacketChat packet) {
        Object message;
        if (packet.encrypted) {
            try {
                message = AES.decrypt(packet.message, AES.keyChain.get(this.playerEntity.username));
            }
            catch (Exception e) {
                throw new RuntimeException("This crash is caused by outdated Java, please update to 8u161 or newer! If your Java version is out of date due to a technical requirement, please add the JCE Unlimited Strength Jurisdiction Policy Files to your installation. https://www.oracle.com/java/technologies/javase-jce-all-downloads.html", e);
            }
        } else {
            message = packet.message;
        }
        if (((String)message).length() > 256) {
            message = ((String)message).substring(0, 255);
        }
        message = ((String)message).trim();
        for (int i = 0; i < ((String)message).length(); ++i) {
            char c = ((String)message).charAt(i);
            if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(c) >= 0) continue;
            this.sendPacket(new PacketChat(String.valueOf(TextFormatting.GRAY) + String.valueOf(TextFormatting.ITALIC) + "[SERVER] Illegal characters in chat message."));
            return;
        }
        if (((String)message).startsWith("/")) {
            this.handleSlashCommand((String)message);
        } else {
            message = ChatEmotes.process((String)message);
            message = "<" + this.playerEntity.getDisplayName() + String.valueOf(TextFormatting.RESET) + "> " + String.valueOf(TextFormatting.WHITE) + (String)message;
            LOGGER.info((String)message);
            this.mcServer.playerList.sendEncryptedChatToAllPlayers((String)message);
        }
    }

    private void handleSlashCommand(String s) {
        ServerCommandSource serverCommandSource = new ServerCommandSource(this.mcServer, this.playerEntity);
        try {
            this.playerEntity.world.getCommandManager().execute(s.substring(1), serverCommandSource);
        }
        catch (CommandSyntaxException e) {
            this.playerEntity.playerNetServerHandler.sendPacket(new PacketChat(String.valueOf(TextFormatting.RED) + e.getMessage(), AES.keyChain.get(this.playerEntity.username)));
        }
    }

    @Override
    public void handleAnimation(@NotNull PacketAnimate packet) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (packet.animate == 1) {
            this.playerEntity.swingItem();
        }
    }

    @Override
    public void handleUpdatePlayerState(@NotNull PacketUpdatePlayerState packetUpdatePlayerState) {
        if (!this.playerEntity.isAlive()) {
            return;
        }
        if (packetUpdatePlayerState.state == 1) {
            this.playerEntity.setSneaking(true);
            if (this.playerEntity.vehicle != null) {
                this.playerEntity.vehicle.ejectRider();
            }
        } else if (packetUpdatePlayerState.state == 2) {
            this.playerEntity.setSneaking(false);
        } else if (packetUpdatePlayerState.state == 3) {
            this.playerEntity.wakeUpPlayer(false, true);
            this.hasMoved = false;
        }
    }

    @Override
    public void handleBoatControl(@NotNull PacketBoatControl packetBoatControl) {
        IVehicle iVehicle;
        if (!this.canInteract() || Double.isNaN(packetBoatControl.targetXD) || Double.isNaN(packetBoatControl.targetZD)) {
            return;
        }
        if (this.playerEntity.vehicle != null && (iVehicle = this.playerEntity.vehicle) instanceof EntityBoat) {
            EntityBoat boat = (EntityBoat)iVehicle;
            boat.handleControlDirect(packetBoatControl.targetXD, packetBoatControl.targetZD, packetBoatControl.targetYRot);
            packetBoatControl.entityId = boat.id;
            this.mcServer.playerList.sendPacketToOtherPlayersAroundPoint(this.playerEntity, boat.x, boat.y, boat.z, 128.0, boat.world.dimension.id, packetBoatControl);
        }
    }

    @Override
    public void handleDisconnect(@NotNull PacketDisconnect packetDisconnect) {
        this.netManager.networkShutdown("disconnect.quitting", new Object[0]);
    }

    public int getNumChunkDataPackets() {
        return this.netManager.getNumChunkDataPackets();
    }

    @Override
    public void logInfo(String s) {
        this.sendPacket(new PacketChat("\u00a77" + s));
    }

    @Override
    public String getUsername() {
        return this.playerEntity.username;
    }

    @Override
    public void handleEntityInteract(@NotNull PacketEntityInteract packetEntityInteract) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        Entity targetEntity = worldserver.getEntityFromId(packetEntityInteract.targetEntityID);
        if (targetEntity != null && this.playerEntity.distanceToSqr(targetEntity) < 36.0) {
            boolean canAttack = this.playerEntity.canEntityBeSeen(targetEntity);
            if (!canAttack) {
                float f1 = MathHelper.cos(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f2 = MathHelper.sin(-this.playerEntity.yRot * 0.01745329f - (float)Math.PI);
                float f3 = -MathHelper.cos(-this.playerEntity.xRot * 0.01745329f);
                float f4 = MathHelper.sin(-this.playerEntity.xRot * 0.01745329f);
                Vector3d viewVector = new Vector3d(f2 * f3, f4, f1 * f3);
                viewVector.mul(8.0);
                viewVector.add(this.playerEntity.x, this.playerEntity.y, this.playerEntity.z);
                Vector3d playerViewPos = new Vector3d(this.playerEntity.x, this.playerEntity.y + (double)this.playerEntity.getHeadHeight(), this.playerEntity.z);
                HitResult.Clip movingObjectPosition = MathHelper.aabbClip(targetEntity.bb, playerViewPos, viewVector);
                boolean bl = canAttack = movingObjectPosition != null && worldserver.checkBlockCollisionBetweenPoints(playerViewPos, movingObjectPosition.location) == null;
            }
            if (canAttack) {
                if (packetEntityInteract.action == 0) {
                    this.playerEntity.useCurrentItemOnEntity(targetEntity);
                } else if (packetEntityInteract.action == 1) {
                    this.playerEntity.attackTargetEntityWithCurrentItem(targetEntity);
                }
            }
        }
    }

    @Override
    public void handleGuidebook(@NotNull PacketGuidebook packet) {
        this.playerEntity.displayGUIGuidebook();
    }

    @Override
    public void handleRespawn(@NotNull PacketRespawn packet) {
        if (this.playerEntity.getHealth() <= 0) {
            this.playerEntity = this.mcServer.playerList.recreatePlayerEntity(this.playerEntity, 0);
        }
    }

    @Override
    public void handleContainerClose(@NotNull PacketContainerClose packetContainerClose) {
        this.playerEntity.closeCraftingGui();
    }

    @Override
    public void handleContainerClick(@NotNull PacketContainerClick packetContainerClick) {
        if (this.playerEntity.craftingInventory.containerId == packetContainerClick.window_Id && this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            ItemStack itemstack = this.playerEntity.craftingInventory.clicked(packetContainerClick.action, packetContainerClick.args, this.playerEntity);
            if (ItemStack.areItemStacksEqual(packetContainerClick.itemStack, itemstack)) {
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketContainerAck(packetContainerClick.window_Id, packetContainerClick.actionId, true));
                this.playerEntity.isChangingQuantityOnly = true;
                this.playerEntity.craftingInventory.broadcastChanges();
                this.playerEntity.updateHeldItem();
                this.playerEntity.isChangingQuantityOnly = false;
            } else {
                this.guiIdMap.put(this.playerEntity.craftingInventory.containerId, packetContainerClick.actionId);
                this.playerEntity.playerNetServerHandler.sendPacket(new PacketContainerAck(packetContainerClick.window_Id, packetContainerClick.actionId, false));
                this.playerEntity.craftingInventory.setSynched(this.playerEntity, false);
                ArrayList<ItemStack> arraylist = new ArrayList<ItemStack>();
                for (int i = 0; i < this.playerEntity.craftingInventory.slots.size(); ++i) {
                    arraylist.add(this.playerEntity.craftingInventory.slots.get(i).getItemStack());
                }
                this.playerEntity.updateCraftingInventory(this.playerEntity.craftingInventory, arraylist);
            }
        }
    }

    @Override
    public void handleContainerAck(@NotNull PacketContainerAck packet) {
        short short1 = this.guiIdMap.get(this.playerEntity.craftingInventory.containerId);
        if (packet.shortWindowId == short1 && this.playerEntity.craftingInventory.containerId == packet.windowId && !this.playerEntity.craftingInventory.isSynched(this.playerEntity)) {
            this.playerEntity.craftingInventory.setSynched(this.playerEntity, true);
        }
    }

    @Override
    public void handleSignUpdate(@NotNull PacketSignUpdate packetSignUpdate) {
        if (!this.playerEntity.getGamemode().canInteract() || !this.playerEntity.isAlive()) {
            return;
        }
        WorldServer worldserver = this.mcServer.getDimensionWorld(this.playerEntity.dimension);
        if (worldserver.isBlockLoaded(packetSignUpdate.xPosition, packetSignUpdate.yPosition, packetSignUpdate.zPosition)) {
            TileEntitySign sign;
            TileEntity tileEntity = worldserver.getTileEntity(packetSignUpdate.xPosition, packetSignUpdate.yPosition, packetSignUpdate.zPosition);
            if (tileEntity instanceof TileEntitySign && !(sign = (TileEntitySign)tileEntity).isEditableBy(this.playerEntity)) {
                LOGGER.warn("Player {} just tried to change non-editable sign", (Object)this.playerEntity.username);
                return;
            }
            for (int i = 0; i < 4; ++i) {
                boolean isLineValid = true;
                if (packetSignUpdate.signLines[i].length() > 15) {
                    isLineValid = false;
                } else {
                    packetSignUpdate.signLines[i] = packetSignUpdate.signLines[i].replaceAll("\u00a7", "$");
                    for (int l = 0; l < packetSignUpdate.signLines[i].length(); ++l) {
                        if (ChatAllowedCharacters.ALLOWED_CHARACTERS.indexOf(packetSignUpdate.signLines[i].charAt(l)) >= 0) continue;
                        isLineValid = false;
                        break;
                    }
                }
                if (isLineValid) continue;
                packetSignUpdate.signLines[i] = "!?";
            }
            if (tileEntity instanceof TileEntitySign) {
                TileEntitySign sign2 = (TileEntitySign)tileEntity;
                int x = packetSignUpdate.xPosition;
                int y = packetSignUpdate.yPosition;
                int z = packetSignUpdate.zPosition;
                System.arraycopy(packetSignUpdate.signLines, 0, sign2.signText, 0, 4);
                sign2.setColor(TextFormatting.FORMATTINGS[packetSignUpdate.color]);
                sign2.setPicture(EnumSignPicture.values()[packetSignUpdate.picture]);
                sign2.setChanged();
                worldserver.markBlockNeedsUpdate(x, y, z);
            }
        }
    }

    @Override
    public void handleUpdateCreativeInventory(@NotNull PacketUpdateCreativeInventory packet) {
        if (this.playerEntity.craftingInventory.containerId == packet.windowId && this.playerEntity.craftingInventory instanceof MenuInventoryCreative) {
            ((MenuInventoryCreative)this.playerEntity.craftingInventory).setInventoryStatus(packet.page, packet.searchText);
        }
    }

    @Override
    public void handleSetHotbarOffset(@NotNull PacketSetHotbarOffset packet) {
        this.playerEntity.inventory.setHotbarOffset(packet.hotbarOffset, false);
        if (packet.hotbarOffset != this.playerEntity.inventory.getHotbarOffset()) {
            this.sendPacket(new PacketSetHotbarOffset(packet.hotbarOffset));
        }
    }

    @Override
    public void handleSetItemName(@NotNull PacketSetItemName packet) {
        String name = packet.name;
        if (name.length() > 16) {
            name = packet.name.substring(0, 16);
        }
        this.playerEntity.inventory.getItem(packet.slot).setCustomName(name);
    }

    @Override
    public void handleSetPaintingArt(@NotNull PacketSetPaintingArt packetSetPaintingArt) {
        this.playerEntity.setSelectedArt(ArtType.values.get(packetSetPaintingArt.motive));
    }

    @Override
    public void handleCustomPayload(@NotNull PacketCustomPayload packetCustomPayload) {
        if ("BTA:RotationLock".equals(packetCustomPayload.channel)) {
            if (packetCustomPayload.data.length == 4) {
                this.playerEntity.rotationLock = Direction.getDirectionById(packetCustomPayload.data[0]);
                this.playerEntity.rotationLockHorizontal = Direction.getDirectionById(packetCustomPayload.data[1]);
                this.playerEntity.rotationLockVertical = Direction.getDirectionById(packetCustomPayload.data[2]);
                this.playerEntity.placementModeOverride = PlacementMode.get(packetCustomPayload.data[3]);
            }
        } else if ("BTA:Flag".equals(packetCustomPayload.channel)) {
            MenuAbstract menuAbstract;
            if (packetCustomPayload.data.length == 385 && (menuAbstract = this.playerEntity.craftingInventory) instanceof MenuFlag) {
                MenuFlag menuFlag = (MenuFlag)menuAbstract;
                TileEntityFlag flag = menuFlag.flag;
                if (flag.owner == null || flag.owner.equals(this.playerEntity.uuid)) {
                    flag.owner = this.playerEntity.uuid;
                    byte header = packetCustomPayload.data[0];
                    boolean flipped = (header & 1) != 0;
                    System.arraycopy(packetCustomPayload.data, 1, flag.flagColors, 0, 384);
                    flag.setFlipped(flipped);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                } else {
                    LOGGER.warn("Player '{}' tried editing a flag that belongs to '{}'!", (Object)this.playerEntity.username, (Object)flag.owner);
                    this.playerEntity.world.markBlockNeedsUpdate(flag.x, flag.y, flag.z);
                }
            }
        } else if ("BTA:WandMonster".equals(packetCustomPayload.channel) && this.playerEntity.getHeldItem() != null && this.playerEntity.getHeldItem().getItem() == Items.WAND_MONSTER_SPAWNER) {
            String id = new String(packetCustomPayload.data, StandardCharsets.UTF_8);
            this.playerEntity.getHeldItem().getData().putString("monster", id);
        }
    }

    @Override
    public void handleRequestCommandManager(@NotNull PacketRequestCommandManager packet) {
        this.sendPacket(new PacketCommandManager(this.mcServer.getDimensionWorld(this.playerEntity.dimension).getCommandManager().getDispatcher(), new ServerCommandSource(this.mcServer, this.playerEntity), packet.text, packet.cursor));
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }
}

