/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.world.chunk.provider;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.world.ProgressListener;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.EmptyChunk;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkProviderServer
implements IChunkProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<ChunkPos> droppedChunksSet = new HashSet<ChunkPos>();
    private final Chunk emptyChunk;
    public ChunkGenerator chunkGenerator;
    private final IChunkLoader chunkLoader;
    public boolean chunkLoadOverride = false;
    private final Map<ChunkPos, Chunk> chunkMap = new HashMap<ChunkPos, Chunk>();
    private final List<Chunk> chunkList = new ArrayList<Chunk>();
    private final WorldServer world;

    public ChunkProviderServer(WorldServer world, IChunkLoader chunkLoader, ChunkGenerator chunkGenerator) {
        this.emptyChunk = new EmptyChunk(world, 0, 0);
        this.world = world;
        this.chunkLoader = chunkLoader;
        this.chunkGenerator = chunkGenerator;
    }

    @Override
    public boolean isChunkLoaded(@NotNull ChunkPos chunkPos) {
        return this.chunkMap.containsKey(chunkPos);
    }

    public void dropChunk(@NotNull ChunkPos chunkPos) {
        TilePos spawnCoords = this.world.getSpawnPoint();
        int spawnDistanceX = chunkPos.x * 16 + 8 - spawnCoords.x;
        int spawnDistanceZ = chunkPos.z * 16 + 8 - spawnCoords.z;
        int r = 128;
        if (spawnDistanceX < -r || spawnDistanceX > r || spawnDistanceZ < -r || spawnDistanceZ > r) {
            this.droppedChunksSet.add(new ChunkPos(chunkPos));
        }
    }

    @Override
    @NotNull
    public Chunk prepareChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        this.droppedChunksSet.remove(chunkPos);
        Chunk chunk = this.chunkMap.get(chunkPos);
        if (chunk == null) {
            chunk = this.loadChunkFromFile(chunkPos);
            if (chunk == null) {
                if (this.chunkGenerator != null) {
                    chunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
                    chunk.fixMissingBlocks();
                } else {
                    chunk = this.emptyChunk;
                }
            }
            this.chunkMap.put(new ChunkPos(chunkPos), chunk);
            this.chunkList.add(chunk);
            chunk.checkForLightGaps();
            chunk.onLoad();
            if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
                this.populate(this, chunkPos.x, chunkPos.z);
            }
            if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z) && !this.provideChunk((int)(chunkPos.x - 1), (int)chunkPos.z).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
                this.populate(this, chunkPos.x - 1, chunkPos.z);
            }
            if (this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && !this.provideChunk((int)chunkPos.x, (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
                this.populate(this, chunkPos.x, chunkPos.z - 1);
            }
            if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && !this.provideChunk((int)(chunkPos.x - 1), (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
                this.populate(this, chunkPos.x - 1, chunkPos.z - 1);
            }
            if (this.world.getCurrentWeather() != null) {
                this.world.getCurrentWeather().doChunkLoadEffect(this.world, chunk);
            }
        }
        return chunk;
    }

    @Override
    public void regenerateChunk(@NotNull ChunkPos chunkPos) {
        this.droppedChunksSet.remove(chunkPos);
        this.chunkList.remove(this.chunkMap.get(chunkPos));
        this.chunkMap.remove(chunkPos);
        if (this.chunkGenerator == null) {
            return;
        }
        Chunk chunk = this.chunkGenerator.generate(chunkPos.x, chunkPos.z);
        chunk.fixMissingBlocks();
        this.chunkMap.put(new ChunkPos(chunkPos), chunk);
        if (!chunk.isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
            this.populate(new ChunkPos(chunkPos.x, chunkPos.z));
        }
        if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z) && !this.provideChunk((int)(chunkPos.x - 1), (int)chunkPos.z).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z + 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
            this.populate(new ChunkPos(chunkPos.x - 1, chunkPos.z));
        }
        if (this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && !this.provideChunk((int)chunkPos.x, (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x + 1, chunkPos.z)) {
            this.populate(new ChunkPos(chunkPos.x, chunkPos.z - 1));
        }
        if (this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && !this.provideChunk((int)(chunkPos.x - 1), (int)(chunkPos.z - 1)).isTerrainPopulated && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x, chunkPos.z - 1) && this.isChunkLoaded(chunkPos.x - 1, chunkPos.z)) {
            this.populate(new ChunkPos(chunkPos.x - 1, chunkPos.z - 1));
        }
    }

    @Override
    @NotNull
    public Chunk provideChunk(@NotNull ChunkPos chunkPos, boolean priority) {
        Chunk chunk = this.chunkMap.get(chunkPos);
        if (chunk == null) {
            if (this.world.findingSpawnPoint || this.chunkLoadOverride) {
                return this.prepareChunk(chunkPos, true);
            }
            return this.emptyChunk;
        }
        return chunk;
    }

    private Chunk loadChunkFromFile(@NotNull ChunkPos chunkPos) {
        if (this.chunkLoader == null) {
            return null;
        }
        try {
            Chunk chunk = this.chunkLoader.loadChunk(this.world, chunkPos.x, chunkPos.z);
            if (chunk != null) {
                chunk.lastSaveTime = this.world.getWorldTime();
            }
            return chunk;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load chunk at X:{}, Z:{} to disk!", chunkPos.x, chunkPos.z, exception);
            return null;
        }
    }

    private void saveChunkToFile(Chunk chunk) {
        if (this.chunkLoader == null) {
            return;
        }
        try {
            chunk.lastSaveTime = this.world.getWorldTime();
            this.chunkLoader.saveChunk(this.world, chunk);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to save chunk at X:{}, Z:{} to disk!", chunk.pos.x, chunk.pos.z, ioexception);
        }
    }

    @Override
    public void populate(@NotNull ChunkPos chunkPos) {
        Chunk chunk = this.provideChunk(chunkPos, true);
        if (!chunk.isTerrainPopulated) {
            chunk.isTerrainPopulated = true;
            if (this.chunkGenerator != null) {
                this.chunkGenerator.decorate(chunk);
                chunk.setChunkModified();
            }
        }
    }

    @Override
    public boolean saveChunks(boolean saveImmediately, @Nullable ProgressListener progressListener) {
        saveImmediately |= this.world.mcServer.forceSaveAllChunksOnAutosave;
        int chunksSaved = 0;
        for (Chunk chunk : this.chunkList) {
            if (!chunk.needsSaving(saveImmediately)) continue;
            this.saveChunkToFile(chunk);
            chunk.isModified = false;
            if (++chunksSaved != this.world.mcServer.chunksSavedPerAutosave || saveImmediately) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean tick() {
        if (!this.world.dontSave) {
            for (int i = 0; i < 100; ++i) {
                if (this.droppedChunksSet.isEmpty()) continue;
                ChunkPos chunkPos = this.droppedChunksSet.iterator().next();
                Chunk chunk = this.chunkMap.get(chunkPos);
                this.saveChunkToFile(chunk);
                chunk.onUnload();
                this.droppedChunksSet.remove(chunkPos);
                this.chunkMap.remove(chunkPos);
                this.chunkList.remove(chunk);
            }
        }
        return false;
    }

    @Override
    public void unloadAllChunks() {
        this.chunkMap.clear();
        this.chunkList.clear();
        this.droppedChunksSet.clear();
        this.chunkGenerator = null;
        System.gc();
    }

    @Override
    public boolean canSave() {
        return !this.world.dontSave;
    }

    @Override
    @NotNull
    public String getInfoString() {
        return "";
    }

    @Override
    public void setCurrentChunkOver(@NotNull ChunkPos chunkPos) {
    }
}

