/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicVeryRotatable;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.projectile.ProjectileArrow;
import net.minecraft.core.entity.projectile.ProjectileArrowGolden;
import net.minecraft.core.entity.projectile.ProjectileCannonball;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class BlockLogicDispenser
extends BlockLogicVeryRotatable {
    public static final int MASK_POWERED = 8;

    public BlockLogicDispenser(@NotNull Block<?> block) {
        super(block, Materials.STONE);
        block.withEntity(TileEntityDispenser::new);
    }

    @Override
    public int tickDelay() {
        return 4;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (world.isClientSide) {
            return true;
        }
        @NotNull TileEntityDispenser tileEntity = (TileEntityDispenser)Objects.requireNonNull(world.getTileEntity(tilePos));
        player.displayDispenserScreen(tileEntity);
        return true;
    }

    private void dispenseItem(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random random) {
        @NotNull Direction direction = BlockLogicVeryRotatable.metaToDirection(world.getBlockData(tilePos));
        int xOffset = direction.getOffsetX();
        int yOffset = direction.getOffsetY();
        int zOffset = direction.getOffsetZ();
        @NotNull TileEntityDispenser tileEntity = (TileEntityDispenser)Objects.requireNonNull(world.getTileEntity(tilePos));
        @Nullable ItemStack itemStack = tileEntity.getRandomStackFromInventory();
        @NotNull Vector3d pos = new Vector3d(tilePos.x(), tilePos.y(), tilePos.z()).add((double)xOffset * 0.6 + 0.5, (double)yOffset * 0.6 + 0.5, (double)zOffset * 0.6 + 0.5);
        if (itemStack == null) {
            world.playBlockEvent(tilePos, 1001, 0);
        } else {
            Item item = itemStack.getItem();
            if (item instanceof IDispensable) {
                @NotNull IDispensable dispensable = (IDispensable)((Object)item);
                dispensable.onDispensed(itemStack, world, random, direction, pos.x(), pos.y(), pos.z());
                world.playBlockEvent(tilePos, 1002, 0);
            } else if (itemStack.itemID == Items.AMMO_ARROW.id || itemStack.itemID == Items.AMMO_ARROW_GOLD.id) {
                @NotNull ProjectileArrow arrow = itemStack.itemID == Items.AMMO_ARROW.id ? new ProjectileArrow(world, pos.x(), pos.y(), pos.z(), 0) : new ProjectileArrowGolden(world, pos.x(), pos.y(), pos.z());
                arrow.setHeading(xOffset, (double)yOffset + 0.1, zOffset, 1.1f, 6.0f);
                arrow.setDoesArrowBelongToPlayer(true);
                world.entityJoinedWorld(arrow);
                world.playBlockEvent(tilePos, 1002, 0);
            } else if (itemStack.itemID == Items.AMMO_CHARGE_EXPLOSIVE.id) {
                @NotNull ProjectileCannonball projectileCannonball = new ProjectileCannonball(world, pos.x(), pos.y(), pos.z());
                projectileCannonball.setHeading(xOffset, (double)yOffset + 0.1, zOffset, 1.1f, 6.0f);
                world.entityJoinedWorld(projectileCannonball);
                world.playBlockEvent(tilePos, 1002, 0);
            } else {
                @NotNull EntityItem item2 = new EntityItem(world, pos.x(), pos.y() - 0.3, pos.z(), itemStack);
                double randOffset = random.nextDouble() * 0.1 + 0.2;
                item2.xd = (double)xOffset * randOffset;
                item2.yd = (double)yOffset + 0.2;
                item2.zd = (double)zOffset * randOffset;
                item2.xd += random.nextGaussian() * 0.0075 * 6.0;
                item2.yd += random.nextGaussian() * 0.0075 * 6.0;
                item2.zd += random.nextGaussian() * 0.0075 * 6.0;
                world.entityJoinedWorld(item2);
                world.playBlockEvent(tilePos, 1000, 0);
            }
            world.playBlockEvent(tilePos, 2000, direction.getId());
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        boolean hasNeighborSignal = world.hasNeighborSignal(tilePos);
        int data = world.getBlockData(tilePos);
        if (hasNeighborSignal && (data & 8) == 0) {
            world.scheduleBlockUpdate(tilePos, this.block, this.tickDelay());
            world.setBlockData(tilePos, data | 8);
        } else if (!hasNeighborSignal) {
            world.setBlockData(tilePos, data & 0xFFFFFFF7);
        }
    }

    @Override
    public void updateTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand, boolean isRandomTick) {
        this.dispenseItem(world, tilePos, rand);
    }
}

