/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.helpers;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.exceptions.CommandExceptions;
import net.minecraft.core.net.command.helpers.MinMaxBounds;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class EntitySelector {
    public static final String ENTITY_PREFIX = "entity.";
    private final int maxResults;
    private final boolean includesEntities;
    private final BiConsumer<Entity, List<? extends Entity>> order;
    @Nullable
    private final Class<? extends Entity> limitToType;
    private final boolean typeInverse;
    private final boolean currentEntity;
    private final Predicate<Entity> predicate;
    @Nullable
    private final String entityId;
    @Nullable
    private final String playerName;
    private final MinMaxBounds.Doubles distance;
    private final Function<@NotNull Vector3dc, @NotNull Vector3dc> position;
    @Nullable
    private final AABBd aabb;

    public EntitySelector(int maxResults, boolean includesEntities, BiConsumer<Entity, List<? extends Entity>> order, @Nullable Class<? extends Entity> limitToType, boolean typeInverse, boolean currentEntity, Predicate<Entity> predicate, @Nullable String entityId, @Nullable String playerName, MinMaxBounds.Doubles distance, @NotNull @NotNull Function<@NotNull Vector3dc, @NotNull Vector3dc> position, @Nullable AABBdc aabb) {
        this.maxResults = maxResults;
        this.includesEntities = includesEntities;
        this.order = order;
        this.limitToType = limitToType;
        this.typeInverse = typeInverse;
        this.currentEntity = currentEntity;
        this.predicate = predicate;
        this.entityId = entityId;
        this.playerName = playerName;
        this.distance = distance;
        this.position = position;
        this.aabb = aabb == null ? null : new AABBd(aabb);
    }

    public List<? extends Entity> get(CommandSource source) throws CommandSyntaxException {
        Vector3dc position;
        List<Entity> entities;
        if (this.entityId != null) {
            ArrayList<Entity> entities2 = new ArrayList<Entity>();
            for (Entity entity : source.getWorld().entities) {
                if (!(ENTITY_PREFIX + entity.hashCode()).equals(this.entityId)) continue;
                entities2.add(entity);
            }
            List list = entities2.subList(0, Math.min(entities2.size(), this.maxResults));
            if (list.isEmpty()) {
                throw CommandExceptions.emptySelector().create();
            }
            return list;
        }
        if (this.playerName != null) {
            ArrayList<Player> players = new ArrayList<Player>();
            for (Player player : source.getWorld().players) {
                if (!player.username.equals(this.playerName) && !player.nickname.equals(this.playerName)) continue;
                players.add(player);
            }
            List list = players.subList(0, Math.min(players.size(), this.maxResults));
            if (list.isEmpty()) {
                throw CommandExceptions.emptySelector().create();
            }
            return list;
        }
        if (this.currentEntity) {
            if (source.getSender() == null) {
                throw CommandExceptions.notInWorld().create();
            }
            entities = Collections.singletonList(source.getSender());
        } else {
            entities = this.includesEntities ? source.getWorld().entities : source.getWorld().players;
        }
        Vector3dc sourceCoordinates = source.getCoordinates(true);
        if (sourceCoordinates != null) {
            position = this.position.apply(sourceCoordinates);
            if (this.aabb != null) {
                this.aabb.minX += position.x();
                this.aabb.maxX += position.x();
                this.aabb.minY += position.y();
                this.aabb.maxY += position.y();
                this.aabb.minZ += position.z();
                this.aabb.maxZ += position.z();
            }
        } else {
            position = this.position.apply(new Vector3d());
        }
        ArrayList<Player> temp = new ArrayList<Player>(entities);
        for (Entity entity : entities) {
            if ((this.limitToType == null || this.limitToType.isInstance(entity) != this.typeInverse) && this.predicate.test(entity) && this.distanceContains(entity, position.x(), position.y(), position.z()) && EntitySelector.aabbIntersectsWithAABB(this.aabb, entity.bb)) continue;
            temp.remove(entity);
        }
        entities = temp;
        this.order.accept(source.getSender(), entities);
        List<Entity> listAfterPredicate = new ArrayList();
        for (Entity entity : entities) {
            if (!this.predicate.test(entity)) continue;
            listAfterPredicate.add(entity);
        }
        if ((listAfterPredicate = listAfterPredicate.subList(0, Math.min(listAfterPredicate.size(), this.maxResults))).isEmpty()) {
            throw CommandExceptions.emptySelector().create();
        }
        return listAfterPredicate;
    }

    private boolean distanceContains(Entity entity, double x, double y, double z) {
        if (this.distance.isAny()) {
            return true;
        }
        return this.distance.contains(entity.distanceTo(x, y, z));
    }

    private static boolean aabbIntersectsWithAABB(@Nullable AABBdc aabb1, @Nullable AABBdc aabb2) {
        if (aabb1 == null) {
            return true;
        }
        return aabb2 != null && aabb1.intersectsAABB((AABBd)aabb2);
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean includesEntities() {
        return this.includesEntities;
    }

    public boolean isCurrentEntity() {
        return this.currentEntity;
    }
}

