/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.block.BlockLogicBed;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.data.gamerule.GameRules;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.SpawnListEntry;
import net.minecraft.core.entity.monster.MobSkeleton;
import net.minecraft.core.entity.monster.MobSpider;
import net.minecraft.core.entity.monster.MobZombie;
import net.minecraft.core.entity.monster.MobZombieArmored;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.MobCategory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.config.spawning.SpawnerConfig;
import net.minecraft.core.world.pathfinder.Node;
import net.minecraft.core.world.pathfinder.Path;
import net.minecraft.core.world.pathfinder.PathFinder;
import net.minecraft.core.world.pos.ChunkPos;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.pos.ChunkTilePos;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.slf4j.Logger;

public final class SpawnerMobs {
    @NotNull
    private static final Logger LOGGER = LogUtils.getLogger();
    @NotNull
    private static final @NotNull Set<@NotNull ChunkPos> ELIGIBLE_CHUNKS_FOR_SPAWNING = new ObjectOpenHashSet<ChunkPos>();
    @NotNull
    private static final Class<? extends Mob>[] NIGHT_SPAWN_ENTITIES = new Class[]{MobSpider.class, MobZombie.class, MobSkeleton.class, MobZombieArmored.class};

    @NotNull
    private static TilePosc getRandomSpawningPointInChunk(@NotNull World world, @NotNull ChunkPosc chunkPos) {
        return new TilePos(chunkPos, new ChunkTilePos(world.rand.nextInt(16), world.rand.nextInt(world.getHeightBlocks()), world.rand.nextInt(16)));
    }

    public static int performSpawning(@NotNull World world, @NotNull SpawnerConfig spawnerConfig) {
        if (!spawnerConfig.canHostileSpawn(world) && !spawnerConfig.canPassiveSpawn(world)) {
            return 0;
        }
        ELIGIBLE_CHUNKS_FOR_SPAWNING.clear();
        int playersSize = world.players.size();
        for (int i = 0; i < playersSize; ++i) {
            @NotNull Player player = world.players.get(i);
            @NotNull ChunkPos playerChunk = new ChunkPos(player);
            int spawnRadius = 8;
            @NotNull ChunkPos d = new ChunkPos();
            d.x = -8;
            while (d.x <= 8) {
                d.z = -8;
                while (d.z <= 8) {
                    @NotNull ChunkPos pos = new ChunkPos();
                    if (world.isChunkLoaded(playerChunk.add(d.x, d.z, pos))) {
                        ELIGIBLE_CHUNKS_FOR_SPAWNING.add(pos);
                    }
                    ++d.z;
                }
                ++d.x;
            }
        }
        int totalSpawned = 0;
        @NotNull TilePos spawnPoint = world.getSpawnPoint();
        @NotNull ChunkPos @NotNull [] spawnChunks = new ChunkPos[9];
        for (int x = 0; x < 3; ++x) {
            for (int z = 0; z < 3; ++z) {
                spawnChunks[x * 3 + z] = new ChunkPos(spawnPoint).add(x - 1, z - 1);
            }
        }
        for (MobCategory creatureType : MobCategory.values()) {
            if (creatureType.isPeaceful() && !spawnerConfig.canPassiveSpawn(world) || !creatureType.isPeaceful() && !spawnerConfig.canHostileSpawn(world) || world.countEntities(creatureType.getBaseClass()) > creatureType.getMaxCreaturesPerChunk() * ELIGIBLE_CHUNKS_FOR_SPAWNING.size() / 256) continue;
            block8: for (ChunkPos chunk : ELIGIBLE_CHUNKS_FOR_SPAWNING) {
                TilePosc mobSpawnPos;
                EntityDispatcher.EntityDispatcherEntry<? extends Entity> entry;
                TilePos blockPos;
                Biome biome;
                List<SpawnListEntry> spawnableList;
                boolean checkSpawnDist = false;
                for (ChunkPos c : spawnChunks) {
                    if (!c.equals(chunk)) continue;
                    checkSpawnDist = true;
                    break;
                }
                if (!world.isChunkLoaded(chunk) || (spawnableList = (biome = world.getBlockBiome(blockPos = new TilePos(chunk).add(0, world.getHeightBlocks() - 1, 0))).getSpawnableList(creatureType)).isEmpty()) continue;
                int totalSpawnRarity = 0;
                for (SpawnListEntry listEntry : spawnableList) {
                    totalSpawnRarity += listEntry.spawnFrequency;
                }
                int calculatedSpawnChance = world.rand.nextInt(totalSpawnRarity);
                @NotNull SpawnListEntry spawnListEntry = spawnableList.get(0);
                for (SpawnListEntry listEntry : spawnableList) {
                    if ((calculatedSpawnChance -= listEntry.spawnFrequency) >= 0) continue;
                    spawnListEntry = listEntry;
                    break;
                }
                if ((entry = EntityDispatcher.getInstance().entryForClass(spawnListEntry.entityClass)) == null || !spawnerConfig.canMobSpawn(entry.namespaceID) || world.isBlockNormalCube(mobSpawnPos = SpawnerMobs.getRandomSpawningPointInChunk(world, chunk)) || world.getBlockMaterial(mobSpawnPos) != creatureType.getSpawnMaterial()) continue;
                int countSpawned = 0;
                int range = 6;
                @NotNull TilePos iPos = new TilePos();
                for (int i = 0; i < 3; ++i) {
                    iPos.set(mobSpawnPos);
                    for (int spawnAttempt = 0; spawnAttempt < 4; ++spawnAttempt) {
                        Mob mobToSpawn;
                        double spawnDistanceZ;
                        double spawnDistanceY;
                        double spawnDistanceX;
                        double spawnDistanceSquared;
                        double dz;
                        double dy;
                        double dx;
                        iPos.x += world.rand.nextInt(6) - world.rand.nextInt(6);
                        iPos.y += world.rand.nextInt(2) - world.rand.nextInt(2);
                        iPos.z += world.rand.nextInt(6) - world.rand.nextInt(6);
                        if (!world.isBlockLoaded(iPos) || !SpawnerMobs.canCreatureTypeSpawnAtLocation(creatureType, world, iPos) || world.getClosestPlayer(dx = (double)iPos.x + 0.5, dy = (double)iPos.y, dz = (double)iPos.z + 0.5, 24.0) != null || checkSpawnDist && (spawnDistanceSquared = (spawnDistanceX = dx - (double)spawnPoint.x) * spawnDistanceX + (spawnDistanceY = dy - (double)spawnPoint.y) * spawnDistanceY + (spawnDistanceZ = dz - (double)spawnPoint.z) * spawnDistanceZ) < 576.0) continue;
                        try {
                            mobToSpawn = (Mob)EntityDispatcher.getInstance().createEntityInWorld(spawnListEntry.entityClass, world);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error spawning entity class '{}'! Skipping spawn attempt!", (Object)spawnListEntry.entityClass.getSimpleName(), (Object)e);
                            return totalSpawned;
                        }
                        if (mobToSpawn == null) {
                            return totalSpawned;
                        }
                        mobToSpawn.moveTo(dx, dy, dz, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (!mobToSpawn.canSpawnHere()) continue;
                        if (countSpawned >= mobToSpawn.getMaxSpawnedInChunk()) continue block8;
                        ++countSpawned;
                        mobToSpawn.spawnInit();
                        world.entityJoinedWorld(mobToSpawn);
                    }
                }
                totalSpawned += countSpawned;
            }
        }
        return totalSpawned;
    }

    private static boolean canCreatureTypeSpawnAtLocation(@NotNull MobCategory mobCategory, @NotNull World world, @NotNull TilePosc tilePos) {
        if (mobCategory.getSpawnMaterial() == Materials.WATER) {
            return world.getBlockMaterial(tilePos).isLiquid() && !world.isBlockNormalCube(tilePos.up(new TilePos())) && world.getBlockData(tilePos) == 0;
        }
        return world.isBlockNormalCube(tilePos.down(new TilePos())) && !world.isBlockNormalCube(tilePos) && !world.getBlockMaterial(tilePos).isLiquid();
    }

    public static boolean isUnsafeToSleep(@NotNull World world, @NotNull Player player) {
        if (!world.getGameRuleValue(GameRules.DO_NIGHTMARES).booleanValue()) {
            return false;
        }
        if (player.isPlayerSleeping()) {
            return false;
        }
        if (player.getGamemode().hasInvulnerablePlayer()) {
            return false;
        }
        @NotNull Class<? extends Mob>[] entityClasses = NIGHT_SPAWN_ENTITIES;
        if (entityClasses != null && entityClasses.length != 0) {
            boolean willSpawnEntity = false;
            @NotNull PathFinder pathFinder = new PathFinder(world);
            int i = 0;
            while (i < 20) {
                @NotNull TilePos initSpawnPos = new TilePos(MathHelper.floor(player.x) + world.rand.nextInt(32) - world.rand.nextInt(32), MathHelper.clamp(MathHelper.floor(player.y) + world.rand.nextInt(16) - world.rand.nextInt(16), 1, world.getHeightBlocks()), MathHelper.floor(player.z) + world.rand.nextInt(32) - world.rand.nextInt(32));
                @NotNull TilePos spawnPos = new TilePos(initSpawnPos.x(), initSpawnPos.y() - 1, initSpawnPos.z());
                while (spawnPos.y > 2 && !world.isBlockNormalCube(spawnPos)) {
                    --spawnPos.y;
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(MobCategory.MONSTER, world, spawnPos) && spawnPos.y < initSpawnPos.y() + 16 && spawnPos.y < world.getHeightBlocks()) {
                    ++spawnPos.y;
                }
                if (spawnPos.y < initSpawnPos.y() + 16) {
                    Path entityPath;
                    Mob entity;
                    float entityX = (float)spawnPos.x + 0.5f;
                    float entityY = spawnPos.y;
                    float entityZ = (float)spawnPos.z + 0.5f;
                    Class<? extends Mob> eClass = entityClasses[world.rand.nextInt(entityClasses.length)];
                    try {
                        entity = EntityDispatcher.getInstance().createEntityInWorld(eClass, world);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception instancing class '{}'!", (Object)eClass.getSimpleName(), (Object)e);
                        continue;
                    }
                    if (entity == null) continue;
                    entity.moveTo(entityX, entityY, entityZ, world.rand.nextFloat() * 360.0f, 0.0f);
                    if (entity.canSpawnHere() && (entityPath = pathFinder.findPath(entity, player, 32.0f)) != null && entityPath.length > 1) {
                        boolean isCollisionFree;
                        @Nullable Node pathPoint = entityPath.last();
                        if (pathPoint == null) continue;
                        boolean bl = isCollisionFree = world.checkBlockCollisionBetweenPoints(new Vector3d(player.x, player.y + 1.5, player.z), new Vector3d(pathPoint.x, (float)pathPoint.y + 1.5f, pathPoint.z)) == null;
                        if (Math.abs((double)((float)pathPoint.x + 0.5f) - player.x) < 1.5 && Math.abs((double)((float)pathPoint.z + 0.5f) - player.z) < 1.5 && Math.abs((double)((float)pathPoint.y + 0.5f) - player.y) < 1.5 && isCollisionFree) {
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean performSleepSpawning(@NotNull World world, @NotNull @NotNull List<@NotNull Player> list) {
        if (!world.getGameRuleValue(GameRules.DO_NIGHTMARES).booleanValue()) {
            return false;
        }
        boolean spawnedEntity = false;
        @NotNull PathFinder pathFinder = new PathFinder(world);
        for (Player player : list) {
            Class<? extends Mob>[] entityClasses;
            if (!player.isPlayerSleeping() || player.getGamemode().hasInvulnerablePlayer() || (entityClasses = NIGHT_SPAWN_ENTITIES) == null || entityClasses.length == 0) continue;
            boolean spawnedEntityForPlayer = false;
            int i = 0;
            while (i < 20 && !spawnedEntityForPlayer) {
                @NotNull TilePos initSpawnPos = new TilePos(MathHelper.floor(player.x) + world.rand.nextInt(32) - world.rand.nextInt(32), MathHelper.clamp(MathHelper.floor(player.y) + world.rand.nextInt(16) - world.rand.nextInt(16), 1, world.getHeightBlocks()), MathHelper.floor(player.z) + world.rand.nextInt(32) - world.rand.nextInt(32));
                @NotNull TilePos spawnPos = new TilePos(initSpawnPos.x(), initSpawnPos.y() - 1, initSpawnPos.z());
                while (spawnPos.y > 2 && !world.isBlockNormalCube(spawnPos)) {
                    --spawnPos.y;
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(MobCategory.MONSTER, world, spawnPos) && spawnPos.y < initSpawnPos.y() + 16 && spawnPos.y < world.getHeightBlocks()) {
                    ++spawnPos.y;
                }
                if (spawnPos.y < initSpawnPos.y() + 16) {
                    Path pathEntity;
                    Mob entity;
                    float entityX = (float)spawnPos.x + 0.5f;
                    float entityY = spawnPos.y;
                    float entityZ = (float)spawnPos.z + 0.5f;
                    Class<? extends Mob> eClass = entityClasses[world.rand.nextInt(entityClasses.length)];
                    try {
                        entity = EntityDispatcher.getInstance().createEntityInWorld(eClass, world);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception instancing class '{}'!", (Object)eClass.getSimpleName(), (Object)e);
                        continue;
                    }
                    if (entity == null) continue;
                    entity.moveTo(entityX, entityY, entityZ, world.rand.nextFloat() * 360.0f, 0.0f);
                    if (entity.canSpawnHere() && (pathEntity = pathFinder.findPath(entity, player, 32.0f)) != null && pathEntity.length > 1) {
                        boolean isCollisionFree;
                        @Nullable Node pathPoint = pathEntity.last();
                        if (pathPoint == null) continue;
                        boolean bl = isCollisionFree = world.checkBlockCollisionBetweenPoints(new Vector3d(player.x, player.y + 1.5, player.z), new Vector3d(pathPoint.x, (float)pathPoint.y + 1.5f, pathPoint.z)) == null;
                        if (Math.abs((double)((float)pathPoint.x + 0.5f) - player.x) < 1.5 && Math.abs((double)((float)pathPoint.z + 0.5f) - player.z) < 1.5 && Math.abs((double)((float)pathPoint.y + 0.5f) - player.y) < 1.5 && isCollisionFree) {
                            TilePos emptyPos = BlockLogicBed.getNearestEmptyTilePos(world, new TilePos(player), 1);
                            if (emptyPos == null) {
                                emptyPos = spawnPos.up(new TilePos());
                            }
                            entity.moveTo((float)emptyPos.x + 0.5f, emptyPos.y, (float)emptyPos.z + 0.5f, 0.0f, 0.0f);
                            entity.spawnInit();
                            world.entityJoinedWorld(entity);
                            player.wakeUpPlayer(true, false);
                            @NotNull TilePos playerDown = new TilePos(player).down();
                            world.playBlockEvent(null, playerDown, 2001, world.getBlockType(playerDown).id());
                            entity.playLivingSound();
                            spawnedEntity = true;
                            spawnedEntityForPlayer = true;
                        }
                    }
                }
                ++i;
            }
        }
        return spawnedEntity;
    }
}

