/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.pos.ChunkTilePosc;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;

public final class TilePos
implements Externalizable,
Cloneable,
TilePosc {
    public int x;
    public int y;
    public int z;

    public TilePos() {
        this.x = 0;
        this.y = 0;
        this.z = 0;
    }

    public TilePos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public TilePos(@NotNull TilePosc tilePos) {
        this(tilePos.x(), tilePos.y(), tilePos.z());
    }

    public TilePos(float x, float y, float z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(double x, double y, double z) {
        this(MathHelper.floor(x), MathHelper.floor(y), MathHelper.floor(z));
    }

    public TilePos(@NotNull ChunkPosc chunkPos) {
        this(chunkPos.x() * 16, 0, chunkPos.z() * 16);
    }

    public TilePos(@NotNull ChunkPosc chunkPos, @NotNull ChunkTilePosc chunkTilePos) {
        this(chunkPos.x() * 16 + chunkTilePos.x(), chunkTilePos.y(), chunkPos.z() * 16 + chunkTilePos.z());
    }

    public TilePos(@NotNull Vector3dc vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public TilePos(@NotNull Vector3fc vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public TilePos(@NotNull Vector3ic vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public TilePos(@NotNull Entity entity) {
        this(entity.x, entity.y, entity.z);
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int y() {
        return this.y;
    }

    @Override
    public int z() {
        return this.z;
    }

    @NotNull
    public TilePos set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    @NotNull
    public TilePos set(@NotNull TilePosc pos) {
        this.x = pos.x();
        this.y = pos.y();
        this.z = pos.z();
        return this;
    }

    @Override
    @NotNull
    public TilePos add(int x, int y, int z, @NotNull TilePos dest) {
        return dest.set(this.x + x, this.y + y, this.z + z);
    }

    @Override
    @NotNull
    public TilePos add(@NotNull Vector3ic v, @NotNull TilePos dest) {
        return this.add(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public TilePos add(@NotNull Direction dir, @NotNull TilePos dest) {
        return this.add(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public TilePos add(int x, int y, int z) {
        return this.add(x, y, z, this);
    }

    @NotNull
    public TilePos add(@NotNull Vector3ic v) {
        return this.add(v, this);
    }

    @NotNull
    public TilePos add(@NotNull Direction dir) {
        return this.add(dir, this);
    }

    @Override
    @NotNull
    public TilePos sub(int x, int y, int z, @NotNull TilePos dest) {
        return dest.set(this.x - x, this.y - y, this.z - z);
    }

    @Override
    @NotNull
    public TilePos sub(@NotNull Vector3ic v, @NotNull TilePos dest) {
        return this.sub(v.x(), v.y(), v.z(), dest);
    }

    @Override
    @NotNull
    public TilePos sub(@NotNull Direction dir, @NotNull TilePos dest) {
        return this.sub(dir.getOffsetX(), dir.getOffsetY(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public TilePos sub(int x, int y, int z) {
        return this.sub(x, y, z, this);
    }

    @NotNull
    public TilePos sub(@NotNull Vector3ic v) {
        return this.sub(v, this);
    }

    @NotNull
    public TilePos sub(@NotNull Direction dir) {
        return this.sub(dir, this);
    }

    @Override
    public double distance(@NotNull TilePosc pos) {
        return this.distance(pos.x(), pos.y(), pos.z());
    }

    @Override
    public double distance(@NotNull Vector3fc v) {
        return this.distance(v.x(), v.y(), v.z());
    }

    @Override
    public double distance(@NotNull Vector3dc v) {
        return this.distance(v.x(), v.y(), v.z());
    }

    @Override
    public double distance(@NotNull Entity e) {
        return this.distance(e.x, e.y, e.z);
    }

    @Override
    public double distance(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distance(float x, float y, float z) {
        float dx = (float)this.x - x;
        float dy = (float)this.y - y;
        float dz = (float)this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distance(double x, double y, double z) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        double dz = (double)this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    @Override
    public double distanceSquared(@NotNull TilePosc pos) {
        return this.distanceSquared(pos.x(), pos.y(), pos.z());
    }

    @Override
    public double distanceSquared(@NotNull Vector3fc v) {
        return this.distanceSquared(v.x(), v.y(), v.z());
    }

    @Override
    public double distanceSquared(@NotNull Vector3dc v) {
        return this.distanceSquared(v.x(), v.y(), v.z());
    }

    @Override
    public double distanceSquared(@NotNull Entity e) {
        return this.distanceSquared(e.x, e.y, e.z);
    }

    @Override
    public double distanceSquared(int x, int y, int z) {
        int dx = this.x - x;
        int dy = this.y - y;
        int dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public double distanceSquared(float x, float y, float z) {
        float dx = (float)this.x - x;
        float dy = (float)this.y - y;
        float dz = (float)this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public double distanceSquared(double x, double y, double z) {
        double dx = (double)this.x - x;
        double dy = (double)this.y - y;
        double dz = (double)this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    @Override
    public boolean inBounds(@NotNull WorldSource source) {
        return this.x >= -32000000 && this.y >= 0 && this.z >= -32000000 && this.x <= 32000000 && this.y <= source.getHeightBlocks() && this.z <= 32000000;
    }

    @Override
    public boolean equals(int x, int y, int z) {
        return this.x == x && this.y == y && this.z == z;
    }

    @Override
    @NotNull
    public TilePos up(@NotNull TilePos dest) {
        return this.add(Direction.UP, dest);
    }

    @NotNull
    public TilePos up() {
        return this.add(Direction.UP);
    }

    @Override
    @NotNull
    public TilePos down(@NotNull TilePos dest) {
        return this.add(Direction.DOWN, dest);
    }

    @NotNull
    public TilePos down() {
        return this.add(Direction.DOWN);
    }

    @Override
    @NotNull
    public TilePos north(@NotNull TilePos dest) {
        return this.add(Direction.NORTH, dest);
    }

    @NotNull
    public TilePos north() {
        return this.add(Direction.NORTH);
    }

    @Override
    @NotNull
    public TilePos south(@NotNull TilePos dest) {
        return this.add(Direction.SOUTH, dest);
    }

    @NotNull
    public TilePos south() {
        return this.add(Direction.SOUTH);
    }

    @Override
    @NotNull
    public TilePos west(@NotNull TilePos dest) {
        return this.add(Direction.WEST, dest);
    }

    @NotNull
    public TilePos west() {
        return this.add(Direction.WEST);
    }

    @Override
    @NotNull
    public TilePos east(@NotNull TilePos dest) {
        return this.add(Direction.EAST, dest);
    }

    @NotNull
    public TilePos east() {
        return this.add(Direction.EAST);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof TilePos) {
            @NotNull TilePos other = (TilePos)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return MathHelper.cantor(MathHelper.cantor(this.x, this.y), this.z);
    }

    public String toString() {
        return "(" + this.x + " " + this.y + " " + this.z + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.y);
        out.writeInt(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.set(in.readInt(), in.readInt(), in.readInt());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

