/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import org.jetbrains.annotations.NotNull;

public enum BuildChannel {
    RELEASE,
    PRERELEASE,
    DEVELOPMENT,
    NIGHTLY;


    public boolean isUnstableBuild() {
        return this != RELEASE;
    }

    @NotNull
    public String modifyVersionString(@NotNull String version) {
        if (this == RELEASE || this == PRERELEASE) {
            return version;
        }
        if (this == DEVELOPMENT) {
            return version + " INDEV";
        }
        @NotNull Object channel = this.name().toLowerCase();
        channel = ((String)channel).substring(0, 1).toUpperCase() + ((String)channel).substring(1);
        return version + " [" + (String)channel + "]";
    }
}

