/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.ListTag;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLightning;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.animal.MobPig;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.entity.vehicle.EntityBoat;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.ICarriable;
import net.minecraft.core.world.IVehicle;
import net.minecraft.core.world.World;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3dc;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public abstract class Entity
implements IVehicle {
    public static final int DATA_SHARED_FLAGS_ID = 0;
    public static final int FLAG_ONFIRE = 0;
    public static final int FLAG_SNEAKING = 1;
    public static final int FLAG_RIDING = 2;
    public static final int FLAG_SPRINTING = 3;
    private static int entityCounter = 0;
    public int id = entityCounter++;
    public double viewScale = 1.0;
    public boolean blocksBuilding = false;
    @Nullable
    public Entity passenger;
    @Nullable
    public IVehicle vehicle;
    @NotNull
    public World world;
    public double xo;
    public double yo;
    public double zo;
    public double x;
    public double y;
    public double z;
    public double xd;
    public double yd;
    public double zd;
    public float yRot;
    public float xRot;
    public float yRotO;
    public float xRotO;
    public float pushTime;
    public int pushesThisTick;
    @NotNull
    public final AABBd bb = new AABBd();
    public boolean onGround = false;
    public boolean horizontalCollision;
    public boolean verticalCollision;
    public boolean collision = false;
    public boolean hurtMarked = false;
    public boolean hadNicknameSet;
    public boolean stuckInCobweb;
    public boolean stuckInSpikes;
    public boolean slide = true;
    public boolean removed = false;
    public float heightOffset = 0.0f;
    public float bbWidth = 0.6f;
    public float bbHeight = 1.825f;
    public float walkDistO = 0.0f;
    public float walkDist = 0.0f;
    public float fallDistance = 0.0f;
    private int nextStep = 1;
    public float ySlideOffset = 0.0f;
    public float footSize = 0.0f;
    public boolean noPhysics = false;
    public float pushthrough = 0.0f;
    @NotNull
    protected Random random = new Random();
    public int tickCount;
    public int fireImmuneTicks = 1;
    public int remainingFireTicks = 0;
    public int maxFireTicks;
    private int soundCooldown;
    protected int airMaxSupply = 300;
    protected boolean wasInWater = false;
    public int heartsFlashTime = 0;
    public int airSupply = 300;
    private boolean firstTick = true;
    protected boolean fireImmune;
    @NotNull
    protected SynchedEntityData entityData = new SynchedEntityData();
    public float entityBrightness = 0.0f;
    private double entityRiderPitchDelta;
    private double entityRiderYawDelta;
    public boolean addedToChunk = false;
    public int chunkCoordX;
    public int chunkCoordY;
    public int chunkCoordZ;
    public int serverPosX;
    public int serverPosY;
    public int serverPosZ;
    public boolean ignoreFrustumCheck;
    public boolean isWalking = false;
    protected boolean muteStepSounds = false;
    public float speed;
    public float flySpeed;
    public boolean sendAdditionalData = false;
    public boolean turnWithVehicle = true;

    public Entity(@NotNull World world) {
        this.world = world;
        this.setPos(0.0, 0.0, 0.0);
        this.entityData.define(0, (byte)0, Byte.class);
        this.defineSynchedData();
    }

    protected abstract void defineSynchedData();

    public void spawnInit() {
    }

    @NotNull
    public SynchedEntityData getEntityData() {
        return this.entityData;
    }

    public boolean equals(@Nullable Object that) {
        if (that instanceof Entity) {
            return ((Entity)that).id == this.id;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    protected void resetPos() {
        while (!(this.y <= 0.0)) {
            this.setPos(this.x, this.y, this.z);
            if (this.world.getCubes(this, this.bb).isEmpty()) break;
            this.y += 1.0;
        }
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.xRot = 0.0f;
    }

    public void remove() {
        this.removed = true;
    }

    public boolean showBoundingBoxOnHover() {
        return false;
    }

    protected final void setSize(float width, float height) {
        this.bbWidth = width;
        this.bbHeight = height;
    }

    public final void setRot(float yRot, float xRot) {
        this.yRot = yRot % 360.0f;
        this.xRot = xRot % 360.0f;
    }

    public void setPos(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.setBounds();
    }

    public void setBounds() {
        double center = (double)this.bbWidth / 2.0;
        double heightOfMob = this.bbHeight;
        this.bb.setMin(this.x - center, this.y - (double)this.heightOffset + (double)this.ySlideOffset, this.z - center);
        this.bb.setMax(this.x + center, this.y - (double)this.heightOffset + (double)this.ySlideOffset + heightOfMob, this.z + center);
    }

    public void interpolateTurn(float yRot, float xRot) {
        float xRotCurrent = this.xRot;
        float yRotCurrent = this.yRot;
        this.yRot = (float)((double)this.yRot + (double)yRot * 0.15);
        this.xRot = (float)((double)this.xRot - (double)xRot * 0.15);
        if (this.xRot < -90.0f) {
            this.xRot = -90.0f;
        }
        if (this.xRot > 90.0f) {
            this.xRot = 90.0f;
        }
        this.xRotO += this.xRot - xRotCurrent;
        this.yRotO += this.yRot - yRotCurrent;
    }

    public void tick() {
        this.baseTick();
    }

    public void baseTick() {
        this.pushesThisTick = 0;
        this.pushTime *= 0.98f;
        if (this.pushTime < 0.001f) {
            this.pushTime = 0.0f;
        }
        if (this.vehicle != null && this.vehicle.isRemoved()) {
            this.vehicle = null;
        }
        ++this.tickCount;
        this.walkDistO = this.walkDist;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xRotO = this.xRot;
        this.yRotO = this.yRot;
        this.checkOnWater(true);
        if (this.world.isClientSide) {
            this.remainingFireTicks = 0;
        } else if (this.remainingFireTicks > 0) {
            if (this.fireImmune) {
                this.remainingFireTicks -= 4;
                if (this.remainingFireTicks < 0) {
                    this.remainingFireTicks = 0;
                }
            } else {
                if (this.remainingFireTicks % 20 == 0) {
                    this.hurt(null, 1, DamageType.FIRE);
                }
                --this.remainingFireTicks;
            }
        }
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
        if (this.isInLava()) {
            this.lavaHurt();
        }
        if (this.isInWater()) {
            this.waterHurt();
        }
        if (this.y < -64.0) {
            this.outOfWorld();
        }
        if (!this.world.isClientSide) {
            this.setSharedFlag(0, this.remainingFireTicks > 0);
            this.setSharedFlag(2, this.vehicle != null);
        }
        this.firstTick = false;
    }

    protected void checkOnWater(boolean addVelocity) {
        if (this.checkAndHandleWater(addVelocity)) {
            if (!this.wasInWater && !this.firstTick) {
                double offZ;
                double offX;
                float f = MathHelper.sqrt(this.xd * this.xd * 0.2 + this.yd * this.yd + this.zd * this.zd * 0.2) * 0.2f;
                if (f > 1.0f) {
                    f = 1.0f;
                }
                if (!Global.isServer) {
                    this.world.playSoundAtEntity(null, this, "random.splash", f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                } else if (!this.world.isClientSide && this.soundCooldown == 0) {
                    this.soundCooldown = 2;
                    this.world.playSoundAtEntity(this, this, "random.splash", f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                }
                float f1 = MathHelper.floor(this.bb.minY);
                int i = 0;
                while ((float)i < 1.0f + this.bbWidth * 20.0f) {
                    offX = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    offZ = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.world.spawnParticle("bubble", this.x + offX, f1 + 1.0f, this.z + offZ, this.xd, this.yd - (double)(this.random.nextFloat() * 0.2f), this.zd, 0);
                    ++i;
                }
                int j = 0;
                while ((float)j < 1.0f + this.bbWidth * 20.0f) {
                    offX = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    offZ = (this.random.nextFloat() * 2.0f - 1.0f) * this.bbWidth;
                    this.world.spawnParticle("splash", this.x + offX, f1 + 1.0f, this.z + offZ, this.xd, this.yd, this.zd, 0);
                    ++j;
                }
            }
            this.fallDistance = 0.0f;
            this.wasInWater = true;
            this.remainingFireTicks = 0;
        } else {
            this.wasInWater = false;
        }
    }

    public void waterHurt() {
        if (this.world.dimension == Dimension.NETHER && !(this.vehicle instanceof EntityBoat)) {
            this.hurt(null, 1, DamageType.FIRE);
        }
    }

    public void lavaHurt() {
        if (!this.fireImmune) {
            this.hurt(null, 4, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = 600;
        }
    }

    public void fireHurt() {
        if (!this.fireImmune) {
            this.hurt(null, 1, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = 300;
        }
    }

    public void outOfWorld() {
        this.remove();
    }

    public boolean isFree(double x, double y, double z) {
        AABBd offsetBb = new AABBd();
        MathHelper.aabbGrow(this.bb.translate(x, y, z, offsetBb), -0.01, -0.01, -0.01, offsetBb);
        List<AABBdc> list = this.world.getCubes(this, offsetBb);
        if (!list.isEmpty()) {
            return false;
        }
        return !this.world.getIsAnyLiquid(offsetBb);
    }

    public void move(double xd, double yd, double zd) {
        int maxZ;
        int maxY;
        int maxX;
        int minZ;
        int minY;
        int minX;
        boolean touchedWall;
        int i;
        if (this.noPhysics) {
            this.onGround = false;
            this.bb.translate(xd, yd, zd);
            this.x = (this.bb.minX + this.bb.maxX) / 2.0;
            this.y = this.bb.minY + (double)this.heightOffset - (double)this.ySlideOffset;
            this.z = (this.bb.minZ + this.bb.maxZ) / 2.0;
            return;
        }
        this.ySlideOffset *= 0.4f;
        double d3 = this.x;
        double d4 = this.z;
        if (this.stuckInCobweb) {
            xd *= 0.25;
            this.xd = 0.0;
            zd *= 0.25;
            this.zd = 0.0;
            yd *= 0.05;
            this.yd = 0.0;
            this.stuckInCobweb = false;
        }
        if (this.stuckInSpikes) {
            xd *= 0.25;
            this.xd = 0.0;
            zd *= 0.25;
            this.zd = 0.0;
            this.yd = 0.0;
            this.stuckInSpikes = false;
        }
        double oldXd = xd;
        double oldYd = yd;
        double oldZd = zd;
        AABBd bbCopy = new AABBd(this.bb);
        double bbWidth = this.bb.maxX - this.bb.minX - 0.05;
        if (this.isSneaking()) {
            AABBdc bb1;
            int i2;
            List<AABBdc> collidingBoxes;
            AABBd floor;
            if (xd != 0.0) {
                floor = new AABBd(this.bb.minX, this.bb.minY - 1.0, this.bb.minZ, this.bb.maxX, this.bb.minY, this.bb.maxZ);
                MathHelper.aabbExpand(floor, xd, 0.0, 0.0, floor);
                collidingBoxes = this.world.getCubes(this, floor);
                if (!collidingBoxes.isEmpty()) {
                    double limitX = 0.0;
                    for (i2 = 0; i2 < collidingBoxes.size(); ++i2) {
                        bb1 = collidingBoxes.get(i2);
                        limitX = xd < 0.0 ? Math.min(limitX, bb1.minX() - bbWidth - this.bb.minX) : Math.max(limitX, bb1.maxX() + bbWidth - this.bb.maxX);
                    }
                    oldXd = xd < 0.0 ? (xd = Math.max(xd, limitX)) : (xd = Math.min(xd, limitX));
                }
            }
            if (zd != 0.0) {
                floor = new AABBd(this.bb.minX, this.bb.minY - 1.0, this.bb.minZ, this.bb.maxX, this.bb.minY, this.bb.maxZ);
                MathHelper.aabbExpand(floor, 0.0, 0.0, zd, floor);
                collidingBoxes = this.world.getCubes(this, floor);
                if (!collidingBoxes.isEmpty()) {
                    double limitZ = 0.0;
                    for (i2 = 0; i2 < collidingBoxes.size(); ++i2) {
                        bb1 = collidingBoxes.get(i2);
                        limitZ = zd < 0.0 ? Math.min(limitZ, bb1.minZ() - bbWidth - this.bb.minZ) : Math.max(limitZ, bb1.maxZ() + bbWidth - this.bb.maxZ);
                    }
                    oldZd = zd < 0.0 ? (zd = Math.max(zd, limitZ)) : (zd = Math.min(zd, limitZ));
                }
            }
        }
        List<AABBdc> cubes = this.world.getCubes(this, MathHelper.aabbExpand(this.bb, xd, yd, zd, new AABBd()));
        for (i = 0; i < cubes.size(); ++i) {
            yd = MathHelper.aabbClipYCollide(cubes.get(i), this.bb, yd);
        }
        this.bb.translate(0.0, yd, 0.0);
        if (!this.slide && oldYd != yd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        for (i = 0; i < cubes.size(); ++i) {
            xd = MathHelper.aabbClipXCollide(cubes.get(i), this.bb, xd);
        }
        this.bb.translate(xd, 0.0, 0.0);
        if (!this.slide && oldXd != xd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        for (i = 0; i < cubes.size(); ++i) {
            zd = MathHelper.aabbClipZCollide(cubes.get(i), this.bb, zd);
        }
        this.bb.translate(0.0, 0.0, zd);
        if (!this.slide && oldZd != zd) {
            zd = 0.0;
            yd = 0.0;
            xd = 0.0;
        }
        boolean touchedGround = this.onGround || oldYd != yd && oldYd < 0.0;
        boolean bl = touchedWall = oldXd != xd || oldZd != zd;
        if (this.footSize > 0.0f && touchedGround && touchedWall && (this.isSneaking() || this.ySlideOffset < 0.05f)) {
            int i3;
            double oldX = xd;
            double oldY = yd;
            double oldZ = zd;
            xd = oldXd;
            yd = this.footSize;
            zd = oldZd;
            AABBd aabbCopy = new AABBd(this.bb);
            this.bb.set(bbCopy);
            cubes = this.world.getCubes(this, MathHelper.aabbExpand(this.bb, xd, 0.0, zd, new AABBd()));
            for (i3 = 0; i3 < cubes.size(); ++i3) {
                yd = MathHelper.aabbClipYCollide(cubes.get(i3), this.bb, yd);
            }
            this.bb.translate(0.0, yd, 0.0);
            if (!this.slide && oldYd != yd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            for (i3 = 0; i3 < cubes.size(); ++i3) {
                xd = MathHelper.aabbClipXCollide(cubes.get(i3), this.bb, xd);
            }
            this.bb.translate(xd, 0.0, 0.0);
            if (!this.slide && oldXd != xd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            for (i3 = 0; i3 < cubes.size(); ++i3) {
                zd = MathHelper.aabbClipZCollide(cubes.get(i3), this.bb, zd);
            }
            this.bb.translate(0.0, 0.0, zd);
            if (!this.slide && oldZd != zd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            }
            if (!this.slide && oldYd != yd) {
                zd = 0.0;
                yd = 0.0;
                xd = 0.0;
            } else {
                yd = -this.footSize;
                for (AABBdc aabb : cubes) {
                    yd = MathHelper.aabbClipYCollide(aabb, this.bb, yd);
                }
                this.bb.translate(0.0, yd, 0.0);
            }
            cubes = this.world.getCubes(this, this.bb);
            if (oldX * oldX + oldZ * oldZ >= xd * xd + zd * zd || !cubes.isEmpty()) {
                xd = oldX;
                yd = oldY;
                zd = oldZ;
                this.bb.set(aabbCopy);
            }
        }
        if (!this.world.isClientSide || this instanceof Player || !(this instanceof Mob)) {
            this.x = (this.bb.minX + this.bb.maxX) / 2.0;
            this.y = this.bb.minY + (double)this.heightOffset - (double)this.ySlideOffset;
            this.z = (this.bb.minZ + this.bb.maxZ) / 2.0;
        }
        this.horizontalCollision = oldXd != xd || oldZd != zd;
        this.verticalCollision = oldYd != yd;
        this.onGround = oldYd != yd && oldYd < 0.0;
        this.collision = this.horizontalCollision || this.verticalCollision;
        this.checkOnWater(false);
        this.checkFallDamage(yd, this.onGround);
        if (oldXd != xd) {
            this.xd = 0.0;
        }
        if (oldYd != yd) {
            this.yd = 0.0;
        }
        if (oldZd != zd) {
            this.zd = 0.0;
        }
        double d10 = this.x - d3;
        double d12 = this.z - d4;
        if (this.makeStepSound() && !this.isSneaking() && this.vehicle == null) {
            int walkedSteps;
            int blockYUp;
            Block<?> blockAbove;
            this.walkDist = (float)((double)this.walkDist + (double)MathHelper.sqrt(d10 * d10 + d12 * d12) * 0.6);
            AABBd boundingBox = new AABBd(this.x - 0.01, this.bb.minY - 0.01, this.z - 0.01, this.x + 0.01, this.bb.minY + 0.01, this.z + 0.01);
            int blockX = MathHelper.floor(this.x);
            int blockY = MathHelper.floor(boundingBox.minY());
            int blockZ = MathHelper.floor(this.z);
            Block<?> blockWalkedOn = null;
            block9: for (int x = blockX - 1; x <= blockX + 1; ++x) {
                for (int z = blockZ - 1; z <= blockZ + 1; ++z) {
                    for (int y = blockY - 1; y < blockY + 1; ++y) {
                        Block<?> block = this.world.getBlock(x, y, z);
                        if (block == null) continue;
                        this.world.collidingBoundingBoxes.clear();
                        block.getCollidingBoundingBoxes(this.world, x, y, z, boundingBox, this.world.collidingBoundingBoxes);
                        if (this.world.collidingBoundingBoxes.isEmpty()) continue;
                        blockWalkedOn = block;
                        blockX = x;
                        blockY = y;
                        blockZ = z;
                        break block9;
                    }
                }
            }
            if ((blockAbove = this.world.getBlock(blockX, blockYUp = MathHelper.floor(boundingBox.maxY()), blockZ)) != null && blockAbove.hasTag(BlockTags.OVERRIDE_STEPSOUND)) {
                blockWalkedOn = blockAbove;
                blockY = blockYUp;
            }
            boolean bl2 = this.isWalking = this.walkDistO != this.walkDist;
            if (this.canInteract() && (walkedSteps = (int)(this.walkDist - (float)this.nextStep)) > 0 && blockWalkedOn != null) {
                this.nextStep += walkedSteps;
                if (!this.muteStepSounds) {
                    this.world.playBlockSoundEffect(this, this.x, this.bb.minY, this.z, blockWalkedOn, EnumBlockSoundEffectType.STEP);
                    blockWalkedOn.onEntityWalking(this.world, blockX, blockY, blockZ, this);
                }
            }
        }
        if (this.world.areBlocksLoaded(minX = MathHelper.floor(this.bb.minX + 0.001), minY = MathHelper.floor(this.bb.minY + 0.001), minZ = MathHelper.floor(this.bb.minZ + 0.001), maxX = MathHelper.floor(this.bb.maxX - 0.001), maxY = MathHelper.floor(this.bb.maxY - 0.001), maxZ = MathHelper.floor(this.bb.maxZ - 0.001))) {
            for (int _x = minX; _x <= maxX; ++_x) {
                for (int _y = minY; _y <= maxY; ++_y) {
                    for (int _z = minZ; _z <= maxZ; ++_z) {
                        int blockId = this.world.getBlockId(_x, _y, _z);
                        if (blockId <= 0) continue;
                        Blocks.blocksList[blockId].onEntityCollidedWithBlock(this.world, _x, _y, _z, this);
                    }
                }
            }
        }
        boolean inWaterOrRain = this.isInWaterOrRain();
        if (this.world.isBoundingBoxBurning(MathHelper.aabbInsetBoundingBox(this.bb, 0.001, 0.001, 0.001, new AABBd()))) {
            this.burn(1);
            if (!inWaterOrRain) {
                ++this.remainingFireTicks;
                if (this.remainingFireTicks == 0) {
                    this.remainingFireTicks = 300;
                }
                this.maxFireTicks = this.remainingFireTicks;
            }
        } else if (this.remainingFireTicks <= 0) {
            this.remainingFireTicks = -this.fireImmuneTicks;
        }
        if (inWaterOrRain && this.remainingFireTicks > 0) {
            this.world.playSoundAtEntity(null, this, "random.fizz", 0.7f, 1.6f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
            this.remainingFireTicks = -this.fireImmuneTicks;
        }
    }

    public void fling(double xd, double yd, double zd, float pushTime) {
        ++this.pushesThisTick;
        this.fallDistance = 0.0f;
        double scalar = Math.sqrt(this.pushesThisTick) - Math.sqrt(this.pushesThisTick - 1);
        this.xd += xd * scalar;
        this.yd += yd * scalar;
        this.zd += zd * scalar;
        if (pushTime > this.pushTime) {
            this.pushTime = pushTime;
        }
    }

    public boolean canInteract() {
        return true;
    }

    protected boolean makeStepSound() {
        return true;
    }

    protected void checkFallDamage(double yd, boolean onGround) {
        if (this.vehicle != null || this.noPhysics) {
            this.fallDistance = 0.0f;
        } else if (onGround) {
            if (this.fallDistance > 0.0f) {
                this.causeFallDamage(this.fallDistance);
                this.fallDistance = 0.0f;
            }
        } else if (yd < 0.0) {
            this.fallDistance -= (float)yd;
        }
    }

    @Nullable
    public AABBdc getCollisionAABB() {
        return null;
    }

    protected void burn(int damage) {
        if (!this.fireImmune) {
            this.hurt(null, damage, DamageType.FIRE);
        }
    }

    protected void causeFallDamage(float distance) {
        if (this.passenger != null) {
            this.passenger.causeFallDamage(distance);
        }
    }

    public boolean isInWaterOrRain() {
        return this.wasInWater || this.world.canBlockBeRainedOn(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
    }

    public boolean isInWater() {
        return this.wasInWater;
    }

    public boolean checkAndHandleWater(boolean addVelocity) {
        return this.world.handleMaterialAcceleration(MathHelper.aabbInsetBoundingBox(this.bb, 0.001, 0.001, 0.001, new AABBd()), Materials.WATER, this, addVelocity);
    }

    public boolean isUnderLiquid(@NotNull Material material) {
        double headY = this.y + (double)this.getHeadHeight();
        TilePos tilePos = new TilePos(this.x, headY, this.z);
        Block<?> block = this.world.getBlockType(tilePos);
        if (block != null && block.getMaterial() == material) {
            float f = BlockLogicFluid.getHeight(this.world.getBlockData(tilePos)) - 0.2f;
            float f1 = (float)(tilePos.y + 1) - f;
            return headY < (double)f1;
        }
        return false;
    }

    public float getHeadHeight() {
        return 0.0f;
    }

    public boolean isInLava() {
        return this.world.isMaterialInBB((AABBdc)this.bb, Materials.LAVA);
    }

    public void moveRelative(float strafe, float forward, float speed) {
        float f3 = MathHelper.sqrt_float(strafe * strafe + forward * forward);
        if (f3 < 0.01f) {
            return;
        }
        if (f3 < 1.0f) {
            f3 = 1.0f;
        }
        f3 = speed / f3;
        float sinYaw = MathHelper.sin(this.yRot * (float)Math.PI / 180.0f);
        float cosYaw = MathHelper.cos(this.yRot * (float)Math.PI / 180.0f);
        this.xd += (double)((strafe *= f3) * cosYaw - (forward *= f3) * sinYaw);
        this.zd += (double)(forward * cosYaw + strafe * sinYaw);
    }

    public float calcBrightness(float partialTick) {
        if (Global.accessor.isFullbrightEnabled()) {
            return 1.0f;
        }
        int i = MathHelper.floor(this.x);
        double d = (this.bb.maxY - this.bb.minY) * 0.66;
        int j = MathHelper.floor(this.y - (double)this.heightOffset + d);
        int k = MathHelper.floor(this.z);
        if (this.world.areBlocksLoaded(MathHelper.floor(this.bb.minX), MathHelper.floor(this.bb.minY), MathHelper.floor(this.bb.minZ), MathHelper.floor(this.bb.maxX), MathHelper.floor(this.bb.maxY), MathHelper.floor(this.bb.maxZ))) {
            float f1 = this.world.getLightBrightness(i, j, k);
            if (f1 < this.entityBrightness) {
                f1 = this.entityBrightness;
            }
            return f1;
        }
        return this.entityBrightness;
    }

    public float getBrightness(float partialTick) {
        return this.calcBrightness(partialTick);
    }

    public int calcLightmap(float partialTick) {
        int skylight;
        int blocklight;
        if (Global.accessor.isFullbrightEnabled()) {
            return 0xF0000F;
        }
        TilePos blockPos = new TilePos(this.x, this.y - (double)this.heightOffset + (double)this.ySlideOffset + (double)this.bbHeight * 0.66, this.z);
        if (this.world.getBlockLitInteriorSurface(blockPos)) {
            TilePos queryPos = new TilePos();
            int bU = this.world.getSavedLightValue(LightLayer.Block, blockPos.up(queryPos));
            int bW = this.world.getSavedLightValue(LightLayer.Block, blockPos.west(queryPos));
            int bE = this.world.getSavedLightValue(LightLayer.Block, blockPos.east(queryPos));
            int bS = this.world.getSavedLightValue(LightLayer.Block, blockPos.south(queryPos));
            int bN = this.world.getSavedLightValue(LightLayer.Block, blockPos.north(queryPos));
            if (bW > bU) {
                bU = bW;
            }
            if (bE > bU) {
                bU = bE;
            }
            if (bS > bU) {
                bU = bS;
            }
            if (bN > bU) {
                bU = bN;
            }
            blocklight = bU;
            int sU = this.world.getSavedLightValue(LightLayer.Sky, blockPos.up(queryPos));
            int sW = this.world.getSavedLightValue(LightLayer.Sky, blockPos.west(queryPos));
            int sE = this.world.getSavedLightValue(LightLayer.Sky, blockPos.east(queryPos));
            int sS = this.world.getSavedLightValue(LightLayer.Sky, blockPos.south(queryPos));
            int sN = this.world.getSavedLightValue(LightLayer.Sky, blockPos.north(queryPos));
            if (sW > sU) {
                sU = sW;
            }
            if (sE > sU) {
                sU = sE;
            }
            if (sS > sU) {
                sU = sS;
            }
            if (sN > sU) {
                sU = sN;
            }
            skylight = sU;
        } else {
            skylight = this.world.getSavedLightValue(LightLayer.Sky, blockPos);
            blocklight = this.world.getSavedLightValue(LightLayer.Block, blockPos);
        }
        return this.world.getLightmapCoord(skylight, blocklight);
    }

    public int getLightmap(float partialTick) {
        return this.calcLightmap(partialTick);
    }

    public void setWorld(@NotNull World world) {
        this.world = world;
    }

    public void absMoveTo(double x, double y, double z, float yRot, float xRot) {
        this.xo = this.x = x;
        this.yo = this.y = y;
        this.zo = this.z = z;
        this.yRotO = this.yRot = yRot;
        this.xRotO = this.xRot = xRot;
        this.ySlideOffset = 0.0f;
        double d3 = this.yRotO - yRot;
        if (d3 < -180.0) {
            this.yRotO += 360.0f;
        }
        if (d3 >= 180.0) {
            this.yRotO -= 360.0f;
        }
        this.setPos(this.x, this.y, this.z);
        this.setRot(yRot, xRot);
    }

    public void moveTo(double x, double y, double z, float yRot, float xRot) {
        this.xo = this.x = x;
        this.yo = this.y = y + (double)this.heightOffset;
        this.zo = this.z = z;
        this.yRot = yRot;
        this.xRot = xRot;
        this.setPos(this.x, this.y, this.z);
    }

    public float distanceTo(@NotNull Entity entity) {
        float dx = (float)(this.x - entity.x);
        float dy = (float)(this.y - entity.y);
        float dz = (float)(this.z - entity.z);
        return MathHelper.sqrt_float(dx * dx + dy * dy + dz * dz);
    }

    public double distanceToSqr(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceTo(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return MathHelper.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public double distanceToSqr(@NotNull Entity entity) {
        double dx = this.x - entity.x;
        double dy = this.y - entity.y;
        double dz = this.z - entity.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public void playerTouch(Player player) {
    }

    public boolean collidesWith(Entity entity) {
        return true;
    }

    public boolean collidesWithBlock(Block<?> block, int metadata) {
        return !(this.pushTime > 0.5f) || !(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd > 1.0) || !Block.hasLogicClass(block, BlockLogicPistonHead.class);
    }

    public void push(Entity entity) {
        if (entity.passenger == this || entity.vehicle == this || entity.noPhysics || !entity.isPickable() || !this.collidesWith(entity) || !entity.collidesWith(this)) {
            return;
        }
        double d = entity.x - this.x;
        double d1 = entity.z - this.z;
        double d2 = MathHelper.abs_max(d, d1);
        if (d2 >= 0.01) {
            d2 = MathHelper.sqrt(d2);
            d /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d *= d3;
            d1 *= d3;
            d *= 0.05;
            d1 *= 0.05;
            this.push(-(d *= (double)(1.0f - this.pushthrough)), 0.0, -(d1 *= (double)(1.0f - this.pushthrough)));
            entity.push(d, 0.0, d1);
        }
    }

    public void push(double x, double y, double z) {
        this.xd += x;
        this.yd += y;
        this.zd += z;
    }

    protected void markHurt() {
        this.hurtMarked = true;
    }

    public boolean hurt(Entity attacker, int baseDamage, DamageType type) {
        this.markHurt();
        return false;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isSelectable() {
        return this.isPickable();
    }

    public boolean isPushable() {
        return false;
    }

    public void awardKillScore(Entity entity, int i) {
    }

    public boolean shouldRender(@NotNull Vector3dc cameraPos, double viewDistanceModifier) {
        double dx = this.x - cameraPos.x();
        double dy = this.y - cameraPos.y();
        double dz = this.z - cameraPos.z();
        double distance = dx * dx + dy * dy + dz * dz;
        return this.shouldRenderAtSqrDistance(distance, viewDistanceModifier);
    }

    public boolean shouldRenderAtSqrDistance(double distance, double viewDistanceModifier) {
        double d1 = MathHelper.getAABBSize(this.bb);
        return distance < (d1 *= 64.0 * this.viewScale * viewDistanceModifier) * d1;
    }

    @Nullable
    public String getEntityTexture() {
        return null;
    }

    public boolean save(@NotNull CompoundTag tag) {
        @Nullable NamespaceID s = this.getDispatcherId();
        if (this.removed || s == null) {
            return false;
        }
        tag.putString("id", s.toString());
        this.saveWithoutId(tag);
        return true;
    }

    public void saveWithoutId(@NotNull CompoundTag tag) {
        tag.put("Pos", this.newDoubleList(new double[]{this.x, this.y + (double)this.ySlideOffset, this.z}));
        tag.put("Motion", this.newDoubleList(new double[]{this.xd, this.yd, this.zd}));
        tag.put("Rotation", this.newFloatList(new float[]{this.yRot, this.xRot}));
        tag.putFloat("FallDistance", this.fallDistance);
        tag.putShort("Fire", (short)this.remainingFireTicks);
        tag.putShort("Air", (short)this.airSupply);
        tag.putBoolean("OnGround", this.onGround);
        tag.putFloat("PushTime", this.pushTime);
        this.addAdditionalSaveData(tag);
    }

    public void load(@NotNull CompoundTag tag) {
        ListTag posTag = tag.getList("Pos");
        ListTag motionTag = tag.getList("Motion");
        ListTag rotationTag = tag.getList("Rotation");
        this.xd = (Double)((DoubleTag)motionTag.tagAt(0)).getValue();
        this.yd = (Double)((DoubleTag)motionTag.tagAt(1)).getValue();
        this.zd = (Double)((DoubleTag)motionTag.tagAt(2)).getValue();
        if ((double)MathHelper.abs((float)this.xd) > 10.0) {
            this.xd = 0.0;
        }
        if ((double)MathHelper.abs((float)this.yd) > 10.0) {
            this.yd = 0.0;
        }
        if ((double)MathHelper.abs((float)this.zd) > 10.0) {
            this.zd = 0.0;
        }
        this.xo = this.x = ((Double)((DoubleTag)posTag.tagAt(0)).getValue()).doubleValue();
        this.yo = this.y = ((Double)((DoubleTag)posTag.tagAt(1)).getValue()).doubleValue();
        this.zo = this.z = ((Double)((DoubleTag)posTag.tagAt(2)).getValue()).doubleValue();
        this.yRotO = this.yRot = ((Float)((FloatTag)rotationTag.tagAt(0)).getValue()).floatValue();
        this.xRotO = this.xRot = ((Float)((FloatTag)rotationTag.tagAt(1)).getValue()).floatValue();
        this.fallDistance = tag.getFloat("FallDistance");
        this.maxFireTicks = this.remainingFireTicks = (int)tag.getShort("Fire");
        this.airSupply = tag.getShort("Air");
        this.onGround = tag.getBoolean("OnGround");
        this.pushTime = tag.getFloat("PushTime");
        this.setPos(this.x, this.y, this.z);
        this.setRot(this.yRot, this.xRot);
        this.readAdditionalSaveData(tag);
    }

    @Nullable
    public final NamespaceID getDispatcherId() {
        EntityDispatcher.EntityDispatcherEntry<?> entry = EntityDispatcher.getInstance().entryForClass(this.getClass());
        if (entry != null) {
            return entry.namespaceID;
        }
        return null;
    }

    public abstract void readAdditionalSaveData(@NotNull CompoundTag var1);

    public abstract void addAdditionalSaveData(@NotNull CompoundTag var1);

    @NotNull
    protected ListTag newDoubleList(double[] array) {
        ListTag list = new ListTag();
        for (double d : array) {
            list.addTag(new DoubleTag(d));
        }
        return list;
    }

    @NotNull
    protected ListTag newFloatList(float[] array) {
        ListTag list = new ListTag();
        for (float f : array) {
            list.addTag(new FloatTag(f));
        }
        return list;
    }

    public float getShadowHeightOffs() {
        return 0.25f;
    }

    @NotNull
    public EntityItem dropItem(int itemId, int stackSize) {
        return this.dropItem(itemId, stackSize, 0.0f);
    }

    @NotNull
    public EntityItem dropItem(int itemId, int stackSize, float verticalOffset) {
        return this.dropItem(new ItemStack(itemId, stackSize, 0), verticalOffset);
    }

    @NotNull
    public EntityItem dropItem(@NotNull ItemStack itemStack, float verticalOffset) {
        EntityItem entityitem = new EntityItem(this.world, this.x, this.y + (double)verticalOffset, this.z, itemStack);
        entityitem.pickupDelay = 10;
        this.world.entityJoinedWorld(entityitem);
        return entityitem;
    }

    public boolean isAlive() {
        return !this.removed;
    }

    public boolean isInWall() {
        for (int i = 0; i < 8; ++i) {
            int z;
            int y;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.bbWidth * 0.9f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.bbWidth * 0.9f;
            int x = MathHelper.floor(this.x + (double)f);
            if (!this.world.isBlockNormalCube(x, y = MathHelper.floor(this.y + (double)this.getHeadHeight() + (double)f1), z = MathHelper.floor(this.z + (double)f2))) continue;
            return true;
        }
        return false;
    }

    public boolean interact(@NotNull Player player) {
        return false;
    }

    public void rideTick() {
        if (this.vehicle == null) {
            return;
        }
        if (this.vehicle.isRemoved() || this.isSneaking() || this.vehicle instanceof Entity && !((Entity)this.vehicle).isAlive()) {
            this.vehicle.ejectRider();
            return;
        }
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        this.tick();
        if (this.vehicle == null) {
            return;
        }
        this.vehicle.positionRider();
        this.entityRiderYawDelta = MathHelper.normalizeRotation(this.entityRiderYawDelta + (double)this.vehicle.getYRotDelta());
        this.entityRiderPitchDelta = MathHelper.normalizeRotation(this.entityRiderPitchDelta + (double)this.vehicle.getXRotDelta());
        float maxRot = 10.0f;
        double yaw = MathHelper.clamp(this.entityRiderYawDelta / 2.0, -10.0, 10.0);
        double pitch = MathHelper.clamp(this.entityRiderPitchDelta / 2.0, -10.0, 10.0);
        this.entityRiderYawDelta -= yaw;
        if (this.turnWithVehicle && !(this.vehicle instanceof MobPig)) {
            this.yRot = (float)((double)this.yRot + yaw);
        }
    }

    @Override
    public void positionRider() {
        if (this.passenger == null) {
            return;
        }
        this.passenger.setPos(this.x, this.y + this.getRideHeight() + this.passenger.getRidingHeight(), this.z);
    }

    public double getRidingHeight() {
        return this.heightOffset;
    }

    public double getRideHeight() {
        return (double)this.bbHeight * 0.75;
    }

    public void startRiding(IVehicle vehicle) {
        if (!this.canRide()) {
            return;
        }
        if (this.vehicle == vehicle) {
            return;
        }
        this.entityRiderPitchDelta = 0.0;
        this.entityRiderYawDelta = 0.0;
        if (vehicle == null) {
            if (this.vehicle != null) {
                this.vehicle.moveExitingEntity(this);
                this.vehicle.setPassenger(null);
            }
            this.vehicle = null;
            return;
        }
        if (this.vehicle != null) {
            this.vehicle.setPassenger(null);
        }
        if (vehicle.getPassenger() != null) {
            vehicle.getPassenger().vehicle = null;
        }
        this.vehicle = vehicle;
        vehicle.setPassenger(this);
        if (vehicle instanceof Entity) {
            ((Entity)vehicle).fallDistance += this.fallDistance;
            this.fallDistance = 0.0f;
        }
    }

    @Override
    public Entity ejectRider() {
        Entity entity = this.passenger;
        if (entity == null) {
            return null;
        }
        this.passenger = null;
        entity.vehicle = null;
        entity.moveTo(this.x, this.bb.minY, this.z, entity.yRot, entity.xRot);
        return entity;
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int i) {
        this.setPos(x, y, z);
        this.setRot(yRot, xRot);
        List<AABBdc> cubes = this.world.getCubes(this, MathHelper.aabbInsetBoundingBox(this.bb, 0.03125, 0.0, 0.03125, new AABBd()));
        if (!cubes.isEmpty()) {
            double d3 = 0.0;
            for (AABBdc cube : cubes) {
                if (!(cube.maxY() > d3)) continue;
                d3 = cube.maxY();
            }
            this.setPos(x, y += d3 - this.bb.minY, z);
        }
    }

    public float getPickRadius() {
        return 0.1f;
    }

    @Nullable
    public Vector3dc getViewVector(float partialTick) {
        return null;
    }

    public void handlePortal(int portalBlockId, DyeColor portalColor) {
    }

    @Nullable
    public ItemStack[] getInventory() {
        return null;
    }

    public void lerpMotion(double xd, double yd, double zd) {
        this.xd = xd;
        this.yd = yd;
        this.zd = zd;
    }

    public void handleEntityEvent(byte byte0, float attackedAtYaw) {
    }

    public void animateHurt() {
    }

    public void setEquippedSlot(int slot, int itemID, int itemMeta, CompoundTag tag) {
    }

    public void setHeldObject(@Nullable ICarriable heldObject) {
    }

    @Nullable
    public ICarriable getHeldObject() {
        return null;
    }

    public boolean isOnFire() {
        return !this.fireImmune && this.remainingFireTicks > 0 || this.getSharedFlag(0);
    }

    public boolean isPassenger() {
        return this.vehicle != null || this.getSharedFlag(2);
    }

    public boolean isSneaking() {
        return this.getSharedFlag(1);
    }

    public void setSneaking(boolean flag) {
        this.setSharedFlag(1, flag);
    }

    protected boolean getSharedFlag(int i) {
        return (this.entityData.getByte(0) & 1 << i) != 0;
    }

    protected void setSharedFlag(int id, boolean flag) {
        byte sharedFlags = this.entityData.getByte(0);
        if (flag) {
            this.entityData.set(0, (byte)(sharedFlags | 1 << id));
        } else {
            this.entityData.set(0, (byte)(sharedFlags & ~(1 << id)));
        }
    }

    public void thunderHit(EntityLightning bolt) {
        this.burn(5);
        ++this.remainingFireTicks;
        if (this.remainingFireTicks == 0) {
            this.remainingFireTicks = 300;
        }
        this.maxFireTicks = this.remainingFireTicks;
    }

    public void killed(Mob mob) {
    }

    protected boolean checkAndPushInTile(double x, double y, double z) {
        TilePos tilePos = new TilePos(x, y, z);
        TilePos queryPos = new TilePos();
        double depthX = x - (double)tilePos.x();
        double depthY = y - (double)tilePos.y();
        double depthZ = z - (double)tilePos.z();
        if (this.world.isBlockNormalCube(tilePos)) {
            Direction direction = Direction.NONE;
            double minDepth = Double.MAX_VALUE;
            if (depthX < minDepth && !this.world.isBlockNormalCube(tilePos.west(queryPos))) {
                minDepth = depthX;
                direction = Direction.WEST;
            }
            if (1.0 - depthX < minDepth && !this.world.isBlockNormalCube(tilePos.east(queryPos))) {
                minDepth = 1.0 - depthX;
                direction = Direction.EAST;
            }
            if (depthY < minDepth && !this.world.isBlockNormalCube(tilePos.down(queryPos))) {
                minDepth = depthY;
                direction = Direction.DOWN;
            }
            if (1.0 - depthY < minDepth && !this.world.isBlockNormalCube(tilePos.up(queryPos))) {
                minDepth = 1.0 - depthY;
                direction = Direction.UP;
            }
            if (depthZ < minDepth && !this.world.isBlockNormalCube(tilePos.north(queryPos))) {
                minDepth = depthZ;
                direction = Direction.NORTH;
            }
            if (1.0 - depthZ < minDepth && !this.world.isBlockNormalCube(tilePos.south(queryPos))) {
                direction = Direction.SOUTH;
            }
            float pushOut = this.random.nextFloat() * 0.2f + 0.1f;
            switch (direction) {
                case WEST: {
                    this.xd = -pushOut;
                    break;
                }
                case EAST: {
                    this.xd = pushOut;
                    break;
                }
                case DOWN: {
                    this.yd = -pushOut;
                    break;
                }
                case UP: {
                    this.yd = pushOut;
                    break;
                }
                case NORTH: {
                    this.zd = -pushOut;
                    break;
                }
                case SOUTH: {
                    this.zd = pushOut;
                }
            }
            return true;
        }
        return false;
    }

    public boolean canRide() {
        return true;
    }

    public boolean isSprinting() {
        return this.getSharedFlag(3);
    }

    public void setSprinting(boolean sprinting) {
        this.setSharedFlag(3, sprinting);
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void setPassenger(@Nullable Entity passenger) {
        this.passenger = passenger;
    }

    @Override
    @Nullable
    public Entity getPassenger() {
        return this.passenger;
    }

    @Override
    public void moveExitingEntity(@NotNull Entity entity) {
        entity.moveTo(this.x, this.bb.minY + (double)this.bbHeight, this.z, entity.yRot, entity.xRot);
    }

    @Override
    public float getYRotDelta() {
        return (float)MathHelper.deltaAngle(this.yRot, this.yRotO);
    }

    @Override
    public float getXRotDelta() {
        return (float)MathHelper.deltaAngle(this.xRot, this.xRotO);
    }

    public boolean lerpVehicleMotion() {
        return true;
    }

    public void handleSpecialVehicleControl() {
    }

    public void sendSpecialVehiclePacket() {
    }

    public boolean deferVehicleBehavior() {
        return false;
    }

    public static String getNameFromEntity(@NotNull Entity entity, boolean useNickname) {
        I18n translator = I18n.getInstance();
        if (entity instanceof Mob && useNickname && !((Mob)entity).nickname.isEmpty()) {
            return ((Mob)entity).nickname;
        }
        if (entity instanceof Player) {
            return ((Player)entity).getDisplayName();
        }
        EntityDispatcher.EntityDispatcherEntry<?> entry = EntityDispatcher.getInstance().entryForClass(entity.getClass());
        if (entry != null) {
            if (entry.nameKey != null) {
                return translator.translateKey(entry.nameKey);
            }
            return entry.namespaceID.value();
        }
        return entity.getClass().getSimpleName();
    }
}

