/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.helper;

import com.b100.json.JsonParser;
import com.b100.json.element.JsonArray;
import com.b100.json.element.JsonObject;
import com.b100.utils.StringUtils;
import com.mojang.logging.LogUtils;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.core.entity.monster.MobHuman;
import net.minecraft.core.util.helper.UUIDHelper;
import org.slf4j.Logger;

public class GetMonsterSkinUrlThread
extends Thread {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static int counter = 0;
    private static final String urlUUID = "https://api.mojang.com/users/profiles/minecraft/";
    private static final String urlSkin = "https://sessionserver.mojang.com/session/minecraft/profile/";
    private static final JsonParser jsonParser = new JsonParser();
    private MobHuman monster;
    private UUID uuid;

    public GetMonsterSkinUrlThread(MobHuman monster) {
        this.monster = monster;
        this.setDaemon(true);
        this.setName("GetSkinUrlThread " + counter++);
        this.start();
    }

    @Override
    public void run() {
        String name = this.monster.nickname;
        if (name == null || name.isEmpty()) {
            return;
        }
        String string = null;
        for (int i = 0; i < 3 && (string = this.getSkinObject(name)) == null; ++i) {
            try {
                GetMonsterSkinUrlThread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e2) {
                break;
            }
        }
        if (string == null) {
            return;
        }
        JsonObject object = jsonParser.parse(string);
        JsonArray properties = object.getArray("properties");
        JsonObject textureProperty = properties.query(e -> e.getAsObject().getString("name").equalsIgnoreCase("textures")).getAsObject();
        JsonObject texturesObject = jsonParser.parse(GetMonsterSkinUrlThread.decodeBase64(textureProperty.getString("value"))).getObject("textures");
        if (texturesObject.has("SKIN")) {
            this.monster.skinUrl = texturesObject.getObject("SKIN").getString("url");
            if (texturesObject.getObject("SKIN").has("metadata") && texturesObject.getObject("SKIN").getObject("metadata").getString("model").equals("slim")) {
                this.monster.slimModel = true;
            }
        }
        LOGGER.info("Skin URL: {}", (Object)this.monster.skinUrl);
    }

    public static String decodeBase64(String string) {
        return new String(Base64.getDecoder().decode(string));
    }

    private String getSkinObject(String name) {
        String string;
        this.uuid = UUIDHelper.getUUIDFromName(name);
        if (this.uuid == null) {
            return null;
        }
        LOGGER.info("Loading Skin for Player {}...", (Object)name);
        try {
            string = StringUtils.getWebsiteContentAsString(urlSkin + String.valueOf(this.uuid));
        }
        catch (Exception e) {
            LOGGER.warn("Invalid UUID {}, or can't connect to the Mojang API.", (Object)this.uuid);
            return null;
        }
        return string;
    }
}

