/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import net.minecraft.core.block.Block;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NextTickListEntry
implements Comparable<NextTickListEntry> {
    private static long counter = 0L;
    @NotNull
    public TilePos tilePos;
    @NotNull
    public Block<?> block;
    public long delay;
    private final long entryId = counter++;

    public NextTickListEntry(@NotNull TilePosc tilePos, @NotNull Block<?> block) {
        this.tilePos = new TilePos(tilePos);
        this.block = block;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof NextTickListEntry) {
            @NotNull NextTickListEntry entry = (NextTickListEntry)obj;
            return this.tilePos.equals(entry.tilePos) && this.block == entry.block;
        }
        return false;
    }

    public int hashCode() {
        return (this.tilePos.x() * 128 * 1024 + this.tilePos.z() * 128 + this.tilePos.y()) * 256 + this.block.id();
    }

    @NotNull
    public NextTickListEntry setDelay(long delay) {
        this.delay = delay;
        return this;
    }

    @Override
    public int compareTo(@NotNull NextTickListEntry other) {
        if (this.delay < other.delay) {
            return -1;
        }
        if (this.delay > other.delay) {
            return 1;
        }
        if (this.entryId < other.entryId) {
            return -1;
        }
        return this.entryId <= other.entryId ? 0 : 1;
    }
}

