/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import com.mojang.nbt.tags.CompoundTag;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemWandNBT
extends Item {
    public ItemWandNBT(@NotNull String translationKey, @NotNull String namespaceId, int id) {
        super(translationKey, namespaceId, id);
    }

    @Override
    public ItemStack onInventoryInteract(@NotNull Player player, @NotNull Slot slot, @Nullable ItemStack stackInSlot, boolean isItemGrabbed) {
        if (slot.getItemStack() != null) {
            player.displayNBTEditor(slot.getItemStack().writeToNBT(new CompoundTag()), tag -> {
                slot.getItemStack().readFromNBT((CompoundTag)tag);
                return null;
            });
        }
        return stackInSlot;
    }

    @Override
    public boolean hasInventoryInteraction() {
        return true;
    }

    @Override
    public boolean onUseOnBlock(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        if (player == null) {
            return false;
        }
        TileEntity te = world.getTileEntity(blockPos);
        if (te != null) {
            CompoundTag teTag = new CompoundTag();
            te.writeToNBT(teTag);
            player.displayNBTEditor(teTag, tag -> {
                te.readAdditionalData((CompoundTag)tag);
                return null;
            });
            return true;
        }
        return false;
    }

    @Override
    public boolean useOnEntity(@NotNull ItemStack selfStack, @NotNull Player player, @NotNull Mob mob) {
        CompoundTag entTag = new CompoundTag();
        mob.save(entTag);
        player.displayNBTEditor(entTag, tag -> {
            mob.load((CompoundTag)tag);
            return null;
        });
        return true;
    }
}

