/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.noise.operator;

import net.minecraft.core.world.noise.Noise2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class Normalize2D<T extends Noise2D>
implements Noise2D {
    @NotNull
    private static final Vector2dc RANGE = new Vector2d(0.0, 1.0);
    @NotNull
    protected final T noise;

    public Normalize2D(@NotNull T noise) {
        this.noise = noise;
    }

    @Override
    @NotNull
    public Vector2dc getRange2D() {
        return RANGE;
    }

    @Override
    public double getValue(double x, double z) {
        @NotNull Vector2dc range = this.noise.getRange2D();
        double r = range.y() - range.x();
        double v = this.noise.getValue(x, z);
        double vo = v - range.x();
        return vo / r;
    }

    @Override
    public double @NotNull [] addRegion(double @Nullable [] out, double x, double z, int xSize, int zSize, double xScale, double zScale, double amplitude) {
        if (out == null || out.length < xSize * zSize) {
            out = new double[xSize * zSize];
        }
        @NotNull Vector2dc range = this.noise.getRange2D();
        double r = range.y() - range.x();
        double @NotNull [] temp = this.noise.addRegion(null, x, z, xSize, zSize, xScale, zScale, amplitude);
        for (int i = 0; i < out.length; ++i) {
            temp[i] = (temp[i] - range.x()) / r;
            int n = i;
            out[n] = out[n] + temp[i];
        }
        return out;
    }
}

