/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.Global;
import net.minecraft.core.MinecraftAccessor;
import net.minecraft.core.achievement.stat.StatList;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityDispatcher;
import net.minecraft.core.data.DataLoader;
import net.minecraft.core.data.legacy.LegacyWorldTypes;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.item.Items;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.ICommandListener;
import net.minecraft.core.net.IUpdatePlayerListBox;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.PropertyManager;
import net.minecraft.core.net.ServerCommandEntry;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.commands.CommandAchievement;
import net.minecraft.core.net.command.commands.CommandBiome;
import net.minecraft.core.net.command.commands.CommandChunk;
import net.minecraft.core.net.command.commands.CommandClear;
import net.minecraft.core.net.command.commands.CommandClone;
import net.minecraft.core.net.command.commands.CommandDamage;
import net.minecraft.core.net.command.commands.CommandFill;
import net.minecraft.core.net.command.commands.CommandGameMode;
import net.minecraft.core.net.command.commands.CommandGameRule;
import net.minecraft.core.net.command.commands.CommandGive;
import net.minecraft.core.net.command.commands.CommandHeal;
import net.minecraft.core.net.command.commands.CommandHelp;
import net.minecraft.core.net.command.commands.CommandKill;
import net.minecraft.core.net.command.commands.CommandMessage;
import net.minecraft.core.net.command.commands.CommandMobSpawning;
import net.minecraft.core.net.command.commands.CommandParticle;
import net.minecraft.core.net.command.commands.CommandPlace;
import net.minecraft.core.net.command.commands.CommandPlaySound;
import net.minecraft.core.net.command.commands.CommandSay;
import net.minecraft.core.net.command.commands.CommandSeed;
import net.minecraft.core.net.command.commands.CommandSetBlock;
import net.minecraft.core.net.command.commands.CommandSetSpawn;
import net.minecraft.core.net.command.commands.CommandSpawn;
import net.minecraft.core.net.command.commands.CommandSummon;
import net.minecraft.core.net.command.commands.CommandTeleport;
import net.minecraft.core.net.command.commands.CommandTellRaw;
import net.minecraft.core.net.command.commands.CommandTestFor;
import net.minecraft.core.net.command.commands.CommandTime;
import net.minecraft.core.net.command.commands.CommandWeather;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.net.packet.PacketSetTime;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.player.gamemode.Gamemodes;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.util.pool.ObjectPool;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.provider.BiomeProviderOverworld;
import net.minecraft.core.world.chunk.IChunkLoader;
import net.minecraft.core.world.chunk.provider.IChunkProvider;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.save.ISaveConverter;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorage;
import net.minecraft.core.world.save.SaveConverters;
import net.minecraft.core.world.save.SaveFormats;
import net.minecraft.core.world.save.SaveHandlerServer;
import net.minecraft.core.world.save.mcregion.SaveFormat19134;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.WorldTypes;
import net.minecraft.server.entity.EntityTrackerImpl;
import net.minecraft.server.entity.ServerSkinVariantList;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.gui.ServerGui;
import net.minecraft.server.net.MulticastPublisher;
import net.minecraft.server.net.NetworkListenThread;
import net.minecraft.server.net.PlayerList;
import net.minecraft.server.net.command.ConsoleCommandSource;
import net.minecraft.server.net.command.commands.CommandBan;
import net.minecraft.server.net.command.commands.CommandColor;
import net.minecraft.server.net.command.commands.CommandDeop;
import net.minecraft.server.net.command.commands.CommandDifficulty;
import net.minecraft.server.net.command.commands.CommandEmotes;
import net.minecraft.server.net.command.commands.CommandKick;
import net.minecraft.server.net.command.commands.CommandList;
import net.minecraft.server.net.command.commands.CommandMe;
import net.minecraft.server.net.command.commands.CommandNickname;
import net.minecraft.server.net.command.commands.CommandOp;
import net.minecraft.server.net.command.commands.CommandSave;
import net.minecraft.server.net.command.commands.CommandScore;
import net.minecraft.server.net.command.commands.CommandStop;
import net.minecraft.server.net.command.commands.CommandUnban;
import net.minecraft.server.net.command.commands.CommandWhitelist;
import net.minecraft.server.net.command.commands.CommandWhoIs;
import net.minecraft.server.world.ConvertProgressUpdater;
import net.minecraft.server.world.WorldManager;
import net.minecraft.server.world.WorldServer;
import net.minecraft.server.world.WorldServerMulti;
import net.minecraft.server.world.chunk.provider.ChunkProviderServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MinecraftServer
implements Runnable,
ICommandListener,
MinecraftAccessor {
    public static Logger LOGGER = LogUtils.getLogger();
    public static final String VERSION = Global.VERSION;
    private static MinecraftServer instance;
    @Nullable
    public Boolean argOffline = null;
    @Nullable
    public String argWorld = null;
    public int argPort = -1;
    public NetworkListenThread networkServer;
    public PropertyManager propertyManager;
    public Int2ObjectMap<WorldServer> dimensionWorlds;
    public PlayerList playerList;
    private boolean serverRunning;
    public boolean serverStopped;
    int deathTime;
    public String currentTask;
    public int percentDone;
    private final List<IUpdatePlayerListBox> playerListBoxes;
    private final List<ServerCommandEntry> commands;
    public Int2ObjectMap<EntityTrackerImpl> entityTrackerMap;
    public boolean onlineMode;
    public boolean broadcastPlayerList;
    public boolean pvpOn;
    public boolean allowFlight;
    public int spawnProtectionRange;
    public WorldType defaultWorldType;
    public int difficulty;
    public String joinMessage = null;
    public int summonLimit;
    public String language;
    public int sleepPercentage = 100;
    public int maxPlayers = 20;
    public int viewDistance = 10;
    public Gamemode defaultGamemode;
    public static String statsToken;
    public static boolean statsStatus;
    public boolean disablePhotoMode = false;
    public String name = "";
    public String motd = "";
    private final SkinVariantList skinVariantList = new ServerSkinVariantList();
    public int autoSaveInterval = 5;
    public int chunksSavedPerAutosave = 24;
    public boolean forceSaveAllChunksOnAutosave = false;
    public byte @Nullable [] iconBytes = null;
    public final MulticastPublisher multicastPublisher = new MulticastPublisher();
    public int ticksSinceLastBroadcast = 0;
    private boolean spawnAnimals;
    private boolean spawnHostiles;

    public MinecraftServer() {
        Global.accessor = this;
        this.serverRunning = true;
        this.serverStopped = false;
        this.deathTime = 0;
        this.playerListBoxes = new ArrayList<IUpdatePlayerListBox>();
        this.commands = Collections.synchronizedList(new ArrayList());
        Thread t = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private boolean startServer() throws UnknownHostException {
        File icon;
        instance = this;
        Global.isServer = true;
        Thread commandReadingThreads = new Thread(() -> {
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(System.in));
            String s = null;
            try {
                while (!this.serverStopped && MinecraftServer.isServerRunning(this) && (s = bufferedreader.readLine()) != null) {
                    this.addCommand(s, this);
                }
            }
            catch (IOException ioexception) {
                LOGGER.error("Exception occurred while adding command '{}'!", (Object)s, (Object)ioexception);
            }
        });
        commandReadingThreads.setDaemon(true);
        commandReadingThreads.start();
        LOGGER.info("Starting Better than Adventure! server for version {}", (Object)VERSION);
        if (Runtime.getRuntime().maxMemory() / 1024L / 1024L < 512L) {
            LOGGER.warn("**** NOT ENOUGH RAM!");
            LOGGER.warn("To start the server with more ram, launch it as \"java -Xmx1024M -Xms1024M -jar minecraft_server.jar\"");
        }
        if ((icon = new File("icon.png")).exists()) {
            try (InputStream stream = Files.newInputStream(new File("icon.png").toPath(), new OpenOption[0]);){
                this.iconBytes = new byte[stream.available()];
                for (int i = 0; i < this.iconBytes.length; ++i) {
                    this.iconBytes[i] = (byte)stream.read();
                }
            }
            catch (Exception e) {
                LOGGER.error("", e);
            }
        }
        Blocks.init();
        Items.init();
        Dimension.init();
        EntityDispatcher.init();
        TileEntityDispatcher.init();
        CommandHelper.init();
        this.initCommands();
        LOGGER.info("Loading properties");
        this.propertyManager = new PropertyManager(new File("server.properties"));
        String s = this.propertyManager.getStringProperty("server-ip", "");
        this.onlineMode = this.argOffline == null ? this.propertyManager.getBooleanProperty("online-mode", true) : this.argOffline == false;
        this.broadcastPlayerList = this.propertyManager.getBooleanProperty("broadcast-player-list", true);
        this.spawnAnimals = this.propertyManager.getBooleanProperty("spawn-animals", true);
        this.spawnHostiles = this.propertyManager.getBooleanProperty("spawn-monsters", true);
        this.pvpOn = this.propertyManager.getBooleanProperty("pvp", true);
        this.allowFlight = this.propertyManager.getBooleanProperty("allow-flight", false);
        statsToken = this.propertyManager.getStringProperty("stats-token", "only-enter-a-value-if-you-are-a-registered-server");
        this.defaultWorldType = Registries.WORLD_TYPES.getItem(this.propertyManager.getStringProperty("world-type", Registries.WORLD_TYPES.getKey(WorldTypes.OVERWORLD_EXTENDED)));
        this.spawnProtectionRange = this.propertyManager.getIntProperty("spawn-protection", 0);
        this.difficulty = this.propertyManager.getIntProperty("difficulty", 2);
        this.joinMessage = this.propertyManager.getStringProperty("join-message", "");
        this.summonLimit = this.propertyManager.getIntProperty("summon-limit", 10);
        this.sleepPercentage = this.propertyManager.getIntProperty("sleep-percentage", 0);
        NetworkManager.PACKET_DELAY = this.propertyManager.getIntProperty("packet-delay", 1);
        NetworkManager.TIMEOUT_TIME = this.propertyManager.getIntProperty("login-timeout-time", 90000);
        this.maxPlayers = this.propertyManager.getIntProperty("max-players", 20);
        this.viewDistance = this.propertyManager.getIntProperty("view-distance", 10);
        this.language = this.propertyManager.getStringProperty("language", "en_US");
        this.disablePhotoMode = this.propertyManager.getBooleanProperty("disable-photomode", false);
        this.name = this.propertyManager.getStringProperty("name", "");
        this.motd = this.propertyManager.getStringProperty("motd", "A Better than Adventure! Server");
        this.autoSaveInterval = this.propertyManager.getIntProperty("autosaveInterval", 5);
        this.chunksSavedPerAutosave = this.propertyManager.getIntProperty("maxChunksSavedPerAutosave", 24);
        this.forceSaveAllChunksOnAutosave = this.propertyManager.getBooleanProperty("forceSaveAllChunksOnAutosave", false);
        EntityItem.enableItemClumping = this.propertyManager.getBooleanProperty("enable-item-clumping", true);
        UUIDHelper.urlUUID = this.propertyManager.getStringProperty("uuid-service", "https://api.minecraftservices.com/minecraft/profile/lookup/name/%s");
        String gamemodeProperty = this.propertyManager.getStringProperty("default-gamemode", "minecraft:gamemode/survival");
        @Nullable Gamemode gamemodeFromProperty = Registries.GAMEMODES.getItem(gamemodeProperty);
        if (gamemodeFromProperty == null) {
            LOGGER.warn("Unrecognised gamemode \"" + gamemodeProperty + "\"! Gamemodes must be in namespace ID format, e.g. \"minecraft:gamemode/survival\".");
        }
        this.defaultGamemode = Objects.requireNonNullElse(gamemodeFromProperty, Gamemodes.SURVIVAL);
        if (this.defaultWorldType == null) {
            WorldType legacyWorldType;
            String worldTypeString = this.propertyManager.getStringProperty("world-type", null);
            if (worldTypeString == null) {
                this.defaultWorldType = WorldTypes.OVERWORLD_EXTENDED;
            }
            if ((legacyWorldType = LegacyWorldTypes.getWorldTypeByKey(worldTypeString)) != null) {
                this.defaultWorldType = legacyWorldType;
                this.propertyManager.setProperty("world-type", Registries.WORLD_TYPES.getKey(this.defaultWorldType));
                this.propertyManager.saveProperties();
            } else {
                this.defaultWorldType = WorldTypes.OVERWORLD_EXTENDED;
            }
        }
        this.entityTrackerMap = new Int2ObjectOpenHashMap<EntityTrackerImpl>();
        new Registries();
        BiomeProviderOverworld.init();
        DataLoader.loadRecipesFromFile("/recipes/blast_furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/furnace.json");
        DataLoader.loadRecipesFromFile("/recipes/trommel.json");
        DataLoader.loadRecipesFromFile("/recipes/workbench.json");
        DataLoader.loadDataPacks(this);
        int recipes = Registries.RECIPES.getAllRecipes().size();
        int groups2 = Registries.RECIPES.getAllGroups().size();
        int namespaces = Registries.RECIPES.size();
        int itemGroups = Registries.ITEM_GROUPS.size();
        this.logInfo(String.format("%d item groups.", itemGroups));
        this.logInfo(String.format("%d recipes in %d groups in %d namespaces.", recipes, groups2, namespaces));
        SoundTypes.registerSounds();
        I18n.initialize(this.language);
        StatList.init();
        if (!statsToken.equals("only-enter-a-value-if-you-are-a-registered-server") && !statsToken.isEmpty()) {
            statsStatus = true;
            int errorCode = RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + statsToken + "&count=0");
            switch (errorCode) {
                case 401: {
                    LOGGER.warn("Your server stats token is invalid. Please clear server.properties -> stats-token");
                    statsStatus = false;
                    break;
                }
                case 503: {
                    LOGGER.warn("Cannot access server stats API! Your server might be offline.");
                    statsStatus = false;
                }
            }
        }
        InetAddress inetaddress = null;
        if (!s.isEmpty()) {
            inetaddress = InetAddress.getByName(s);
        }
        int port = this.argPort >= 0 ? this.argPort : this.propertyManager.getIntProperty("server-port", 25565);
        LOGGER.info("Starting Minecraft server on {}:{}", (Object)(!s.isEmpty() ? s : "*"), (Object)port);
        try {
            this.networkServer = new NetworkListenThread(this, inetaddress, port);
        }
        catch (IOException ioexception) {
            LOGGER.warn("**** FAILED TO BIND TO PORT!");
            LOGGER.warn("The exception was: " + String.valueOf(ioexception));
            LOGGER.warn("Perhaps a server is already running on that port?");
            return false;
        }
        if (!this.onlineMode) {
            LOGGER.warn("**** SERVER IS RUNNING IN OFFLINE/INSECURE MODE!");
            LOGGER.warn("The server will make no attempt to authenticate usernames. Beware.");
            LOGGER.warn("While this makes the game possible to play without internet access, it also opens up the ability for hackers to connect with any username they choose.");
            LOGGER.warn("To change this, set \"online-mode\" to \"true\" in the server.properties file.");
        }
        this.playerList = new PlayerList(this);
        for (Int2ObjectMap.Entry entry : Dimension.getDimensionList().int2ObjectEntrySet()) {
            this.entityTrackerMap.put(entry.getIntKey(), new EntityTrackerImpl(this, (Dimension)entry.getValue()));
        }
        long time = System.nanoTime();
        String lName = this.argWorld == null ? this.propertyManager.getStringProperty("level-name", "world") : this.argWorld;
        String lSeed = this.propertyManager.getStringProperty("level-seed", "");
        long randomLong = new Random().nextLong();
        if (!lSeed.isEmpty()) {
            try {
                randomLong = Long.parseLong(lSeed);
            }
            catch (NumberFormatException numberformatexception) {
                randomLong = lSeed.hashCode();
            }
        }
        LOGGER.info("Preparing level \"{}\"", (Object)lName);
        this.initWorld(new SaveFormat19134(new File(".")), lName, randomLong);
        LOGGER.info("Generating RSA key...");
        try {
            RSA.RSAKeyChain = RSA.generateKeyPair();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("Done (" + (System.nanoTime() - time) + "ns)! For help, type \"help\" or \"?\"");
        return true;
    }

    public void initCommands() {
        CommandManager.registerCommand(new CommandAchievement());
        CommandManager.registerCommand(new CommandClear());
        CommandManager.registerCommand(new CommandKill());
        CommandManager.registerCommand(new CommandSeed());
        CommandManager.registerCommand(new CommandSetBlock());
        CommandManager.registerCommand(new CommandSummon());
        CommandManager.registerCommand(new CommandTeleport());
        CommandManager.registerCommand(new CommandMessage());
        CommandManager.registerCommand(new CommandSetSpawn());
        CommandManager.registerCommand(new CommandTime());
        CommandManager.registerCommand(new CommandGameMode());
        CommandManager.registerCommand(new CommandWeather());
        CommandManager.registerCommand(new CommandSpawn());
        CommandManager.registerCommand(new CommandPlace());
        CommandManager.registerCommand(new CommandHelp());
        CommandManager.registerCommand(new CommandChunk());
        CommandManager.registerCommand(new CommandGive());
        CommandManager.registerCommand(new CommandGameRule());
        CommandManager.registerCommand(new CommandFill());
        CommandManager.registerCommand(new CommandClone());
        CommandManager.registerCommand(new CommandBiome());
        CommandManager.registerCommand(new CommandSay());
        CommandManager.registerCommand(new CommandTellRaw());
        CommandManager.registerCommand(new CommandTestFor());
        CommandManager.registerCommand(new CommandDamage());
        CommandManager.registerCommand(new CommandHeal());
        CommandManager.registerCommand(new CommandMobSpawning());
        CommandManager.registerCommand(new CommandPlaySound());
        CommandManager.registerCommand(new CommandParticle());
        CommandManager.registerServerCommand(new CommandStop());
        CommandManager.registerServerCommand(new CommandOp());
        CommandManager.registerServerCommand(new CommandDeop());
        CommandManager.registerServerCommand(new CommandList());
        CommandManager.registerServerCommand(new CommandDifficulty());
        CommandManager.registerServerCommand(new CommandColor());
        CommandManager.registerServerCommand(new CommandNickname());
        CommandManager.registerServerCommand(new CommandWhoIs());
        CommandManager.registerServerCommand(new CommandScore());
        CommandManager.registerServerCommand(new CommandMe());
        CommandManager.registerServerCommand(new CommandEmotes());
        CommandManager.registerServerCommand(new CommandBan());
        CommandManager.registerServerCommand(new CommandUnban());
        CommandManager.registerServerCommand(new CommandKick());
        CommandManager.registerServerCommand(new CommandWhitelist());
        CommandManager.registerServerCommand(new CommandSave());
    }

    private void convertWorld(ISaveFormat saveFormat, String worldDirName) {
        int worldSaveVersion = 0;
        try {
            LevelData info = new LevelData(new File(worldDirName));
            worldSaveVersion = info.getSaveVersion();
        }
        catch (IOException e) {
            worldSaveVersion = saveFormat.getSaveVersion();
        }
        if (worldSaveVersion < 19134) {
            this.doWorldConversion(worldSaveVersion, worldDirName);
        }
    }

    private void doWorldConversion(int fromVersion, String worldDirName) {
        ConvertProgressUpdater updater = new ConvertProgressUpdater();
        ISaveFormat fromWorldFormat = SaveFormats.createSaveFormat(fromVersion, new File("."));
        if (fromWorldFormat != null) {
            ISaveFormat toWorldFormat;
            ISaveConverter converterToUse = null;
            for (ISaveConverter converter : SaveConverters.saveConverters) {
                if (converter.fromVersion() != fromVersion || converterToUse != null && converter.toVersion() <= converterToUse.toVersion()) continue;
                converterToUse = converter;
            }
            if (converterToUse != null && (toWorldFormat = SaveFormats.createSaveFormat(converterToUse.toVersion(), new File("."))) != null) {
                CompoundTag levelDataTag = toWorldFormat.getLevelDataRaw(worldDirName);
                converterToUse.convertSave(levelDataTag, new File("."), worldDirName, updater);
                levelDataTag.putInt("version", toWorldFormat.getSaveVersion());
                LevelStorage saveHandler = toWorldFormat.getSaveHandler(worldDirName, false);
                saveHandler.saveLevelDataRaw(levelDataTag);
            }
        }
    }

    private void initWorld(ISaveFormat saveFormat, String worldDirName, long l) {
        this.convertWorld(saveFormat, worldDirName);
        this.dimensionWorlds = new Int2ObjectArrayMap<WorldServer>();
        SaveHandlerServer saveHandler = new SaveHandlerServer(saveFormat, new File("."), worldDirName, true);
        for (Int2ObjectMap.Entry entry : Dimension.getDimensionList().int2ObjectEntrySet()) {
            int dimId = entry.getIntKey();
            Dimension dimension = (Dimension)entry.getValue();
            WorldServer worldServer = dimId == 0 ? new WorldServer(this, saveHandler, worldDirName, dimId, this.defaultWorldType, l) : new WorldServerMulti(this, saveHandler, worldDirName, dimId, dimension.defaultWorldType, l, (WorldServer)this.dimensionWorlds.get(0));
            this.dimensionWorlds.put(dimId, worldServer);
            worldServer.addListener(new WorldManager(this, (WorldServer)this.dimensionWorlds.get(dimId)));
            worldServer.setDifficulty(this.difficulty, true);
            worldServer.sleepPercent = this.sleepPercentage;
            worldServer.getSpawnerConfig().setHostileSpawning(this.spawnHostiles);
            worldServer.getSpawnerConfig().setPassiveSpawning(this.spawnAnimals);
            this.playerList.setPlayerManager(this.dimensionWorlds);
        }
        int c = 196;
        long l2 = System.currentTimeMillis();
        for (WorldServer worldServer : this.dimensionWorlds.values()) {
            LOGGER.info("Preparing start region for level {}", (Object)worldServer.dimension);
            if (worldServer.dimension == Dimension.NETHER && !this.propertyManager.getBooleanProperty("allow-nether", true) || worldServer.dimension == Dimension.DRIFT && !this.propertyManager.getBooleanProperty("allow-drift", false)) continue;
            TilePos chunkcoordinates = worldServer.getSpawnPoint();
            for (int k = -c; k <= c && this.serverRunning; k += 16) {
                for (int i1 = -c; i1 <= c && this.serverRunning; i1 += 16) {
                    long l22 = System.currentTimeMillis();
                    if (l22 < l2) {
                        l2 = l22;
                    }
                    if (l22 > l2 + 1000L) {
                        int j1 = (c * 2 + 1) * (c * 2 + 1);
                        int k1 = (k + c) * (c * 2 + 1) + (i1 + 1);
                        this.outputPercentRemaining("Preparing spawn area", k1 * 100 / j1);
                        l2 = l22;
                    }
                    worldServer.chunkProviderServer.prepareChunk(chunkcoordinates.x + k >> 4, chunkcoordinates.z + i1 >> 4);
                    while (worldServer.updatingLighting() && this.serverRunning) {
                    }
                }
            }
        }
        this.clearCurrentTask();
    }

    private void outputPercentRemaining(String s, int i) {
        this.currentTask = s;
        this.percentDone = i;
        LOGGER.info("{}: {}%", (Object)s, (Object)i);
    }

    private void clearCurrentTask() {
        this.currentTask = null;
        this.percentDone = 0;
    }

    private void saveServerWorld() {
        LOGGER.info("Saving chunks");
        for (WorldServer worldServer : this.dimensionWorlds.values()) {
            worldServer.saveWorld(true, null, worldServer.dimension == Dimension.OVERWORLD);
            worldServer.checkLock();
        }
    }

    public void stopServer() {
        LOGGER.info("Stopping server");
        if (statsStatus) {
            RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + statsToken + "&count=0");
        }
        this.propertyManager.setProperty("difficulty", this.difficulty);
        this.propertyManager.saveProperties();
        if (this.playerList != null) {
            this.playerList.savePlayerStates();
        }
        this.saveServerWorld();
        for (WorldServer worldServer : this.dimensionWorlds.values()) {
            worldServer.close();
        }
    }

    public void initiateShutdown() {
        this.serverRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            if (this.startServer()) {
                long startTime = System.currentTimeMillis();
                long timeSinceLastTick = 0L;
                int i = 0;
                while (this.serverRunning) {
                    this.networkServer.handleNetworkListenThread();
                    long currentTime = System.currentTimeMillis();
                    long timeChange = currentTime - startTime;
                    if (timeChange > 2000L) {
                        LOGGER.warn("Can't keep up! Did the system time change, or is the server overloaded?");
                        timeChange = 2000L;
                    }
                    if (timeChange < 0L) {
                        LOGGER.warn("Time ran backwards! Did the system time change?");
                        timeChange = 0L;
                    }
                    timeSinceLastTick += timeChange;
                    startTime = currentTime;
                    if (((WorldServer)this.dimensionWorlds.get(Dimension.OVERWORLD.id)).areEnoughPlayersFullyAsleep()) {
                        this.doTick();
                        timeSinceLastTick = 0L;
                    } else {
                        while (timeSinceLastTick > 10L) {
                            timeSinceLastTick -= 10L;
                            ++i;
                            for (PlayerServer player : this.playerList.playerEntities) {
                                player.tickSendChunks();
                            }
                            if (i % 5 != 0) continue;
                            this.doTick();
                            i = 0;
                        }
                    }
                    Thread.sleep(1L);
                }
                return;
            } else {
                while (this.serverRunning) {
                    this.commandLineParser();
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        LOGGER.error("", e);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable1) {
            LOGGER.error("Unexpected exception", throwable1);
            while (this.serverRunning) {
                this.commandLineParser();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    LOGGER.error("", e);
                }
            }
            return;
        }
        finally {
            try {
                this.stopServer();
                this.serverStopped = true;
            }
            catch (Throwable t) {
                LOGGER.error("Caught throwable in shutdown sequence!", t);
            }
            finally {
                System.exit(0);
            }
        }
    }

    private void doTick() {
        ObjectPool.resetAllPools();
        ++this.deathTime;
        for (WorldServer worldServer : this.dimensionWorlds.values()) {
            if (worldServer.dimension == Dimension.NETHER && !this.propertyManager.getBooleanProperty("allow-nether", true) || worldServer.dimension == Dimension.DRIFT && !this.propertyManager.getBooleanProperty("allow-drift", false)) continue;
            if (this.deathTime % 20 == 0) {
                this.playerList.sendPacketToAllPlayersInDimension(new PacketSetTime(worldServer.getWorldTime()), worldServer.dimension.id);
            }
            try {
                worldServer.tick();
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled exception while ticking dimension {}!", (Object)worldServer.dimension, (Object)t);
                this.initiateShutdown();
                break;
            }
            try {
                while (worldServer.updatingLighting()) {
                }
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled exception while updating lighting in dimension {}!", (Object)worldServer.dimension, (Object)t);
            }
            try {
                worldServer.updateEntities();
            }
            catch (Throwable t) {
                LOGGER.error("Unhandled exception while updating entities in dimension {}!", (Object)worldServer.dimension, (Object)t);
                this.initiateShutdown();
                break;
            }
        }
        this.networkServer.handleNetworkListenThread();
        this.playerList.onTick();
        for (EntityTrackerImpl tracker : this.entityTrackerMap.values()) {
            tracker.tick();
        }
        for (int l = 0; l < this.playerListBoxes.size(); ++l) {
            this.playerListBoxes.get(l).update();
        }
        try {
            this.commandLineParser();
        }
        catch (Exception exception) {
            LOGGER.warn("Unexpected exception while parsing console command", exception);
        }
        if (this.ticksSinceLastBroadcast++ >= 30) {
            this.ticksSinceLastBroadcast = 0;
            try {
                this.multicastPublisher.multicast(String.format("[MOTD]%s[/MOTD][AD]%s[/AD][NAME]%s[/NAME]", this.motd, this.propertyManager.getIntProperty("server-port", 25565), this.name));
            }
            catch (IOException e) {
                LOGGER.error("", e);
            }
        }
    }

    public void addCommand(String s, ICommandListener icommandlistener) {
        this.commands.add(new ServerCommandEntry(s, icommandlistener));
    }

    public void commandLineParser() {
        while (!this.commands.isEmpty()) {
            ServerCommandEntry serverCommand = this.commands.remove(0);
            String command = serverCommand.command;
            ConsoleCommandSource source = new ConsoleCommandSource(this);
            try {
                this.getDimensionWorld(0).getCommandManager().execute(command, source);
            }
            catch (CommandSyntaxException e) {
                source.sendMessage(e.getMessage());
            }
        }
    }

    public void addPlayerListBox(IUpdatePlayerListBox listBox) {
        this.playerListBoxes.add(listBox);
    }

    public static void main(String[] args2) {
        boolean nogui = false;
        Boolean offline = null;
        String world = null;
        int port = -1;
        int pointer = 0;
        block21: while (pointer < args2.length) {
            switch (args2[pointer]) {
                case "nogui": 
                case "--nogui": {
                    nogui = true;
                    ++pointer;
                    continue block21;
                }
                case "--debug": {
                    Global.DEBUG_MODE = true;
                    continue block21;
                }
                case "--offline": {
                    offline = true;
                    ++pointer;
                    continue block21;
                }
                case "--world": {
                    try {
                        world = args2[pointer + 1];
                        ++pointer;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ++pointer;
                    continue block21;
                }
                case "--port": {
                    try {
                        port = Integer.parseInt(args2[pointer + 1]);
                        ++pointer;
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            ++pointer;
        }
        try {
            MinecraftServer server = new MinecraftServer();
            server.argOffline = offline;
            server.argWorld = world;
            server.argPort = port;
            if (!nogui && !GraphicsEnvironment.isHeadless()) {
                ServerGui.initGui(server);
            }
            new Thread((Runnable)server, "Server thread").start();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to start the minecraft server", exception);
        }
    }

    public File getFile(String s) {
        return new File(s);
    }

    @Override
    public File getMinecraftDir() {
        return new File(".");
    }

    @Override
    public String getMinecraftVersion() {
        return VERSION;
    }

    @Override
    public IChunkProvider createChunkProvider(World world, IChunkLoader chunkLoader) {
        return new ChunkProviderServer((WorldServer)world, chunkLoader, world.worldType.createChunkGenerator(world));
    }

    @Override
    public void logInfo(String s) {
        LOGGER.info(s);
    }

    @Override
    public String getUsername() {
        return "CONSOLE";
    }

    public WorldServer getDimensionWorld(int dimId) {
        return (WorldServer)this.dimensionWorlds.get(dimId);
    }

    public EntityTrackerImpl getEntityTracker(int dimId) {
        return (EntityTrackerImpl)this.entityTrackerMap.get(dimId);
    }

    public static boolean isServerRunning(MinecraftServer minecraftserver) {
        return minecraftserver.serverRunning;
    }

    public static MinecraftServer getInstance() {
        return instance;
    }

    @Override
    public int getAutosaveTimer() {
        return this.autoSaveInterval;
    }

    @Override
    public SkinVariantList getSkinVariantList() {
        return this.skinVariantList;
    }
}

