/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicRedstone
extends BlockLogic {
    public BlockLogicRedstone(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
    }

    @Override
    public boolean isSignalSource() {
        return true;
    }

    @Override
    public boolean isEmittingSignal(@NotNull WorldSource source, @NotNull TilePosc tilePos, @NotNull Side side) {
        return true;
    }

    @Override
    public boolean isEmittingDirectSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return true;
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(dir, queryPos), this.block);
        }
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            world.notifyBlocksOfNeighborChange(tilePos.add(dir, queryPos), this.block);
        }
    }

    @Override
    public void animationTick(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        Random random = world.rand;
        int redstoneBrightness = 10;
        double d = 0.0625;
        TilePos queryPos = new TilePos();
        for (Direction dir : Direction.directions) {
            double px = (double)tilePos.x() + (double)random.nextFloat();
            double py = (double)tilePos.y() + (double)random.nextFloat();
            double pz = (double)tilePos.z() + (double)random.nextFloat();
            switch (dir) {
                case DOWN: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    py = (double)(tilePos.y() + 1) + 0.0625;
                    break;
                }
                case UP: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    py = (double)(tilePos.y() + 0) - 0.0625;
                    break;
                }
                case NORTH: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    pz = (double)(tilePos.z() + 1) + 0.0625;
                    break;
                }
                case SOUTH: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    pz = (double)(tilePos.z() + 0) - 0.0625;
                    break;
                }
                case WEST: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    px = (double)(tilePos.x() + 1) + 0.0625;
                    break;
                }
                case EAST: {
                    if (world.isBlockOpaqueCube(tilePos.add(dir.getOpposite(), queryPos))) break;
                    px = (double)(tilePos.x() + 0) - 0.0625;
                }
            }
            if (!(px < (double)tilePos.x() || px > (double)(tilePos.x() + 1) || py < 0.0 || py > (double)(tilePos.y() + 1) || pz < (double)tilePos.z()) && !(pz > (double)(tilePos.z() + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }
}

