/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBlockLamp<T extends BlockLogic>
extends ItemBlock<T> {
    public ItemBlockLamp(@NotNull Block<T> block) {
        super(block);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
    }

    @Override
    public int getPlacedData(@NotNull ItemStack selfStack, @NotNull World world, @Nullable Player player, @NotNull TilePosc blockPos, @NotNull Side side, double xHit, double yHit) {
        return selfStack.getMetadata();
    }

    @Override
    @NotNull
    public String getLanguageKey(@NotNull ItemStack selfStack) {
        return super.getKey() + "." + DyeColor.colorFromBlockMeta((int)selfStack.getMetadata()).colorID;
    }
}

