/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.collection;

public class Pair<A, B> {
    private final A left;
    private final B right;

    protected Pair(A left, B right) {
        this.left = left;
        this.right = right;
    }

    public static <A, B> Pair<A, B> of(A left, B right) {
        return new Pair<A, B>(left, right);
    }

    public A getLeft() {
        return this.left;
    }

    public B getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.getLeft() != null ? !this.getLeft().equals(pair.getLeft()) : pair.getLeft() != null) {
            return false;
        }
        return this.getRight() != null ? this.getRight().equals(pair.getRight()) : pair.getRight() == null;
    }

    public String toString() {
        return "Pair{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

