/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.core.world.settings.KeyedSettingNode;
import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.ValueSettingNode;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingNodesValues {
    @NotNull
    private final SettingNode rootNode;
    @NotNull
    private final @NotNull Map<@NotNull ValueSettingNode<?>, @NotNull Object> keyedNodeValues = new Object2ObjectOpenHashMap();
    @NotNull
    private final @NotNull Map<@NotNull String, @NotNull ValueSettingNode<?>> nodesByKey = new Object2ObjectOpenHashMap();

    public SettingNodesValues(@NotNull SettingNode rootNode) {
        this.rootNode = rootNode;
    }

    @NotNull
    public SettingNode getRootNode() {
        return this.rootNode;
    }

    @NotNull
    public <T> T getNodeValue(@NotNull ValueSettingNode<T> node) {
        @Nullable Object value = this.keyedNodeValues.get(node);
        if (value != null) {
            return (T)value;
        }
        @NotNull T defaultValue = node.getDefaultValue();
        this.keyedNodeValues.put(node, node.getDefaultValue());
        this.nodesByKey.put(node.getKey(), node);
        return defaultValue;
    }

    @NotNull
    public <T> T getNodeValue(@NotNull String key, @NotNull Class<T> valueClass, @NotNull WorldConfiguration worldConfiguration) {
        @Nullable ValueSettingNode node = this.nodesByKey.get(key);
        if (node == null) {
            @Nullable KeyedSettingNode keyedSettingNode = this.rootNode.getChildByKey(key, worldConfiguration);
            if (keyedSettingNode instanceof ValueSettingNode) {
                ValueSettingNode nodeByKeyFromRoot;
                node = nodeByKeyFromRoot = (ValueSettingNode)keyedSettingNode;
            } else {
                throw new IllegalArgumentException("Node does not have a value!");
            }
        }
        if (!valueClass.isAssignableFrom(node.getValueClass())) {
            throw new IllegalArgumentException("Node type " + node.getValueClass().getSimpleName() + " does not equal requested type " + valueClass.getSimpleName() + "!");
        }
        return (T)this.getNodeValue(node);
    }

    public <T> void setNodeValue(@NotNull ValueSettingNode<T> node, @NotNull T value) {
        this.keyedNodeValues.put(node, value);
        this.nodesByKey.put(node.getKey(), node);
    }

    public <T> void setNodeValue(@NotNull String key, @NotNull T value, @NotNull WorldConfiguration worldConfiguration) {
        @Nullable ValueSettingNode node = this.nodesByKey.get(key);
        if (node == null) {
            @Nullable KeyedSettingNode keyedSettingNode = this.rootNode.getChildByKey(key, worldConfiguration);
            if (keyedSettingNode instanceof ValueSettingNode) {
                ValueSettingNode nodeByKeyFromRoot;
                node = nodeByKeyFromRoot = (ValueSettingNode)keyedSettingNode;
            } else {
                throw new IllegalArgumentException("Node does not have a value!");
            }
        }
        if (!value.getClass().isAssignableFrom(node.getValueClass())) {
            throw new IllegalArgumentException("Node type " + node.getValueClass().getSimpleName() + " does not equal requested type " + value.getClass().getSimpleName() + "!");
        }
        this.setNodeValue(node, value);
    }
}

