/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import net.minecraft.core.lang.text.IntoText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.settings.ListValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeasonSettingNode
extends ListValueGenericSettingNode<SeasonEntry> {
    @NotNull
    public static final SeasonEntry DISABLED = new SeasonEntry();

    public SeasonSettingNode(@NotNull String key, @NotNull Text name, @NotNull SeasonEntry defaultValue) {
        super(key, name, defaultValue);
    }

    public static class SeasonEntry
    implements IntoText {
        @NotNull
        private final Text text;
        @Nullable
        public final Season season;

        private SeasonEntry() {
            this.season = null;
            this.text = new TranslatableText("world_settings.single_season.disabled");
        }

        public SeasonEntry(@NotNull Season season) {
            this.season = season;
            this.text = new TranslatableText(season.getLanguageKey());
        }

        @Override
        @NotNull
        public Text intoText() {
            return this.text;
        }
    }
}

