/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicFlowerStackable;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicJar
extends BlockLogic
implements ISupportable {
    @NotNull
    private final @NotNull Supplier<@NotNull Item> itemSupplier;

    public BlockLogicJar(@NotNull Block<?> block, @NotNull @NotNull Supplier<@NotNull Item> itemSupplier) {
        super(block, Materials.GLASS);
        block.withEntity(TileEntityFlowerJar::new);
        this.setBlockBounds(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
        this.itemSupplier = itemSupplier;
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM) && super.canPlaceAt(world, tilePos);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return new AABBd(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return side == Side.BOTTOM ? PartialSupport.INSTANCE.center() : PartialSupport.INSTANCE;
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TileEntity flowerData2;
        Block blockInHand;
        if (player.getHeldItem() == null) {
            if (world.getBlockData(tilePos) == 0) {
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
                world.playSoundAtEntity(player, player, "item.pickup", 1.0f, 1.0f);
                if (!world.isClientSide) {
                    world.dropItem(tilePos, new ItemStack(this.itemSupplier.get(), 1, 0));
                }
            } else {
                TileEntity tileEntity = world.getTileEntity(tilePos);
                if (tileEntity instanceof TileEntityFlowerJar) {
                    TileEntityFlowerJar flowerJar = (TileEntityFlowerJar)tileEntity;
                    int flowerInPot = flowerJar.flowerInPot;
                    int flowerData2 = flowerJar.flowerData;
                    if (flowerInPot > 0 && Blocks.hasTag(flowerInPot, BlockTags.PLANTABLE_IN_JAR)) {
                        flowerJar.flowerInPot = 0;
                        world.setBlockDataNotify(tilePos, 0);
                        world.playSoundAtEntity(player, player, "item.pickup", 1.0f, 1.0f);
                        if (!world.isClientSide) {
                            if (Block.hasLogicClass(Blocks.getBlock(flowerInPot), BlockLogicFlowerStackable.class)) {
                                for (int i = 0; i <= BlockLogicFlowerStackable.getStackCount(flowerData2); ++i) {
                                    world.dropItem(tilePos, new ItemStack(flowerInPot, 1, 0));
                                }
                            } else {
                                world.dropItem(tilePos, new ItemStack(flowerInPot, 1, flowerData2));
                            }
                        }
                    }
                }
            }
        } else if (player.getHeldItem().getItem() instanceof ItemBlock && Blocks.hasTag((blockInHand = ((ItemBlock)player.getHeldItem().getItem()).getBlock()).id(), BlockTags.PLANTABLE_IN_JAR) && (flowerData2 = world.getTileEntity(tilePos)) instanceof TileEntityFlowerJar) {
            TileEntityFlowerJar flowerJar = (TileEntityFlowerJar)flowerData2;
            if (world.getBlockData(tilePos) == 0) {
                player.getHeldItem().consumeItem(player);
                world.setBlockDataNotify(tilePos, 1);
                flowerJar.flowerInPot = blockInHand.id();
                flowerJar.flowerData = player.getHeldItem().getMetadata();
                world.playBlockSoundEffect(player, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                return true;
            }
            if (blockInHand.getLogic() instanceof BlockLogicFlowerStackable && blockInHand == Blocks.getBlock(flowerJar.flowerInPot)) {
                int metadata = flowerJar.flowerData;
                int currentStackCount = BlockLogicFlowerStackable.getStackCount(metadata);
                if (currentStackCount >= 3) {
                    return false;
                }
                flowerJar.flowerData = BlockLogicFlowerStackable.setPermanent(BlockLogicFlowerStackable.setStackCount(metadata, currentStackCount + 1), true);
                world.playBlockSoundEffect(player, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                player.getHeldItem().consumeItem(player);
                return true;
            }
        }
        return true;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        ItemStack[] itemStackArray;
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: 
            case WORLD: {
                ItemStack[] itemStackArray2 = new ItemStack[1];
                itemStackArray = itemStackArray2;
                itemStackArray2[0] = new ItemStack(this.itemSupplier.get());
                break;
            }
            default: {
                itemStackArray = null;
            }
        }
        return itemStackArray;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE.center();
    }
}

