/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicLadder
extends BlockLogic
implements ISupportable {
    public BlockLogicLadder(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isClimbable(@NotNull World world, @NotNull TilePosc tilePos) {
        return true;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        Side side = this.getSideFromMeta(source.getBlockData(tilePos));
        float width = 0.1875f;
        return switch (side) {
            case Side.SOUTH -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, width);
            case Side.WEST -> new AABBd(1.0f - width, 0.0, 0.0, 1.0, 1.0, 1.0);
            case Side.EAST -> new AABBd(0.0, 0.0, 0.0, width, 1.0, 1.0);
            default -> new AABBd(0.0, 0.0, 1.0f - width, 1.0, 1.0, 1.0);
        };
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        if (!this.canExistAt(world, tilePos, world.getBlockData(tilePos))) {
            this.dropWithCause(world, EnumDropCause.WORLD, tilePos, block.id(), null, null);
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public final boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return true;
    }

    @Override
    public boolean canPlaceOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return true;
    }

    public Side getSideForPlacement(@NotNull World world, @NotNull TilePos tilePos, @NotNull Side clickedSide) {
        TilePos p = tilePos;
        if (!world.canPlaceInsideBlock(tilePos)) {
            p = p.add(clickedSide.getDirection(), new TilePos());
        }
        if (this.canExistAt(world, p, this.getMetaForSide(clickedSide))) {
            return clickedSide;
        }
        if (this.canExistAt(world, p, this.getMetaForSide(Side.NORTH))) {
            return Side.NORTH;
        }
        if (this.canExistAt(world, p, this.getMetaForSide(Side.SOUTH))) {
            return Side.SOUTH;
        }
        if (this.canExistAt(world, p, this.getMetaForSide(Side.WEST))) {
            return Side.WEST;
        }
        if (this.canExistAt(world, p, this.getMetaForSide(Side.EAST))) {
            return Side.EAST;
        }
        return null;
    }

    public boolean canExistAt(@NotNull World world, @NotNull TilePosc tilePos, int meta) {
        Side side = this.getSideFromMeta(meta).getOpposite();
        return this.isSupported(world, tilePos, side);
    }

    public Side getSideFromMeta(int meta) {
        if (meta == 2) {
            return Side.NORTH;
        }
        if (meta == 3) {
            return Side.SOUTH;
        }
        if (meta == 4) {
            return Side.WEST;
        }
        if (meta == 5) {
            return Side.EAST;
        }
        return Side.NONE;
    }

    public int getMetaForSide(@NotNull Side side) {
        if (side == Side.NORTH) {
            return 2;
        }
        if (side == Side.SOUTH) {
            return 3;
        }
        if (side == Side.WEST) {
            return 4;
        }
        if (side == Side.EAST) {
            return 5;
        }
        return 0;
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return FullSupport.INSTANCE;
    }
}

