/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.ISupportable;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBdc;

public class BlockLogicStalk
extends BlockLogic
implements ISupportable {
    public BlockLogicStalk(@NotNull Block<?> block) {
        super(block, Materials.PLANT);
        block.setTicking(true);
        float offset = 0.2f;
        this.setBlockBounds(0.5f - offset, 0.0, 0.5f - offset, 0.5f + offset, offset * 3.0f, 0.5f + offset);
    }

    @Override
    public boolean canPlaceAt(@NotNull World world, @NotNull TilePosc tilePos) {
        return super.canPlaceAt(world, tilePos) && this.canStay(world, tilePos);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    @Nullable
    public AABBdc getCollisionAABB(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        return null;
    }

    @Override
    public boolean canStay(@NotNull World world, @NotNull TilePosc tilePos) {
        return this.isSupported(world, tilePos, Side.BOTTOM);
    }

    @Override
    @NotNull
    public ISupport getSupportConstraint(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return FullSupport.INSTANCE;
    }
}

