/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.gamerule;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.data.gamerule.GameRule;
import org.jetbrains.annotations.NotNull;

public class GameRuleBoolean
extends GameRule<Boolean> {
    public GameRuleBoolean(String key, String translationKey, Boolean defaultValue) {
        super(key, translationKey, defaultValue);
    }

    @Override
    public void writeToNBT(@NotNull CompoundTag tag, Boolean value) {
        ByteTag ruleTag = new ByteTag();
        ruleTag.setValue((byte)(value != false ? 1 : 0));
        tag.put(this.getKey(), ruleTag);
    }

    @Override
    public Boolean readFromNBT(@NotNull CompoundTag tag) {
        Tag<?> ruleTag = tag.getTag(this.getKey());
        if (ruleTag instanceof ByteTag) {
            ByteTag ruleTagByte = (ByteTag)ruleTag;
            return (Byte)ruleTagByte.getValue() != 0;
        }
        return (Boolean)this.getDefaultValue();
    }

    @Override
    public Boolean parseFromString(@NotNull String string) {
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            int val = Integer.parseInt(string);
            return val != 0;
        }
        catch (NumberFormatException e) {
            return (Boolean)this.getDefaultValue();
        }
    }
}

