/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk.perlin.nether;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProviderNether;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.generate.chunk.perlin.DensityGenerator;
import net.minecraft.core.world.noise.FractalNoise2D;
import net.minecraft.core.world.noise.FractalNoise3D;
import net.minecraft.core.world.noise.ImprovedPerlinNoise;
import net.minecraft.core.world.noise.Noise2D;
import net.minecraft.core.world.noise.Noise3D;
import net.minecraft.core.world.noise.SimplexNoise;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;

public class DensityGeneratorNether
implements DensityGenerator {
    @NotNull
    private final World world;
    @NotNull
    private final Noise3D minLimitNoise;
    @NotNull
    private final Noise3D maxLimitNoise;
    @NotNull
    private final Noise3D mainNoise;
    @NotNull
    private final Noise2D scaleNoise;
    @NotNull
    private final Noise2D depthNoise;
    @NotNull
    private final FractalNoise2D<?> poolNoiseOver;
    @NotNull
    private final FractalNoise2D<?> poolNoiseUnder;
    @NotNull
    private final FractalNoise2D<?> ravineNoise2;
    @NotNull
    private final FractalNoise2D<?> islandNoise;
    @NotNull
    private final @NotNull Map<@NotNull Biome, @NotNull BiomeDensityGenerator> densityGeneratorMap = new HashMap<Biome, BiomeDensityGenerator>();

    public DensityGeneratorNether(World world) {
        this.world = world;
        this.minLimitNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 16, 0));
        this.maxLimitNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 16, 16));
        this.mainNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 8, 32));
        this.scaleNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 10, 48));
        this.depthNoise = new FractalNoise3D((Noise3D[])ImprovedPerlinNoise.genOctaves(world.getRandomSeed(), 16, 58));
        long seed = world.getRandomSeed();
        this.islandNoise = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed, 6, 0));
        this.ravineNoise2 = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed, 4, 6));
        this.poolNoiseOver = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed, 4, 10));
        this.poolNoiseUnder = new FractalNoise3D((Noise3D[])SimplexNoise.genOctaves(seed, 1, 14));
        this.densityGeneratorMap.put(Biomes.NETHER_NETHER, this::generateDensityMapBiomeNether);
        this.densityGeneratorMap.put(Biomes.NETHER_VOLCANIC_ISLANDS, this::generateDensityMapBiomeNether);
        this.densityGeneratorMap.put(Biomes.NETHER_SULFUR_POOLS, this::generateDensityMapBiomeNether);
        this.densityGeneratorMap.put(Biomes.NETHER_CRYSTAL_FOREST, this::generateDensityMapBiomeNether);
        this.densityGeneratorMap.put(Biomes.NETHER_ASH_PLAINS, this::generateDensityMapBiomeNether);
        this.densityGeneratorMap.put(Biomes.NETHER_BONEYARD, this::generateDensityMapBiomeNether);
    }

    @Override
    public double @NotNull [] generateDensityMap(@NotNull Chunk chunk) {
        int dx;
        WorldType worldType = this.world.getWorldType();
        int terrainHeight = worldType.getMaxY() + 1 - worldType.getMinY();
        int xSize = 5;
        int ySize = terrainHeight / 8 + 1;
        int zSize = 5;
        int x = chunk.pos.x * 4;
        int y = 0;
        int z = chunk.pos.z * 4;
        int quarterYSize = terrainHeight / 4 / 8 + 1;
        int threeQuarterYSize = (int)((float)terrainHeight * 0.75f) / 8 + 1;
        double[] densityMapArray = new double[xSize * ySize * zSize];
        HashMap<Biome, double[]> perBiomeDensityMaps = new HashMap<Biome, double[]>();
        BiomeProviderNether biomeProvider = (BiomeProviderNether)this.world.getBiomeProvider();
        BiomeProviderNether.BiomeOverlapPair[] overlapPairs = new BiomeProviderNether.BiomeOverlapPair[xSize * zSize];
        int xSizeScale = 16 / xSize;
        for (dx = 0; dx < xSize; ++dx) {
            int ix = dx * xSizeScale + xSizeScale / 2;
            for (int dz = 0; dz < zSize; ++dz) {
                int iz = dz * xSizeScale + xSizeScale / 2;
                double temperature = chunk.temperature[ix * 16 + iz];
                BiomeProviderNether.BiomeOverlapPair biomeOverlapPair = new BiomeProviderNether.BiomeOverlapPair();
                overlapPairs[dx * xSize + dz] = biomeOverlapPair;
                BiomeProviderNether.BiomeOverlapPair overlapPair = biomeOverlapPair;
                biomeProvider.getOverlap(temperature, overlapPair);
                if (!perBiomeDensityMaps.containsKey(overlapPair.biomeA)) {
                    perBiomeDensityMaps.put(overlapPair.biomeA, this.densityGeneratorMap.get(overlapPair.biomeA).generateDensityMap(chunk, (int)((float)terrainHeight * 0.75f), xSize, threeQuarterYSize, zSize, x, y, z));
                }
                if (!overlapPair.hasOverlap || perBiomeDensityMaps.containsKey(overlapPair.biomeB)) continue;
                perBiomeDensityMaps.put(overlapPair.biomeB, this.densityGeneratorMap.get(overlapPair.biomeB).generateDensityMap(chunk, (int)((float)terrainHeight * 0.75f), xSize, threeQuarterYSize, zSize, x, y, z));
            }
        }
        for (dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double densityA;
                int dy;
                BiomeProviderNether.BiomeOverlapPair overlapPair = overlapPairs[dx * xSize + dz];
                double[] densityMapA = (double[])perBiomeDensityMaps.get(overlapPair.biomeA);
                double[] densityMapB = null;
                if (overlapPair.hasOverlap) {
                    densityMapB = (double[])perBiomeDensityMaps.get(overlapPair.biomeB);
                }
                if (densityMapB != null) {
                    for (dy = 0; dy < threeQuarterYSize; ++dy) {
                        densityA = densityMapA[dx * zSize * threeQuarterYSize + dz * threeQuarterYSize + dy];
                        double densityB = densityMapB[dx * zSize * threeQuarterYSize + dz * threeQuarterYSize + dy];
                        densityMapArray[dx * zSize * ySize + dz * ySize + (dy + quarterYSize - 1)] = MathHelper.lerp(densityA, densityB, (double)overlapPair.biomeBPercentage);
                    }
                    continue;
                }
                for (dy = 0; dy < threeQuarterYSize; ++dy) {
                    densityMapArray[dx * zSize * ySize + dz * ySize + (dy + quarterYSize - 1)] = densityA = densityMapA[dx * zSize * threeQuarterYSize + dz * threeQuarterYSize + dy];
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapBiomeNether(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 60.0;
        double mainNoiseScaleZ = 80.0;
        double coordScale = 684.412;
        double heightScale = 2053.236;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 8.555150000000001, 34.2206, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 2053.236, 684.412);
        int mainIndex = 0;
        double[] densityOffsetArray = new double[ySize];
        for (int dy = 0; dy < ySize; ++dy) {
            densityOffsetArray[dy] = Math.cos((double)dy * Math.PI * 6.0 / (double)ySize) * 2.0;
            double densityOffset = dy;
            if (dy > ySize / 2) {
                densityOffset = ySize - 1 - dy;
            }
            if (!(densityOffset < 4.0)) continue;
            densityOffset = 4.0 - densityOffset;
            int n = dy;
            densityOffsetArray[n] = densityOffsetArray[n] - densityOffset * densityOffset * densityOffset * 10.0;
        }
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = densityOffsetArray[dy];
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy > ySize - 4) {
                        double densityMod = (float)(dy - (ySize - 4)) / 3.0f;
                        density = density * (1.0 - densityMod) + -10.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapFractured(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 1.121;
        double scaleNoiseScaleZ = 1.121;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = 3.0;
        double coordScale = 684.412;
        double heightScale = 684.412;
        double heightStretch = 12.0;
        double upperLimitScale = 256.0;
        double lowerLimitScale = 512.0;
        double ravineNoiseScale = 0.03;
        double[] scaleArray = this.scaleNoise.getRegion(null, x, z, xSize, zSize, 1.121, 1.121);
        double[] depthArray = this.depthNoise.getRegion(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] ravineNoise = this.ravineNoise2.setLacunarity(3.0).setPersistence(3.0).getRegion(null, x, z, xSize, zSize, ravineNoiseScale, ravineNoiseScale);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 512.0;
                if ((scale *= 0.5) > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 2000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * 6.0 / 16.0;
                double offsetY = 3.0 + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = ((double)dy - offsetY) * 12.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / 256.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    double densityMod = (1.0f - (3.0f - (float)dy)) / 3.0f;
                    float val = (float)ravineNoise[dx * zSize + dz] * 60.0f;
                    if ((double)val < 0.3) {
                        val = 0.0f;
                    }
                    density = dy > 3 ? (density += (double)val * 6.0) : (density += (double)val * 4.0 * ((double)dy / ((double)ySize / 2.0)) * ((double)dy / ((double)ySize / 2.0)));
                    if (dy > ySize - 7) {
                        densityMod = (float)(dy - (ySize - 7)) / 6.0f;
                        density = density * (1.0 - densityMod) + 300.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapOcean(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 1.121;
        double scaleNoiseScaleZ = 1.121;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = 2.5;
        double coordScale = 684.412;
        double heightScale = 684.412;
        double heightStretch = 12.0;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double noiseScale = 0.02;
        double[] scaleArray = this.scaleNoise.getRegion(null, x, z, xSize, zSize, 1.121, 1.121);
        double[] depthArray = this.depthNoise.getRegion(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] islandNoiseArray = this.islandNoise.setLacunarity(2.0).setPersistence(2.0).getRegion(null, x, z, xSize, zSize, 0.02, 0.02);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 2048.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 2000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * 5.0 / 16.0;
                double offsetY = 2.5 + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = ((double)dy - offsetY) * 12.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    float isl = (float)islandNoiseArray[dx * zSize + dz];
                    if ((double)isl > 0.5) {
                        isl *= 100.0f;
                    }
                    if ((double)isl < -0.2) {
                        isl = -isl * 100.0f;
                    }
                    if (dy > ySize - 9) {
                        double densityMod = (float)(dy - (ySize - 10)) / 6.0f;
                        density = density * (1.0 - densityMod) + 100.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density += (double)isl;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapBiomeTest(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 1.121;
        double scaleNoiseScaleZ = 1.121;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = 4.0;
        double coordScale = 684.412;
        double heightScale = 684.412;
        double heightStretch = 12.0;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double[] scaleArray = this.scaleNoise.getRegion(null, x, z, xSize, zSize, 1.121, 1.121);
        double[] depthArray = this.depthNoise.getRegion(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 684.412, 684.412, 684.412);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 2048.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 2000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * 8.0 / 16.0;
                double offsetY = 4.0 + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityOffset = ((double)dy - offsetY) * 12.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy > ySize - 7) {
                        double densityMod = (float)(dy - (ySize - 7)) / 6.0f;
                        density = density * (1.0 - densityMod) + 300.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapBiomeSulphurPools(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 8.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 8.0;
        double scaleNoiseScaleX = 9183.232;
        double scaleNoiseScaleZ = 9183.232;
        double poolNoiseScale = 0.2;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = 3.5;
        double coordScale = 6844.412;
        double heightScale = 684.412;
        double heightStretch = 512.0;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double[] scaleArray = this.scaleNoise.getRegion(null, x, z, xSize, zSize, 9183.232, 9183.232);
        double[] depthArray = this.depthNoise.getRegion(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 855.5515, 4.277575000000001, 855.5515);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 6844.412, 684.412, 6844.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 6844.412, 684.412, 6844.412);
        double[] poolOverArray = this.poolNoiseOver.setLacunarity(1.0).setPersistence(0.2).getRegion(null, x, z, xSize, zSize, 0.2, 0.2);
        double[] poolUnderArray = this.poolNoiseUnder.setLacunarity(0.01).setPersistence(1.0).getRegion(null, x, z, xSize, zSize, 0.2, 0.2);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 2048.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 2000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * 7.0 / 16.0;
                double offsetY = 3.5 + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityMod;
                    double densityOffset = ((double)dy - offsetY) * 512.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy > ySize - 12) {
                        densityMod = (float)(dy - (ySize - 12)) / 11.0f;
                        density = density * (1.0 - densityMod) + 8000.0 * densityMod;
                    }
                    if (dy < 5) {
                        densityMod = (1.0f - (float)(4 - dy)) / 4.0f;
                        float val = (float)poolOverArray[dx * zSize + dz];
                        float mod = (float)poolUnderArray[dx * zSize + dz];
                        val = val < -20.0f - 20.0f * mod ? (val *= 80.0f) : (val > 20.0f + 20.0f * mod ? -val * 80.0f : 0.0f);
                        density = density * (1.0 - densityMod) + (double)val * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private double[] generateDensityMapBiomeVolcanicIslands(Chunk chunk, int terrainHeight, int xSize, int ySize, int zSize, int x, int y, int z) {
        double[] densityMapArray = new double[xSize * ySize * zSize];
        double mainNoiseScaleX = 80.0;
        double mainNoiseScaleY = 160.0;
        double mainNoiseScaleZ = 80.0;
        double scaleNoiseScaleX = 573.952;
        double scaleNoiseScaleZ = 573.952;
        double depthNoiseScaleX = 200.0;
        double depthNoiseScaleZ = 200.0;
        double depthBaseSize = 3.5;
        double coordScale = 6844.412;
        double heightScale = 684.412;
        double heightStretch = 64.0;
        double upperLimitScale = 512.0;
        double lowerLimitScale = 512.0;
        double[] scaleArray = this.scaleNoise.getRegion(null, x, z, xSize, zSize, 573.952, 573.952);
        double[] depthArray = this.depthNoise.getRegion(null, x, z, xSize, zSize, 200.0, 200.0);
        double[] mainNoiseArray = this.mainNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 85.55515, 4.277575000000001, 85.55515);
        double[] minLimitArray = this.minLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 6844.412, 684.412, 6844.412);
        double[] maxLimitArray = this.maxLimitNoise.getRegion(null, x, y, z, xSize, ySize, zSize, 6844.412, 684.412, 6844.412);
        int mainIndex = 0;
        int depthScaleIndex = 0;
        for (int dx = 0; dx < xSize; ++dx) {
            for (int dz = 0; dz < zSize; ++dz) {
                double depth;
                double scale = (scaleArray[depthScaleIndex] + 256.0) / 2048.0;
                if (scale > 1.0) {
                    scale = 1.0;
                }
                if ((depth = depthArray[depthScaleIndex] / 2000.0) < 0.0) {
                    depth = -depth * 0.3;
                }
                if ((depth = depth * 3.0 - 2.0) < 0.0) {
                    if ((depth /= 2.0) < -1.0) {
                        depth = -1.0;
                    }
                    depth /= 1.4;
                    depth /= 2.0;
                    scale = 0.0;
                } else {
                    if (depth > 1.0) {
                        depth = 1.0;
                    }
                    depth /= 8.0;
                }
                if (scale < 0.0) {
                    scale = 0.0;
                }
                scale += 0.5;
                depth = depth * 7.0 / 16.0;
                double offsetY = 3.5 + depth * 4.0;
                ++depthScaleIndex;
                for (int dy = 0; dy < ySize; ++dy) {
                    double densityMod;
                    double densityOffset = ((double)dy - offsetY) * 64.0 / scale;
                    if (densityOffset < 0.0) {
                        densityOffset *= 4.0;
                    }
                    double minDensity = minLimitArray[mainIndex] / 512.0;
                    double maxDensity = maxLimitArray[mainIndex] / 512.0;
                    double mainDensity = (mainNoiseArray[mainIndex] / 10.0 + 1.0) / 2.0;
                    double density = mainDensity < 0.0 ? minDensity : (mainDensity > 1.0 ? maxDensity : minDensity + (maxDensity - minDensity) * mainDensity);
                    density -= densityOffset;
                    if (dy < 4) {
                        densityMod = (1.0f - (float)(3 - dy)) / 3.0f;
                        density = density * (1.0 - densityMod) + scaleArray[dx * zSize + dz] * densityMod;
                    }
                    if (dy > ySize - 8) {
                        densityMod = (float)(dy - (ySize - 8)) / 7.0f;
                        density = density * (1.0 - densityMod) + 8000.0 * densityMod;
                    }
                    densityMapArray[mainIndex] = density;
                    ++mainIndex;
                }
            }
        }
        return densityMapArray;
    }

    private static interface BiomeDensityGenerator {
        public double[] generateDensityMap(Chunk var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

