/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings;

import net.minecraft.core.world.settings.SettingNode;
import net.minecraft.core.world.settings.SettingNodeChildrenProvider;
import net.minecraft.core.world.settings.SettingNodeVisibilityListener;
import net.minecraft.core.world.settings.WorldConfiguration;
import org.jetbrains.annotations.NotNull;

public class ContainerSettingNode
implements SettingNode {
    @NotNull
    private final SettingNodeChildrenProvider childrenProvider;
    @NotNull
    private SettingNodeVisibilityListener visibilityListener = SettingNodeVisibilityListener::alwaysVisible;

    public ContainerSettingNode(@NotNull SettingNodeChildrenProvider childrenProvider) {
        this.childrenProvider = childrenProvider;
    }

    @NotNull
    public final ContainerSettingNode withVisibilityListener(@NotNull SettingNodeVisibilityListener visibilityListener) {
        this.visibilityListener = visibilityListener;
        return this;
    }

    @Override
    @NotNull
    public SettingNodeChildrenProvider getChildrenProvider() {
        return this.childrenProvider;
    }

    @Override
    public boolean isVisible(@NotNull WorldConfiguration worldConfiguration) {
        return this.visibilityListener.isVisible(worldConfiguration);
    }

    @Override
    public boolean areChildrenVisible(@NotNull WorldConfiguration worldConfiguration) {
        return this.visibilityListener.isVisible(worldConfiguration);
    }
}

