/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type.overworld;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.indev.ChunkGeneratorIndev;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldTheme;
import net.minecraft.core.world.generate.chunk.indev.IndevWorldType;
import net.minecraft.core.world.generate.chunk.indev.LevelGenerator;
import net.minecraft.core.world.type.WorldType;
import net.minecraft.core.world.type.overworld.WorldTypeOverworld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldTypeOverworldIndev
extends WorldTypeOverworld {
    public WorldTypeOverworldIndev(WorldType.Properties properties) {
        super(properties);
    }

    @Override
    public boolean isValidSpawn(World world, int x, int y, int z) {
        return world.getBlockId(x, y, z) == Blocks.GRASS.id() || world.getBlockId(x, y, z) == Blocks.SAND.id() || world.getBlockId(x, y, z) == Blocks.GRASS_RETRO.id();
    }

    @Override
    public void getInitialSpawnLocation(World world, @Nullable Biome startingBiome) {
        int y;
        int z;
        int x;
        Random random = new Random(world.getRandomSeed());
        block0: while (true) {
            x = random.nextInt(256);
            z = random.nextInt(256);
            y = this.getMaxY();
            while (true) {
                if (y < this.getMinY()) continue block0;
                if (world.getBlockId(x, y + 1, z) == 0 && this.isValidSpawn(world, x, y, z)) break block0;
                --y;
            }
            break;
        }
        world.getLevelData().getSpawnPos().set(x, y, z);
        LevelGenerator.generateHouse(world);
    }

    @Override
    public void getRespawnLocation(World world) {
    }

    @Override
    @NotNull
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_RETRO, 1.0, 1.0, 1.0);
    }

    @Override
    @NotNull
    public @NotNull Biome @NotNull [] allBiomes() {
        return new Biome[]{Biomes.OVERWORLD_RETRO};
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorIndev(world, 256, this.getMaxY() + 1, 256, IndevWorldType.ISLAND, IndevWorldTheme.NORMAL);
    }
}

