/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicLadder;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPaintable;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.PlacementMode;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.tag.ItemTags;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicTrapDoor
extends BlockLogic
implements IPaintable {
    public static final int DIRECTION_SOUTH = 0;
    public static final int DIRECTION_NORTH = 1;
    public static final int DIRECTION_EAST = 2;
    public static final int DIRECTION_WEST = 3;
    public static final int MASK_DIRECTION = 3;
    public static final int MASK_OPEN = 4;
    public static final int MASK_UPPER_HALF = 8;

    public BlockLogicTrapDoor(@NotNull Block<?> block, @NotNull Material material) {
        super(block, material);
        float f = 0.5f;
        float f1 = 1.0f;
        this.setBlockBounds(0.5f - f, 0.0, 0.5f - f, 0.5f + f, f1, 0.5f + f);
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        boolean isPowered;
        int meta = world.getBlockData(tilePos);
        boolean isOpened = BlockLogicTrapDoor.isTrapdoorOpen(meta);
        if (isOpened != (isPowered = world.hasNeighborSignal(tilePos))) {
            world.setBlockDataNotify(tilePos, BlockLogicTrapDoor.setTrapdoorOpen(meta, isPowered));
        }
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        if (BlockLogicTrapDoor.isTrapdoorOpen(meta)) {
            return switch (meta & 3) {
                case 0 -> {
                    if (side == Side.SOUTH) {
                        yield FullSupport.INSTANCE;
                    }
                    yield PartialSupport.INSTANCE;
                }
                case 1 -> {
                    if (side == Side.NORTH) {
                        yield FullSupport.INSTANCE;
                    }
                    yield PartialSupport.INSTANCE;
                }
                case 2 -> {
                    if (side == Side.EAST) {
                        yield FullSupport.INSTANCE;
                    }
                    yield PartialSupport.INSTANCE;
                }
                default -> side == Side.WEST ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
            };
        }
        if (BlockLogicTrapDoor.isUpperHalf(meta)) {
            return side == Side.TOP ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
        }
        return side == Side.BOTTOM ? FullSupport.INSTANCE : PartialSupport.INSTANCE;
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int meta = source.getBlockData(tilePos);
        float thickness = 0.1875f;
        if (BlockLogicTrapDoor.isTrapdoorOpen(meta)) {
            return switch (meta & 3) {
                case 0 -> new AABBd(0.0, 0.0, 1.0f - thickness, 1.0, 1.0, 1.0);
                case 1 -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, thickness);
                case 2 -> new AABBd(1.0f - thickness, 0.0, 0.0, 1.0, 1.0, 1.0);
                default -> new AABBd(0.0, 0.0, 0.0, thickness, 1.0, 1.0);
            };
        }
        if (BlockLogicTrapDoor.isUpperHalf(meta)) {
            return new AABBd(0.0, 1.0f - thickness, 0.0, 1.0, 1.0, 1.0);
        }
        return new AABBd(0.0, 0.0, 0.0, 1.0, thickness, 1.0);
    }

    @Override
    public void onAttacked(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @NotNull Side side, double xHit, double yHit) {
        if (!Item.hasTag(player.getCurrentEquippedItem(), ItemTags.PREVENT_LEFT_CLICK_INTERACTIONS)) {
            this.onInteracted(world, tilePos, player, null, 0.0, 0.0);
        }
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        if (this.material != Materials.METAL && this.material != Materials.STEEL) {
            int data = world.getBlockData(tilePos);
            world.setBlockDataNotify(tilePos, data ^ 4);
            world.playBlockEvent(player, tilePos, 1003, 0);
            return true;
        }
        return false;
    }

    @Override
    public void onActivatorInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull TileEntityActivator activator, @NotNull Direction direction) {
        if (this.material != Materials.METAL && this.material != Materials.STEEL) {
            int data = world.getBlockData(tilePos);
            world.setBlockDataNotify(tilePos, data ^ 4);
            world.playBlockEvent(null, tilePos, 1003, 0);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        boolean isPowered;
        int meta;
        boolean isOpened;
        if (world.isClientSide) {
            return;
        }
        if ((this.material != Materials.METAL && this.material != Materials.STEEL && block.isSignalSource() || (this.material == Materials.METAL || this.material == Materials.STEEL) && block.isSignalSource()) && (isOpened = BlockLogicTrapDoor.isTrapdoorOpen(meta = world.getBlockData(tilePos))) != (isPowered = world.hasNeighborSignal(tilePos))) {
            world.setBlockDataNotify(tilePos, BlockLogicTrapDoor.setTrapdoorOpen(meta, isPowered));
            world.playBlockEvent(null, tilePos, 1003, 0);
        }
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        int meta = this.getMetaForDirection(player == null ? side.getDirection().getOpposite() : player.getHorizontalPlacementDirection(side, PlacementMode.SIDE));
        if (player != null && player.getVerticalPlacementDirection(side, yHit) == Direction.UP) {
            meta = BlockLogicTrapDoor.setUpperHalf(meta, true);
        }
        return meta;
    }

    @Override
    public boolean isClimbable(@NotNull World world, @NotNull TilePosc tilePos) {
        Object obj;
        TilePos queryPos = new TilePos();
        Block<?> block = world.getBlockType(tilePos.down(queryPos));
        int meta = world.getBlockData(tilePos);
        if (BlockLogicTrapDoor.isTrapdoorOpen(meta) && block != null && (obj = block.getLogic()) instanceof BlockLogicLadder) {
            BlockLogicLadder ladder = (BlockLogicLadder)obj;
            Side ladderSide = ladder.getSideFromMeta(world.getBlockData(tilePos.down(queryPos)));
            Direction trapdoorDirection = this.getDirectionForMeta(meta);
            return ladderSide.getDirection() == trapdoorDirection.getOpposite();
        }
        return false;
    }

    public static boolean isTrapdoorOpen(int metadata) {
        return (metadata & 4) != 0;
    }

    public static int setTrapdoorOpen(int metadata, boolean isOpen) {
        metadata = isOpen ? (metadata |= 4) : (metadata &= 0xFFFFFFFB);
        return metadata;
    }

    public static boolean isUpperHalf(int meta) {
        return (meta & 8) != 0;
    }

    public static int setUpperHalf(int meta, boolean isUpperHalf) {
        meta = isUpperHalf ? (meta |= 8) : (meta &= 0xFFFFFFF7);
        return meta;
    }

    public int getMetaForDirection(Direction dir) {
        return switch (dir) {
            case Direction.SOUTH -> 0;
            case Direction.NORTH -> 1;
            case Direction.EAST -> 2;
            case Direction.WEST -> 3;
            default -> 0;
        };
    }

    public Direction getDirectionForMeta(int meta) {
        return switch (meta & 3) {
            case 0 -> Direction.SOUTH;
            case 1 -> Direction.NORTH;
            case 2 -> Direction.EAST;
            case 3 -> Direction.WEST;
            default -> Direction.NONE;
        };
    }

    @Override
    public boolean canBePainted() {
        return this.material == Materials.WOOD;
    }

    @Override
    public void setColor(World world, @NotNull TilePosc tilePos, DyeColor color) {
        int meta = world.getBlockData(tilePos);
        world.setBlockTypeDataNotify(tilePos, Blocks.TRAPDOOR_PLANKS_PAINTED, meta & 0xF | color.blockMeta << 4);
    }
}

