/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block.piston;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.piston.BlockLogicPistonHead;
import net.minecraft.core.block.piston.BlockLogicPistonMoving;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.block.support.FullSupport;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;
import org.joml.primitives.AABBdc;

public class BlockLogicPistonBase
extends BlockLogic {
    public static final int MASK_DIRECTION = 7;
    public static final int MASK_POWERED = 8;
    public static final int EVENT_EXTEND = 0;
    public static final int EVENT_RETRACT = 1;
    public static final ISupport[] pistonSupportLookupTable = new ISupport[]{PartialSupport.INSTANCE, FullSupport.INSTANCE, PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().down(), PartialSupport.INSTANCE.center().right(), PartialSupport.INSTANCE.center().left(), FullSupport.INSTANCE, PartialSupport.INSTANCE, PartialSupport.INSTANCE.center().down(), PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().right(), PartialSupport.INSTANCE.center().left(), PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().down(), PartialSupport.INSTANCE, FullSupport.INSTANCE, PartialSupport.INSTANCE.center().right(), PartialSupport.INSTANCE.center().left(), PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().down(), FullSupport.INSTANCE, PartialSupport.INSTANCE, PartialSupport.INSTANCE.center().right(), PartialSupport.INSTANCE.center().left(), PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().down(), PartialSupport.INSTANCE.center().left(), PartialSupport.INSTANCE.center().right(), PartialSupport.INSTANCE, FullSupport.INSTANCE, PartialSupport.INSTANCE.center().up(), PartialSupport.INSTANCE.center().down(), PartialSupport.INSTANCE.center().left(), PartialSupport.INSTANCE.center().right(), FullSupport.INSTANCE, PartialSupport.INSTANCE};
    private final int maxPushedBlocks;

    public BlockLogicPistonBase(@NotNull Block<?> block, int maxPushedBlocks) {
        super(block, Materials.PISTON);
        this.maxPushedBlocks = maxPushedBlocks;
        block.withHardness(0.5f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public void onPlacedByMob(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, @NotNull Mob mob, double xHit, double yHit) {
        Direction placementDirection = mob.getPlacementDirection(side).getOpposite();
        world.setBlockDataNotify(tilePos, placementDirection.getId());
        if (!world.isClientSide) {
            this.checkIfExtend(world, tilePos);
        }
    }

    @Override
    public void onPlacedOnSide(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        Direction placementDirection = side.getDirection();
        world.setBlockDataNotify(tilePos, placementDirection.getId());
        if (!world.isClientSide) {
            this.checkIfExtend(world, tilePos);
        }
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        this.checkIfExtend(world, tilePos);
    }

    @Override
    public void onPlacedByWorld(@NotNull World world, @NotNull TilePosc tilePos) {
        if (!world.isClientSide && world.getTileEntity(tilePos) == null) {
            this.checkIfExtend(world, tilePos);
        }
    }

    private void checkIfExtend(@NotNull World world, @NotNull TilePosc tilePos) {
        int data = world.getBlockData(tilePos);
        Direction direction = BlockLogicPistonBase.getDirection(data);
        boolean hasNeighborSignal = this.getNeighborSignal(world, tilePos, direction);
        if (data == 7) {
            return;
        }
        if (hasNeighborSignal && !BlockLogicPistonBase.isPowered(data)) {
            if (this.canPushLine(world, tilePos, direction, this.maxPushedBlocks)) {
                world.setBlockData(tilePos, direction.getId() | 8);
                world.triggerEvent(tilePos, 0, direction.getId());
            }
        } else if (!hasNeighborSignal && BlockLogicPistonBase.isPowered(data)) {
            world.setBlockData(tilePos, direction.getId());
            world.triggerEvent(tilePos, 1, direction.getId());
        }
    }

    private boolean getNeighborSignal(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction) {
        TilePos queryPos = new TilePos();
        if (direction != Direction.DOWN && world.hasSignal(tilePos.add(0, -1, 0, queryPos), Side.BOTTOM)) {
            return true;
        }
        if (direction != Direction.UP && world.hasSignal(tilePos.add(0, 1, 0, queryPos), Side.TOP)) {
            return true;
        }
        if (direction != Direction.NORTH && world.hasSignal(tilePos.add(0, 0, -1, queryPos), Side.NORTH)) {
            return true;
        }
        if (direction != Direction.SOUTH && world.hasSignal(tilePos.add(0, 0, 1, queryPos), Side.SOUTH)) {
            return true;
        }
        if (direction != Direction.EAST && world.hasSignal(tilePos.add(1, 0, 0, queryPos), Side.EAST)) {
            return true;
        }
        if (direction != Direction.WEST && world.hasSignal(tilePos.add(-1, 0, 0, queryPos), Side.WEST)) {
            return true;
        }
        if (world.hasSignal(tilePos, Side.BOTTOM)) {
            return true;
        }
        if (direction != Direction.UP && world.hasSignal(tilePos.add(0, 2, 0, queryPos), Side.TOP)) {
            return true;
        }
        if (world.hasSignal(tilePos.add(0, 1, -1, queryPos), Side.NORTH)) {
            return true;
        }
        if (world.hasSignal(tilePos.add(0, 1, 1, queryPos), Side.SOUTH)) {
            return true;
        }
        if (world.hasSignal(tilePos.add(-1, 1, 0, queryPos), Side.WEST)) {
            return true;
        }
        return world.hasSignal(tilePos.add(1, 1, 0, queryPos), Side.EAST);
    }

    @Override
    public void triggerEvent(@NotNull World world, @NotNull TilePosc tilePos, int index, int data) {
        Direction direction = BlockLogicPistonBase.getDirection(data);
        if (direction == Direction.NONE) {
            return;
        }
        if (index == 0) {
            this.extendEvent(world, tilePos, data, direction);
        } else if (index == 1) {
            this.retractEvent(world, tilePos, data, direction);
        }
    }

    public void extendEvent(@NotNull World world, @NotNull TilePosc tilePos, int data, @NotNull Direction direction) {
        if (this.tryExtend(world, tilePos, direction, this.maxPushedBlocks)) {
            world.setBlockDataNotify(tilePos, direction.getId() | 8);
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "tile.piston.out", 0.5f, world.rand.nextFloat() * 0.25f + 0.6f);
        }
    }

    public void retractEvent(@NotNull World world, @NotNull TilePosc tilePos, int data, @NotNull Direction direction) {
        TilePos shiftedPos = tilePos.add(direction, new TilePos());
        TileEntity tileEntity = world.getTileEntity(shiftedPos);
        if (tileEntity instanceof TileEntityMovingPistonBlock) {
            TileEntityMovingPistonBlock moving = (TileEntityMovingPistonBlock)tileEntity;
            if (!moving.isExtending()) {
                moving.finalTick();
            } else {
                world.setBlockType(shiftedPos, Blocks.AIR);
            }
        }
        world.setBlockTypeData(tilePos, Blocks.PISTON_MOVING, direction.getId());
        world.replaceTileEntity(tilePos, BlockLogicPistonMoving.createTileEntity(this.block, direction.getId(), null, direction, false, true));
        world.setBlockTypeNotify(shiftedPos, Blocks.AIR);
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)tilePos.x() + 0.5, (double)tilePos.y() + 0.5, (double)tilePos.z() + 0.5, "tile.piston.in", 0.5f, world.rand.nextFloat() * 0.15f + 0.6f);
    }

    @Override
    @NotNull
    public AABBdc getBoundsFromState(@NotNull WorldSource source, @NotNull TilePosc tilePos) {
        int data = source.getBlockData(tilePos);
        if (BlockLogicPistonBase.isPowered(data)) {
            return switch (BlockLogicPistonBase.getDirection(data)) {
                case Direction.DOWN -> new AABBd(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
                case Direction.UP -> new AABBd(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
                case Direction.NORTH -> new AABBd(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
                case Direction.SOUTH -> new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
                case Direction.WEST -> new AABBd(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
                default -> new AABBd(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
            };
        }
        return new AABBd(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        int meta = world.getBlockData(tilePos);
        if ((meta & 8) == 0) {
            return FullSupport.INSTANCE;
        }
        Direction dir = BlockLogicPistonBase.getDirection(meta);
        return pistonSupportLookupTable[side.getId() * 6 + dir.getId()];
    }

    public static Direction getDirection(int data) {
        return Direction.getDirectionById(data & 7);
    }

    public static boolean isPowered(int data) {
        return (data & 8) != 0;
    }

    protected boolean isPushable(@NotNull Block<?> block, @NotNull World world, @NotNull TilePos tilePos, boolean canDestroy) {
        int pushReaction = block.getPistonPushReaction(world, tilePos);
        return !block.hasTag(BlockTags.PISTON_CRUSHING) && !block.getImmovable() && pushReaction != 2 && (canDestroy || pushReaction != 1) && block.getHardness() != -1.0f;
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        if (BlockLogicPistonBase.isPowered(world.getBlockData(tilePos))) {
            return 2;
        }
        return super.getPistonPushReaction(world, tilePos);
    }

    protected boolean canPushLine(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction, int maxPushedBlocks) {
        TilePos posO = tilePos.add(direction, new TilePos());
        for (int blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
            if (posO.y < 0 || posO.y >= world.getHeightBlocks()) {
                return false;
            }
            @NotNull Block<?> block = world.getBlockType(posO);
            if (block == Blocks.AIR) break;
            if (!this.isPushable(block, world, posO, true)) {
                if (blocks == 1 && block.hasTag(BlockTags.PISTON_CRUSHING) && this.tryCrush(world, tilePos, direction)) break;
                return false;
            }
            if (block.getPistonPushReaction(world, posO) == 1) break;
            if (blocks == maxPushedBlocks) {
                return false;
            }
            posO.x += direction.getOffsetX();
            posO.y += direction.getOffsetY();
            posO.z += direction.getOffsetZ();
        }
        return true;
    }

    public boolean tryCrush(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction) {
        TilePos pos2 = tilePos.add(direction, new TilePos());
        Block<?> block = world.getBlockType(pos2);
        world.playBlockEvent(null, pos2, 2001, world.getBlockType(pos2).id());
        block.dropWithCause(world, EnumDropCause.SILK_TOUCH, pos2, world.getBlockData(pos2), null, null);
        world.setBlockTypeNotify(pos2, Blocks.AIR);
        return true;
    }

    protected boolean tryExtend(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Direction direction, int maxPushedBlocks) {
        int data = world.getBlockData(tilePos);
        TilePos posO = tilePos.add(direction, new TilePos());
        for (int blocks = 0; blocks < maxPushedBlocks + 1; ++blocks) {
            if (posO.y < 0 || posO.y >= world.getHeightBlocks()) {
                return false;
            }
            @NotNull Block<?> block = world.getBlockType(posO);
            if (block == Blocks.AIR) break;
            if (!this.isPushable(block, world, posO, true)) {
                return false;
            }
            if (block.getPistonPushReaction(world, posO) == 1) {
                block.dropWithCause(world, EnumDropCause.WORLD, posO, world.getBlockData(posO), world.getTileEntity(posO), null);
                break;
            }
            if (blocks == maxPushedBlocks) {
                return false;
            }
            posO.x += direction.getOffsetX();
            posO.y += direction.getOffsetY();
            posO.z += direction.getOffsetZ();
        }
        TilePos posP = new TilePos(posO);
        while (!posO.equals(tilePos)) {
            posP.set(posO.x - direction.getOffsetX(), posO.y - direction.getOffsetY(), posO.z - direction.getOffsetZ());
            @NotNull Block<?> pushBlock = world.getBlockType(posP);
            int pushMeta = world.getBlockData(posP);
            TileEntity pushEntity = world.getTileEntity(posP);
            if (pushEntity instanceof TileEntityMovingPistonBlock && posP.equals(tilePos)) break;
            if (pushBlock == this.block && posP.equals(tilePos)) {
                this.createPistonHeadAt(world, posO, data, direction);
            } else if (pushBlock == Blocks.PISTON_MOVING) {
                TileEntityMovingPistonBlock moving;
                TileEntity old = world.getTileEntity(posP);
                if (old instanceof TileEntityMovingPistonBlock && !(moving = (TileEntityMovingPistonBlock)old).isSourcePiston()) {
                    pushBlock = moving.getMovedBlock();
                    pushMeta = moving.getMovedData();
                    pushEntity = moving.getMovedEntity();
                }
                world.removeTileEntity(posP);
                world.setBlockTypeData(posO, Blocks.PISTON_MOVING, pushMeta);
                world.replaceTileEntity(posO, BlockLogicPistonMoving.createTileEntity(pushBlock, pushMeta, pushEntity, direction, true, false));
            } else {
                world.removeTileEntity(posP);
                world.setBlockTypeData(posO, Blocks.PISTON_MOVING, pushMeta);
                world.replaceTileEntity(posO, BlockLogicPistonMoving.createTileEntity(pushBlock, pushMeta, pushEntity, direction, true, false));
            }
            if (!posP.equals(tilePos)) {
                world.setBlockTypeRaw(posP, Blocks.AIR);
            }
            posO.set(posP.x, posP.y, posP.z);
        }
        return true;
    }

    public void createPistonHeadAt(@NotNull World world, @NotNull TilePos tilePos, int data, @NotNull Direction direction) {
        world.setBlockTypeData(tilePos, Blocks.PISTON_MOVING, BlockLogicPistonHead.setPistonType(0, direction.getId()));
        world.replaceTileEntity(tilePos, BlockLogicPistonMoving.createTileEntity(Blocks.PISTON_HEAD, BlockLogicPistonHead.setPistonType(0, direction.getId()), null, direction, true, false));
    }

    @Override
    public int getPlacedData(@Nullable Player player, @NotNull ItemStack itemStack, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side, double xHit, double yHit) {
        return 7;
    }
}

