/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.tags.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Global;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.MobFlying;
import net.minecraft.core.entity.SkinVariantList;
import net.minecraft.core.entity.animal.AmbientCreature;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.primitives.AABBd;

public class MobButterfly
extends MobFlying
implements AmbientCreature {
    public static final Int2ObjectMap<ButterflyEntry> colorEntries = new Int2ObjectArrayMap<ButterflyEntry>();
    public static final int DATA_COLOR_ID = 16;
    public static final ButterflyEntry COLOR_BLUE = MobButterfly.addEntry(0, "blue", 1.0, () -> Items.JAR_BUTTERFLY_BLUE, new Biome[0]);
    public static final ButterflyEntry COLOR_ORANGE = MobButterfly.addEntry(1, "orange", 1.0, () -> Items.JAR_BUTTERFLY_ORANGE, new Biome[0]);
    public static final ButterflyEntry COLOR_PINK = MobButterfly.addEntry(2, "pink", 1.0, () -> Items.JAR_BUTTERFLY_PINK, new Biome[0]);
    public static final ButterflyEntry COLOR_SILVER = MobButterfly.addEntry(3, "silver", 1.0, () -> Items.JAR_BUTTERFLY_SILVER, new Biome[0]);
    public int courseChangeCooldown = 0;
    public double waypointX = 0.0;
    public double waypointY = 0.0;
    public double waypointZ = 0.0;

    public static ButterflyEntry addEntry(int id, String name, double weight, Supplier<Item> jarItem, Biome ... allowedBiomes) {
        assert (id >= 0 && id <= 255) : "ID is outside valid range!";
        ButterflyEntry entry = new ButterflyEntry(id, name, weight, jarItem, allowedBiomes);
        colorEntries.put(id, entry);
        return entry;
    }

    public MobButterfly(World world) {
        super(world);
        this.setTextureIdentifier("minecraft", "butterfly");
        this.setSize(0.5f, 0.5f);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(16, (byte)0, Byte.class);
    }

    @Override
    protected boolean makeStepSound() {
        return false;
    }

    @Override
    public boolean isPickable() {
        return false;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public String getLivingSound() {
        return "";
    }

    @Override
    protected String getHurtSound() {
        return "";
    }

    @Override
    protected String getDeathSound() {
        return "";
    }

    @Override
    public boolean canRide() {
        return false;
    }

    @Override
    public void push(Entity entity) {
    }

    @Override
    public boolean hurt(Entity attacker, int i, DamageType type) {
        if (type == null || type == DamageType.GENERIC || type == DamageType.BLAST || type == DamageType.FIRE || type == DamageType.DROWN) {
            return super.hurt(attacker, i, type);
        }
        return false;
    }

    @Override
    public void spawnInit() {
        super.spawnInit();
        Biome currentBiome = this.world.getBlockBiome(MathHelper.floor(this.x), MathHelper.floor(this.y), MathHelper.floor(this.z));
        WeightedRandomBag<ButterflyEntry> colorBag = new WeightedRandomBag<ButterflyEntry>();
        for (ButterflyEntry entry : colorEntries.values()) {
            if (!entry.isBiomeAllowed(currentBiome)) continue;
            colorBag.addEntry(entry, entry.weight);
        }
        ButterflyEntry entry = (ButterflyEntry)colorBag.getRandom();
        if (entry == null) {
            entry = COLOR_BLUE;
        }
        this.setColor(entry.id);
    }

    @Override
    public boolean canSpawnHere() {
        int z;
        int y;
        if (!this.world.isDaytime()) {
            return false;
        }
        int x = MathHelper.floor(this.x);
        int id = this.world.getBlockId(x, (y = MathHelper.floor(this.bb.minY)) - 1, z = MathHelper.floor(this.z));
        if (Blocks.blocksList[id] != null) {
            return Blocks.blocksList[id].hasTag(BlockTags.PASSIVE_MOBS_SPAWN) && this.world.getFullBlockLightValue(x, y, z) > 8 && super.canSpawnHere();
        }
        return false;
    }

    private boolean isCourseTraversable(double waypointX, double waypointY, double waypointZ, double distanceFromEntity) {
        double dx = (waypointX - this.x) / distanceFromEntity;
        double dy = (waypointY - this.y) / distanceFromEntity;
        double dz = (waypointZ - this.z) / distanceFromEntity;
        AABBd entityBB = new AABBd(this.bb);
        int i = 0;
        while ((double)i < distanceFromEntity) {
            entityBB.translate(dx, dy, dz);
            if (!this.world.getCubes(this, entityBB).isEmpty()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void updateAI() {
        double distanceZ;
        double distanceY;
        double distanceFromEntity;
        double distanceX;
        ++this.entityAge;
        this.tryToDespawn();
        Player closestPlayer = this.world.getClosestPlayerToEntity(this, 2.0);
        if (closestPlayer != null) {
            distanceX = closestPlayer.x - this.x;
            double distanceZ2 = closestPlayer.z - this.z;
            double distance = Math.hypot(distanceX, distanceZ2);
            this.waypointX = this.x + distanceX / distance * -5.0;
            this.waypointY = this.y + 4.0;
            this.waypointZ = this.z + distanceZ2 / distance * -5.0;
        }
        if ((distanceFromEntity = (double)MathHelper.sqrt((distanceX = this.waypointX - this.x) * distanceX + (distanceY = this.waypointY - this.y) * distanceY + (distanceZ = this.waypointZ - this.z) * distanceZ)) > 32.0) {
            this.waypointX = this.x;
            this.waypointY = this.y;
            this.waypointZ = this.z;
            return;
        }
        if (distanceFromEntity > 1.0) {
            this.xd += distanceX / distanceFromEntity * 0.01;
            this.yd += distanceY / distanceFromEntity * 0.01;
            this.zd += distanceZ / distanceFromEntity * 0.01;
            this.yRot = (float)(Math.atan2(this.xd, this.zd) * 180.0 / 3.1415927410125732);
        }
        if (this.courseChangeCooldown-- <= 0) {
            this.courseChangeCooldown += this.random.nextInt(40) + 20;
            if (!(distanceFromEntity > 1.0) || !this.isCourseTraversable(this.waypointX, this.waypointY, this.waypointZ, distanceFromEntity)) {
                double nextX = this.x + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                double nextY = this.y + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 5.0f);
                double nextZ = this.z + (double)((this.random.nextFloat() * 2.0f - 1.0f) * 16.0f);
                if (nextY > this.y) {
                    if (this.isUpwardWaypointValid(MathHelper.floor(nextX), MathHelper.floor(nextY), MathHelper.floor(nextZ))) {
                        this.waypointX = nextX;
                        this.waypointY = nextY;
                        this.waypointZ = nextZ;
                    } else {
                        this.waypointX = this.x;
                        this.waypointY = this.y;
                        this.waypointZ = this.z;
                    }
                } else {
                    this.waypointX = nextX;
                    this.waypointY = nextY;
                    this.waypointZ = nextZ;
                }
            }
        }
    }

    public boolean isUpwardWaypointValid(int x, int y, int z) {
        int range = 3;
        for (int _y = y; _y > y - 3; --_y) {
            Block<?> block = this.world.getBlock(x, _y, z);
            if (block == null) continue;
            return true;
        }
        return false;
    }

    public int getColor() {
        return this.entityData.getByte(16) & 0xFF;
    }

    public void setColor(int color) {
        assert (color >= 0 && color <= 255) : "Color is outside valid range!";
        this.entityData.set(16, (byte)color);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("Color", (byte)this.getColor());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setColor(tag.getByte("Color") & 0xFF);
    }

    @Override
    @NotNull
    public String getDefaultEntityTexture() {
        return this.getEntityTexture();
    }

    @Override
    @NotNull
    public String getEntityTexture() {
        return this.basePath + this.getTextureReference() + "_0.png";
    }

    @Override
    public String getTextureReference() {
        SkinVariantList variantList = Global.accessor.getSkinVariantList();
        return ((ButterflyEntry)MobButterfly.colorEntries.get((int)this.getColor())).name + "/" + variantList.getSkinReference(this.variantJsonPath, "0", this.getSkinVariant());
    }

    public static class ButterflyEntry {
        public final int id;
        public final String name;
        @Nullable
        private Set<Biome> allowedBiomes;
        public final Supplier<Item> jarItem;
        public final double weight;

        public ButterflyEntry(int id, String name, double weight, Supplier<Item> jarItem, Biome ... allowedBiomes) {
            this.id = id;
            this.name = name;
            this.weight = weight;
            this.jarItem = jarItem;
            if (allowedBiomes.length > 0) {
                this.allowedBiomes = new HashSet<Biome>();
                this.allowedBiomes.addAll(Arrays.asList(allowedBiomes));
            }
        }

        public ButterflyEntry addAllowedBiome(Biome biome) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new HashSet<Biome>();
            }
            this.allowedBiomes.add(biome);
            return this;
        }

        public ButterflyEntry removeAllowedBiome(Biome biome) {
            if (this.allowedBiomes == null) {
                this.allowedBiomes = new HashSet<Biome>();
            }
            this.allowedBiomes.remove(biome);
            return this;
        }

        public ButterflyEntry allowAllBiomes() {
            this.allowedBiomes = null;
            return this;
        }

        public boolean isBiomeAllowed(Biome biome) {
            return this.allowedBiomes == null || this.allowedBiomes.contains(biome);
        }
    }
}

