/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory.menu;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.inventory.container.Container;
import net.minecraft.core.player.inventory.menu.MenuAbstract;
import net.minecraft.core.player.inventory.slot.Slot;
import net.minecraft.core.player.inventory.slot.SlotDye;
import org.jetbrains.annotations.NotNull;

public class MenuFlag
extends MenuAbstract {
    private static final int NUM_DYE_SLOTS = 3;
    private static final int DYE_SLOTS_START = 0;
    private static final int INVENTORY_SLOTS_START = 3;
    private static final int HOTBAR_SLOTS_START = 30;
    public TileEntityFlag flag;

    public MenuFlag(Container inv, TileEntityFlag flag) {
        int i;
        this.flag = flag;
        for (i = 0; i < 3; ++i) {
            this.addSlot(new SlotDye(flag, i, 129, 10 + 22 * i));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot(inv, x + y * 9 + 9, 8 + x * 18, 113 + y * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot(inv, i, 8 + i * 18, 171));
        }
    }

    @Override
    public IntList getMoveSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 3) {
            return this.getSlots(0, 3, false);
        }
        if (action == InventoryAction.MOVE_SIMILAR) {
            return this.getSlots(3, 36, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.index < 30) {
                return this.getSlots(3, 27, false);
            }
            return this.getSlots(30, 9, false);
        }
        return null;
    }

    @Override
    public IntList getTargetSlots(@NotNull InventoryAction action, @NotNull Slot slot, int target, Player player) {
        if (slot.index >= 0 && slot.index < 3) {
            return this.getSlots(3, 36, false);
        }
        return this.getSlots(0, 3, false);
    }

    @Override
    public boolean stillValid(@NotNull Player player) {
        return this.flag.stillValid(player);
    }
}

