/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicAxisAligned;
import net.minecraft.core.block.BlockLogicLeavesBase;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class BlockLogicLog
extends BlockLogicAxisAligned {
    public BlockLogicLog(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        int r = 4;
        int r2 = r + 1;
        if (world.areBlocksLoaded((TilePosc)tilePos.add(-r2, -r2, -r2, new TilePos()), tilePos.add(r2, r2, r2, new TilePos()))) {
            TilePos queryPos = new TilePos();
            queryPos.x = tilePos.x() - r;
            while (queryPos.x <= tilePos.x() + r) {
                queryPos.y = tilePos.x() - r;
                while (queryPos.y <= tilePos.y() + r) {
                    queryPos.z = -tilePos.x() - r;
                    while (queryPos.z <= tilePos.z() + r) {
                        int leavesMeta;
                        Block<?> block = world.getBlockType(queryPos);
                        if (block != null && block.getLogic() instanceof BlockLogicLeavesBase && !BlockLogicLeavesBase.isPermanent(leavesMeta = world.getBlockData(queryPos))) {
                            world.setBlockData(queryPos, BlockLogicLeavesBase.setDecaying(leavesMeta, true));
                        }
                        ++queryPos.z;
                    }
                    ++queryPos.y;
                }
                ++queryPos.x;
            }
        }
    }
}

