/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.current.util;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockState {
    @NotNull
    public static final BlockState AIR = new BlockState(Blocks.AIR, 0);
    @NotNull
    private final Block<?> block;
    private final int metadata;

    public BlockState(Block<?> block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof BlockState) {
            @NotNull BlockState state = (BlockState)obj;
            return state.block == this.block && state.metadata == this.metadata;
        }
        return false;
    }

    @NotNull
    public Block<?> getBlockType() {
        return this.block;
    }

    public boolean is(@NotNull Block<?> block) {
        return this.block == block;
    }

    public int get() {
        return this.metadata;
    }

    public BlockState set(int metadata) {
        return new BlockState(this.block, metadata);
    }

    public boolean isAir() {
        return this == AIR;
    }

    public boolean isConductor() {
        return this.block.getMaterial().isSolidBlocking() && this.block.isSolidRender();
    }

    public boolean isSignalSource() {
        return this.block.isSignalSource();
    }

    public boolean hasSignal(World world, TilePosc pos, Direction dir) {
        return this.block.isEmittingSignal(world, pos, dir.getSide());
    }

    public boolean hasDirectSignal(World world, TilePosc pos, Direction dir) {
        return this.block.isEmittingDirectSignal(world, pos, dir.getSide());
    }

    public boolean canSurvive(World world, TilePosc pos) {
        Block<?> block = world.getBlockType(pos);
        if (block == Blocks.WIRE_REDSTONE) {
            return Blocks.WIRE_REDSTONE.getLogic().isSupported(world, pos, Side.BOTTOM);
        }
        Block<?> underBlock = world.getBlockType(pos.down(new TilePos()));
        return block.getMaterial().isReplaceable() && underBlock.isCubeShaped();
    }

    public void dropItems(World world, TilePos pos) {
        this.block.dropWithCause(world, EnumDropCause.WORLD, pos, 0, null, null);
    }

    public void neighborChanged(World world, TilePos pos, Block<?> neighborBlock) {
        this.block.onNeighborChanged(world, pos, neighborBlock);
    }
}

