/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicOverlayPebbles;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.MethodParametersAnnotation;
import net.minecraft.core.world.generate.feature.WorldFeature;
import net.minecraft.core.world.pos.TilePos;
import org.jetbrains.annotations.NotNull;

public class WorldFeaturePebbles
extends WorldFeature {
    @NotNull
    private final Block<? extends BlockLogicOverlayPebbles> block;
    private final int count;
    private final boolean varyStackSize;

    @MethodParametersAnnotation(names={"blockId", "count", "varyStackSize"})
    public WorldFeaturePebbles(@NotNull Block<? extends BlockLogicOverlayPebbles> block, int count, boolean varyStackSize) {
        this.block = block;
        this.count = count;
        this.varyStackSize = varyStackSize;
    }

    @Override
    public boolean place(@NotNull World world, @NotNull Random random, int x, int y, int z) {
        TilePos p = new TilePos();
        TilePos queryPos = new TilePos();
        for (int i = 0; i < this.count; ++i) {
            p.set(x + random.nextInt(8) - random.nextInt(8), y + random.nextInt(4) - random.nextInt(4), z + random.nextInt(8) - random.nextInt(8));
            if (!world.isAirBlock(p) || !BlockLogicOverlayPebbles.canSpawnOn(world.getBlockType(p.down(queryPos)))) continue;
            int stackSize = this.varyStackSize ? WorldFeaturePebbles.getStackSize(random) : 0;
            world.setBlockTypeData(p, this.block, BlockLogicOverlayPebbles.setCount(0, stackSize));
        }
        return true;
    }

    private static int getStackSize(@NotNull Random random) {
        int odds = random.nextInt(18);
        if (odds < 8) {
            return 0;
        }
        if (odds < 14) {
            return 1;
        }
        return 2;
    }
}

