/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.net.handler;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Key;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Global;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.data.registry.recipe.RecipeEntryBase;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.NetworkManager;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.PacketAESSendKey;
import net.minecraft.core.net.packet.PacketChat;
import net.minecraft.core.net.packet.PacketCommandManager;
import net.minecraft.core.net.packet.PacketDisconnect;
import net.minecraft.core.net.packet.PacketGameRule;
import net.minecraft.core.net.packet.PacketHandshake;
import net.minecraft.core.net.packet.PacketLogin;
import net.minecraft.core.net.packet.PacketPhotoMode;
import net.minecraft.core.net.packet.PacketPingHandshake;
import net.minecraft.core.net.packet.PacketPlayerGamemode;
import net.minecraft.core.net.packet.PacketRecipeSync;
import net.minecraft.core.net.packet.PacketServerIcon;
import net.minecraft.core.net.packet.PacketSetCarriedItem;
import net.minecraft.core.net.packet.PacketSetHeldObject;
import net.minecraft.core.net.packet.PacketSetHotbarOffset;
import net.minecraft.core.net.packet.PacketSetSpawnPosition;
import net.minecraft.core.net.packet.PacketSetTime;
import net.minecraft.core.net.packet.PacketSyncIDs;
import net.minecraft.core.sound.SoundTypes;
import net.minecraft.core.util.helper.AES;
import net.minecraft.core.util.helper.RSA;
import net.minecraft.core.util.helper.RestHandler;
import net.minecraft.core.util.helper.UUIDHelper;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.PlayerServer;
import net.minecraft.server.net.command.ServerCommandSource;
import net.minecraft.server.net.handler.PacketHandlerServer;
import net.minecraft.server.world.WorldServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class PacketHandlerLogin
extends PacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Random rand = new Random();
    public NetworkManager netManager;
    public boolean finishedProcessing = false;
    private final MinecraftServer mcServer;
    private int loginTimer = 0;
    private String username = null;
    private PacketLogin loginPacket = null;
    private String serverId = "";
    public static String kickMessage = null;

    public PacketHandlerLogin(MinecraftServer minecraftserver, Socket socket, String s) throws IOException {
        this.mcServer = minecraftserver;
        this.netManager = new NetworkManager(socket, s, this, 100);
        this.netManager.fakeLag = 0;
    }

    public void tryLogin() {
        if (this.loginPacket != null) {
            this.doLogin(this.loginPacket);
            this.loginPacket = null;
        }
        if (this.loginTimer++ == 30000) {
            this.kickUser("Took too long to log in");
        } else {
            this.netManager.processReadPackets();
        }
    }

    public void kickUser(String s) {
        this.kickUser(s, false);
    }

    public void kickUser(String s, boolean silent) {
        try {
            if (!silent) {
                LOGGER.info("Disconnecting {}: {}", (Object)this.getUserAndIPString(), (Object)s);
            }
            this.netManager.addToSendQueue(new PacketDisconnect(s));
            this.netManager.serverShutdown();
            this.finishedProcessing = true;
        }
        catch (Exception exception) {
            LOGGER.error("Error while kicking user '{}'!", (Object)s, (Object)exception);
        }
    }

    @Override
    public void handleHandshake(@NotNull PacketHandshake packetHandshake) {
        if (this.mcServer.onlineMode) {
            this.serverId = Long.toHexString(rand.nextLong());
            this.netManager.addToSendQueue(new PacketHandshake(this.serverId));
        } else {
            this.netManager.addToSendQueue(new PacketHandshake("-"));
        }
    }

    @Override
    public void handleLogin(@NotNull PacketLogin packetLogin) {
        this.username = packetLogin.username;
        if (packetLogin.playerEntityIdAndProtocolVersion != 65312) {
            if (packetLogin.playerEntityIdAndProtocolVersion > 65312) {
                this.kickUser("Outdated server!");
            } else {
                this.kickUser("Outdated client!");
            }
            return;
        }
        if (!this.mcServer.onlineMode) {
            this.doLogin(packetLogin);
        } else {
            new Thread(() -> {
                try {
                    String s = PacketHandlerLogin.getServerId(this);
                    URL url = new URL("http://session.minecraft.net/game/checkserver.jsp?user=" + URLEncoder.encode(packetLogin.username, "UTF-8") + "&serverId=" + URLEncoder.encode(s, "UTF-8"));
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                    String s1 = bufferedreader.readLine();
                    bufferedreader.close();
                    if (s1.equals("YES")) {
                        PacketHandlerLogin.setLoginPacket(this, packetLogin);
                    } else {
                        this.kickUser("Failed to verify username!");
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Exception while trying to verify user '{}', kicking!", (Object)this.getUserAndIPString(), (Object)exception);
                    this.kickUser("Failed to verify username! [internal error " + String.valueOf(exception) + "]");
                }
            }).start();
        }
    }

    public void doLogin(PacketLogin loginPacket) {
        PlayerServer player;
        if (this.mcServer.onlineMode) {
            UUID mojangUUID = UUIDHelper.getUUIDFromName(loginPacket.username);
            if (mojangUUID == null) {
                this.kickUser("Cannot authenticate UUID!");
                return;
            }
            if (!mojangUUID.equals(loginPacket.uuid)) {
                this.kickUser("UUID mismatch!");
                return;
            }
        }
        if ((player = this.mcServer.playerList.getPlayerForLogin(this, loginPacket.username, loginPacket.uuid)) != null) {
            this.mcServer.playerList.load(player);
            player.setWorld(this.mcServer.getDimensionWorld(player.dimension));
            LOGGER.info(this.getUserAndIPString() + " logged in with entity id " + player.id + " at (" + player.x + ", " + player.y + ", " + player.z + ")");
            WorldServer worldserver = this.mcServer.getDimensionWorld(player.dimension);
            TilePos chunkcoordinates = worldserver.getSpawnPoint();
            PacketHandlerServer packetHandler = new PacketHandlerServer(this.mcServer, this.netManager, player);
            try {
                packetHandler.sendPacket(new PacketLogin("", new UUID(0L, 0L), player.id, worldserver.getRandomSeed(), (byte)worldserver.dimension.id, (byte)Registries.WORLD_TYPES.getNumericIdOfItem(worldserver.getDimensionData().getWorldType()), NetworkManager.PACKET_DELAY, RSA.getPublicKey(RSA.RSAKeyChain.getPublic())));
                Key aesKey = AES.generateKey();
                packetHandler.sendPacket(new PacketAESSendKey(RSA.encrypt(AES.getKey(aesKey), RSA.getPublicKey(loginPacket.publicKey))));
                AES.keyChain.put(player.username, aesKey);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (RecipeEntryBase<?, ?, ?> recipe : Registries.RECIPES.getAllSerializableRecipes()) {
                player.playerNetServerHandler.sendPacket(new PacketRecipeSync(recipe, Registries.RECIPES.getAllSerializableRecipes().size()));
            }
            player.playerNetServerHandler.sendPacket(new PacketSyncIDs(0, SoundTypes.getSoundIds()));
            player.playerNetServerHandler.sendPacket(new PacketSyncIDs(1, EntityDispatcher.getInstance().getEntityIds()));
            packetHandler.sendPacket(new PacketSetSpawnPosition(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z));
            this.mcServer.playerList.setTime(player, worldserver);
            this.mcServer.playerList.sendPacketToAllPlayers(new PacketChat(String.valueOf(TextFormatting.YELLOW) + player.getDisplayName() + String.valueOf(TextFormatting.YELLOW) + " joined the game."));
            this.mcServer.playerList.updatePlayerProfile(player.username, player.nickname, player.uuid, player.score, player.chatColor, true, player.isOperator());
            if (this.mcServer.joinMessage != null && !this.mcServer.joinMessage.isEmpty()) {
                player.playerNetServerHandler.sendPacket(new PacketChat(this.mcServer.joinMessage));
            }
            this.mcServer.playerList.playerLoggedIn(player);
            packetHandler.teleportAndRotate(player.x, player.y, player.z, player.yRot, player.xRot);
            this.mcServer.networkServer.addPlayer(packetHandler);
            this.mcServer.playerList.sendPacketToAllPlayers(new PacketPlayerGamemode(player.id, player.gamemode.getId()));
            packetHandler.sendPacket(new PacketSetTime(worldserver.getWorldTime()));
            player.setupCraftingInventoryListener();
            if (MinecraftServer.statsStatus) {
                RestHandler.post("https://api.betterthanadventure.net/stats?serverToken=" + MinecraftServer.statsToken + "&count=" + this.mcServer.playerList.playerEntities.size());
            }
            player.playerNetServerHandler.sendPacket(new PacketPhotoMode(this.mcServer.disablePhotoMode));
            player.playerNetServerHandler.sendPacket(new PacketGameRule(this.mcServer.getDimensionWorld(0).getLevelData().getGameRules()));
            player.playerNetServerHandler.sendPacket(new PacketCommandManager(this.mcServer.getDimensionWorld(player.dimension).getCommandManager().getDispatcher(), new ServerCommandSource(this.mcServer, player), "", 0));
            player.playerNetServerHandler.sendPacket(new PacketSetHeldObject(player.id, player.getHeldObject()));
            player.playerNetServerHandler.sendPacket(new PacketSetHotbarOffset(player.inventory.getHotbarOffset()));
            player.playerNetServerHandler.sendPacket(new PacketSetCarriedItem(player.inventory.getCurrentSlot()));
        }
        this.finishedProcessing = true;
    }

    @Override
    public void handleErrorMessage(String message, Object[] objects) {
        LOGGER.info("{} lost connection", (Object)this.getUserAndIPString());
        LOGGER.error(message, objects);
        this.finishedProcessing = true;
    }

    @Override
    public void handlePingHandshake(@NotNull PacketPingHandshake packetPingHandshake) {
        StringBuilder msg = new StringBuilder();
        block4 : switch (packetPingHandshake.pingHostString) {
            case "MC|PingHost": {
                msg.append("\u00a71").append('\u0000').append(0).append('\u0000').append("BTA ").append(Global.VERSION).append('\u0000').append(this.mcServer.motd).append('\u0000').append(0).append('\u0000').append(0);
                break;
            }
            case "BTAPingHost": {
                switch (packetPingHandshake.payload) {
                    case 2: {
                        msg.append("\u00a71").append('\u0000').append(65312).append('\u0000').append(Global.VERSION).append('\u0000').append(this.mcServer.motd).append('\u0000').append(this.mcServer.playerList.playerEntities.size()).append('\u0000').append(this.mcServer.maxPlayers).append('\u0000').append(this.mcServer.name).append('\u0000');
                        if (!this.mcServer.broadcastPlayerList) break block4;
                        for (Player player : this.mcServer.playerList.playerEntities) {
                            msg.append(player.username).append(",");
                        }
                        break block4;
                    }
                    case 3: {
                        msg.append("\u00a71").append('\u0000').append(65312).append('\u0000').append(Global.VERSION).append('\u0000').append(this.mcServer.motd).append('\u0000').append(this.mcServer.playerList.playerEntities.size()).append('\u0000').append(this.mcServer.maxPlayers).append('\u0000').append(this.mcServer.name).append('\u0000');
                        if (this.mcServer.broadcastPlayerList) {
                            for (Player player : this.mcServer.playerList.playerEntities) {
                                msg.append(player.username).append(",");
                            }
                        }
                        if (this.mcServer.iconBytes == null) break block4;
                        this.netManager.addToSendQueue(new PacketServerIcon(this.mcServer.iconBytes));
                        break block4;
                    }
                    default: {
                        msg.append("\u00a71").append('\u0000').append(65312).append('\u0000').append(Global.VERSION).append('\u0000').append(this.mcServer.motd).append('\u0000').append(this.mcServer.playerList.playerEntities.size()).append('\u0000').append(this.mcServer.maxPlayers);
                    }
                }
            }
        }
        this.kickUser(msg.toString(), true);
    }

    @Override
    public void handleInvalidPacket(@NotNull Packet packet) {
        if (kickMessage != null) {
            this.kickUser(kickMessage);
            kickMessage = null;
        } else {
            this.kickUser("Protocol error");
        }
    }

    public String getUserAndIPString() {
        if (this.username != null) {
            return this.username + " [" + this.netManager.getRemoteAddress().toString() + "]";
        }
        return this.netManager.getRemoteAddress().toString();
    }

    @Override
    public boolean isServerHandler() {
        return true;
    }

    public static String getServerId(PacketHandlerLogin packetHandlerLogin) {
        return packetHandlerLogin.serverId;
    }

    public static PacketLogin setLoginPacket(PacketHandlerLogin packetHandlerLogin, PacketLogin loginPacket) {
        packetHandlerLogin.loginPacket = loginPacket;
        return packetHandlerLogin.loginPacket;
    }
}

