/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Objects;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.block.support.ISupport;
import net.minecraft.core.block.support.PartialSupport;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.EnumSleepStatus;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicBed
extends BlockLogic {
    public static final int MASK_IS_FOOT = 8;
    public static final int MASK_IS_OCCUPIED = 4;
    public static final int MASK_DIRECTION = 3;
    public static final int[] headOfBedMap = new int[]{3, 4, 2, 5};
    public static final int[] footToHeadMap = new int[]{2, 3, 0, 1};
    public static final int[][] bedDirection = new int[][]{{1, 0, 3, 2, 5, 4}, {1, 0, 5, 4, 2, 3}, {1, 0, 2, 3, 4, 5}, {1, 0, 4, 5, 3, 2}};
    @NotNull
    public static final @NotNull Side @NotNull [] headBlockToFootBlockMap = new Side[]{Side.SOUTH, Side.WEST, Side.NORTH, Side.EAST};

    public BlockLogicBed(@NotNull Block<?> block) {
        super(block, Materials.WOOD);
        this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);
    }

    @Override
    public boolean onInteracted(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Player player, @Nullable Side side, double xHit, double yHit) {
        TilePosc footPos;
        if (world.isClientSide) {
            return true;
        }
        int data = world.getBlockData(tilePos);
        if (!BlockLogicBed.isBlockHeadOfBed(data)) {
            dir = BlockLogicBed.getDirection(data);
            headPos = tilePos;
            footPos = tilePos.add(headBlockToFootBlockMap[dir].getDirection(), new TilePos());
        } else {
            dir = BlockLogicBed.getDirection(data);
            headPos = tilePos.sub(headBlockToFootBlockMap[dir].getDirection(), new TilePos());
            footPos = tilePos;
        }
        if (!BlockLogicBed.isBlockHeadOfBed(data)) {
            if (world.getBlockType(footPos) != this.block) {
                return true;
            }
            data = world.getBlockData(tilePos);
        }
        if (!world.getWorldType().mayRespawn()) {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
            if (world.getBlockType(footPos) == this.block) {
                world.setBlockTypeNotify(footPos, Blocks.AIR);
            }
            player.addStat(Achievements.SLEEP_NETHER, 1);
            world.createExplosion(null, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, 5.0f, true, false);
            return true;
        }
        if (BlockLogicBed.isBedOccupied(data)) {
            Player sleepingPlayer = null;
            for (Player p : world.players) {
                TilePos pos;
                if (!p.isPlayerSleeping() || !(pos = Objects.requireNonNull(p.bedTilePos)).equals(footPos)) continue;
                sleepingPlayer = p;
            }
            if (sleepingPlayer == null) {
                BlockLogicBed.setBedOccupied(world, footPos, false);
            } else {
                player.sendTranslatedChatMessage("bed.occupied");
                return true;
            }
        }
        if (player.sleepInBedAt(footPos.x(), footPos.y(), footPos.z()) == EnumSleepStatus.OK) {
            BlockLogicBed.setBedOccupied(world, footPos, true);
            return true;
        }
        return true;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    @NotNull
    public ISupport getSupport(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Side side) {
        return PartialSupport.INSTANCE;
    }

    @Override
    public void onNeighborChanged(@NotNull World world, @NotNull TilePosc tilePos, @NotNull Block<?> block) {
        this.removeOtherHalf(world, tilePos);
    }

    @Override
    public void onRemoved(@NotNull World world, @NotNull TilePosc tilePos, int data) {
        this.removeOtherHalf(world, tilePos);
    }

    protected void removeOtherHalf(@NotNull World world, @NotNull TilePosc tilePos) {
        int data = world.getBlockData(tilePos);
        int direction = BlockLogicBed.getDirection(data);
        if (BlockLogicBed.isBlockHeadOfBed(data)) {
            if (world.getBlockType(tilePos.sub(headBlockToFootBlockMap[direction].getDirection(), new TilePos())) != this.block) {
                world.setBlockTypeNotify(tilePos, Blocks.AIR);
            }
        } else if (world.getBlockType(tilePos.add(headBlockToFootBlockMap[direction].getDirection(), new TilePos())) != this.block) {
            world.setBlockTypeNotify(tilePos, Blocks.AIR);
        }
    }

    @Override
    public ItemStack[] getBreakResult(@NotNull World world, @NotNull EnumDropCause dropCause, int data, @Nullable TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Items.BED)};
    }

    @Override
    public int getPistonPushReaction(@NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    public static boolean isBlockHeadOfBed(int meta) {
        return (meta & 8) != 0;
    }

    public static boolean isBedOccupied(int meta) {
        return (meta & 4) != 0;
    }

    public static int getDirection(int meta) {
        return meta & 3;
    }

    public static void setBedOccupied(@NotNull World world, @NotNull TilePosc tilePos, boolean flag) {
        int l = world.getBlockData(tilePos);
        l = flag ? (l |= 4) : (l &= 0xFFFFFFFB);
        world.setBlockDataNotify(tilePos, l);
    }

    @Nullable
    public static TilePos getNearestEmptyTilePos(@NotNull World world, @NotNull TilePos tilePos, int attempts) {
        int data = world.getBlockData(tilePos);
        int direction = BlockLogicBed.getDirection(data);
        for (int d = 0; d <= 1; ++d) {
            @NotNull TilePos minPos = new TilePos(tilePos.x - headBlockToFootBlockMap[direction].getOffsetX() * d - 1, tilePos.y, tilePos.z - headBlockToFootBlockMap[direction].getOffsetZ() * d - 1);
            @NotNull TilePos maxPos = minPos.add(2, 0, 2, new TilePos());
            @NotNull TilePos queryPos = new TilePos();
            for (int x = minPos.x; x <= maxPos.x; ++x) {
                for (int z = minPos.z; z <= maxPos.z; ++z) {
                    if (!world.isBlockNormalCube(queryPos.set(x, minPos.y - 1, z)) || !world.isAirBlock(queryPos.set(x, minPos.y, z)) || !world.isAirBlock(queryPos.set(x, minPos.y + 1, z))) continue;
                    if (attempts > 0) {
                        --attempts;
                        continue;
                    }
                    return queryPos.set(x, minPos.y, z);
                }
            }
        }
        return null;
    }
}

