/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.enums;

import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.entity.animal.AmbientCreature;
import net.minecraft.core.entity.animal.Creature;
import net.minecraft.core.entity.animal.WaterCreature;
import net.minecraft.core.entity.monster.Enemy;
import org.jetbrains.annotations.NotNull;

public enum MobCategory {
    MONSTER(Enemy.class, 70, Materials.AIR, false),
    CREATURE(Creature.class, 15, Materials.AIR, true),
    WATER_CREATURE(WaterCreature.class, 5, Materials.WATER, true),
    AMBIENT(AmbientCreature.class, 2, Materials.AIR, true);

    @NotNull
    private final Class<?> baseClass;
    private final int maxPerChunk;
    private final Material spawnMaterial;
    private final boolean isPeaceful;

    private MobCategory(@NotNull Class<?> baseClass, int maxPerChunk, Material spawnMaterial, boolean isPeaceful) {
        this.baseClass = baseClass;
        this.maxPerChunk = maxPerChunk;
        this.spawnMaterial = spawnMaterial;
        this.isPeaceful = isPeaceful;
    }

    @NotNull
    public Class<?> getBaseClass() {
        return this.baseClass;
    }

    public int getMaxCreaturesPerChunk() {
        return this.maxPerChunk;
    }

    @NotNull
    public Material getSpawnMaterial() {
        return this.spawnMaterial;
    }

    public boolean isPeaceful() {
        return this.isPeaceful;
    }
}

