/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.feature;

import java.util.Random;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.World;
import net.minecraft.core.world.generate.feature.WorldFeature;

public class WorldFeatureCrystal
extends WorldFeature {
    final double[] RADIUS_MAP_1 = new double[]{1.5, 1.0, 0.0};

    @Override
    public boolean place(World world, Random random, int x, int y, int z) {
        int yf = y;
        int checksForGround = 0;
        boolean canGenerate = false;
        while (true) {
            int blockBelow = world.getBlockId(x, yf - 1, x);
            if (checksForGround > 64 || yf <= 0) break;
            if (Blocks.solid[blockBelow] && blockBelow == Blocks.COBBLE_NETHERRACK.id()) {
                canGenerate = true;
                break;
            }
            --yf;
            ++checksForGround;
        }
        if (canGenerate && world.isAirBlock(x, yf, z)) {
            for (int xi = x - 5; xi < x + 5; ++xi) {
                for (int zi = x - 5; zi < x + 5; ++zi) {
                    for (int yi = yf - 3; yi < yf + 3; ++yi) {
                        if (world.getBlockId(xi, yi, zi) != Blocks.COBBLE_NETHERRACK.id() || world.getBlockId(xi, yi + 1, zi) != 0 || random.nextInt(5) == 0) continue;
                        world.setBlock(xi, yi, zi, Blocks.NETHERRACK_CRYSTALLINE.id());
                    }
                }
            }
        }
        return true;
    }

    private void plotBlocks(World world, int id, int xc, int zc, int x, int y, int z) {
        int xx;
        for (xx = xc - x; xx <= xc + x; ++xx) {
            world.setBlock(xx, y, zc + z, id);
            world.setBlock(xx, y, zc - z, id);
        }
        for (xx = xc - z; xx <= xc + z; ++xx) {
            world.setBlock(xx, y, zc + x, id);
            world.setBlock(xx, y, zc - x, id);
        }
    }

    private void generateRadius(World world, int xc, int zc, double r, int y) {
        int x = 0;
        int z = (int)r;
        double d = 3.0 - 2.0 * r;
        this.plotBlocks(world, Blocks.CRYSTAL.id(), xc, zc, x, y, z);
        while (z > x) {
            d = d > 0.0 ? d + (double)(4 * (x - --z)) + 10.0 : d + (double)(4 * ++x) + 6.0;
            this.plotBlocks(world, Blocks.CRYSTAL.id(), xc, zc, x, y, z);
        }
    }

    private boolean hasSpace(World world, int xc, int y, int zc) {
        for (int xi = xc - 1; xi < xc + 1; ++xi) {
            for (int zi = zc - 1; zi < zc + 1; ++zi) {
                if (world.getBlockId(xi, y - 1, zi) == Blocks.COBBLE_NETHERRACK.id()) continue;
                return false;
            }
        }
        return true;
    }
}

