/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.pos;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.WorldSource;
import net.minecraft.core.world.pos.ChunkPosc;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector2ic;

public final class ChunkPos
implements Externalizable,
Cloneable,
ChunkPosc {
    public int x;
    public int z;

    public ChunkPos() {
        this.x = 0;
        this.z = 0;
    }

    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public ChunkPos(@NotNull TilePosc tilePos) {
        this(tilePos.x() >> 4, tilePos.z() >> 4);
    }

    public ChunkPos(@NotNull ChunkPosc chunkPos) {
        this(chunkPos.x(), chunkPos.z());
    }

    public ChunkPos(@NotNull Entity entity) {
        this(MathHelper.floor(entity.x / 16.0), MathHelper.floor(entity.z / 16.0));
    }

    @Override
    public int x() {
        return this.x;
    }

    @Override
    public int z() {
        return this.z;
    }

    @Override
    @NotNull
    public ChunkPos add(int x, int z, @NotNull ChunkPos dest) {
        return dest.set(this.x + x, this.z + z);
    }

    @Override
    @NotNull
    public ChunkPos add(@NotNull Vector2ic v, @NotNull ChunkPos dest) {
        return this.add(v.x(), v.y(), dest);
    }

    @Override
    @NotNull
    public ChunkPos add(@NotNull Direction dir, @NotNull ChunkPos dest) {
        return this.add(dir.getOffsetX(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkPos add(int x, int z) {
        return this.add(x, z, this);
    }

    @NotNull
    public ChunkPos add(@NotNull Vector2ic v) {
        return this.add(v, this);
    }

    @NotNull
    public ChunkPos add(@NotNull Direction dir) {
        return this.add(dir, this);
    }

    @Override
    @NotNull
    public ChunkPos sub(int x, int z, @NotNull ChunkPos dest) {
        return dest.set(this.x - x, this.z - z);
    }

    @Override
    @NotNull
    public ChunkPos sub(@NotNull Vector2ic v, @NotNull ChunkPos dest) {
        return this.sub(v.x(), v.y(), dest);
    }

    @Override
    @NotNull
    public ChunkPos sub(@NotNull Direction dir, @NotNull ChunkPos dest) {
        return this.sub(dir.getOffsetX(), dir.getOffsetZ(), dest);
    }

    @NotNull
    public ChunkPos sub(int x, int z) {
        return this.sub(x, z, this);
    }

    @NotNull
    public ChunkPos sub(@NotNull Vector2ic v) {
        return this.sub(v, this);
    }

    @NotNull
    public ChunkPos sub(@NotNull Direction dir) {
        return this.sub(dir, this);
    }

    @Override
    public double distance(@NotNull ChunkPosc pos) {
        int dx = this.x - pos.x();
        int dz = this.z - pos.z();
        return Math.sqrt(dx * dx + dz * dz);
    }

    @Override
    public double distanceSquared(@NotNull ChunkPosc pos) {
        int dx = this.x - pos.x();
        int dz = this.z - pos.z();
        return dx * dx + dz * dz;
    }

    @Override
    public boolean inBounds(@NotNull WorldSource source) {
        return this.x >= java.lang.Math.floorDiv(-32000000, 16) && this.z >= java.lang.Math.floorDiv(-32000000, 16) && this.x <= java.lang.Math.floorDiv(32000000, 16) && this.z <= java.lang.Math.floorDiv(32000000, 16);
    }

    @Override
    public boolean equals(int x, int z) {
        return this.x == x && this.z == z;
    }

    @NotNull
    public ChunkPos set(int x, int z) {
        this.x = x;
        this.z = z;
        return this;
    }

    @NotNull
    public ChunkPos set(@NotNull ChunkPosc chunkPos) {
        this.x = chunkPos.x();
        this.z = chunkPos.z();
        return this;
    }

    @NotNull
    public ChunkPos set(@NotNull TilePosc pos) {
        return this.set(java.lang.Math.floorDiv(pos.x(), 16), java.lang.Math.floorDiv(pos.z(), 16));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkPos) {
            @NotNull ChunkPos other = (ChunkPos)obj;
            return this.x == other.x && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return MathHelper.cantor(this.x, this.z);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.x);
        out.writeInt(this.z);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.set(in.readInt(), in.readInt());
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

