/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import net.minecraft.core.lang.text.LiteralText;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.WorldSettingNodes;
import net.minecraft.core.world.settings.impl.RangeIntegerSettingNode;
import org.jetbrains.annotations.NotNull;

public class WorldHeightSettingNode
extends RangeIntegerSettingNode {
    public static final int VALUE_SCALE = 16;
    public static final int DEFAULT_MIN = 0;
    public static final int DEFAULT_MAX = 16;
    @NotNull
    private final ValueType valueType;

    public WorldHeightSettingNode(@NotNull String key, @NotNull Text name, int defaultValue, @NotNull ValueType valueType) {
        super(key, name, 0, 16, defaultValue);
        this.valueType = valueType;
    }

    @Override
    @NotNull
    public Integer getMinimumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        int bottomValue = config.getDimensionSettings(dimension).getNodeValueOr(WorldSettingNodes.WORLD_HEIGHT_BOTTOM, 0);
        int baseMin = super.getMinimumValue(dimension, config);
        return switch (this.valueType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> baseMin;
            case 1 -> bottomValue + 1;
        };
    }

    @Override
    @NotNull
    public Integer getMaximumValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        int topValue = config.getDimensionSettings(dimension).getNodeValueOr(WorldSettingNodes.WORLD_HEIGHT_TOP, 16);
        int baseMax = super.getMaximumValue(dimension, config);
        return switch (this.valueType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> topValue - 1;
            case 1 -> baseMax;
        };
    }

    @Override
    @NotNull
    public Integer getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        int baseDefault = super.getDefaultValue(dimension, config);
        int baseMin = super.getMinimumValue(dimension, config);
        int baseMax = super.getMaximumValue(dimension, config);
        int bottomValue = config.getDimensionSettings(dimension).getNodeValueOr(WorldSettingNodes.WORLD_HEIGHT_BOTTOM, 0);
        int topValue = config.getDimensionSettings(dimension).getNodeValueOr(WorldSettingNodes.WORLD_HEIGHT_TOP, 16);
        return switch (this.valueType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> MathHelper.clamp(baseDefault, baseMin, topValue - 1);
            case 1 -> MathHelper.clamp(baseDefault, bottomValue + 1, baseMax);
        };
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull Integer value) {
        return new LiteralText("" + 16 * value);
    }

    public static enum ValueType {
        BOTTOM,
        TOP;

    }
}

