/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkLoader;
import net.minecraft.core.world.chunk.ChunkLoaderRegion;
import org.slf4j.Logger;

public class ChunkLoaderRegionAsync
implements ChunkLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Queue<Chunk> chunksToSave = new LinkedList<Chunk>();
    private static final Queue<World> worldsToSave = new LinkedList<World>();
    private static final Queue<ChunkLoaderRegion> chunkLoaders = new LinkedList<ChunkLoaderRegion>();
    private static final Lock lockChunksToSave = new ReentrantLock();
    private static final Condition notEmpty = lockChunksToSave.newCondition();
    private static final ChunkSaveThread chunkSaveThread = new ChunkSaveThread();
    private final ChunkLoaderRegion chunkLoaderRegion;

    public ChunkLoaderRegionAsync(File worldDir) {
        this.chunkLoaderRegion = new ChunkLoaderRegion(worldDir);
    }

    @Override
    public Chunk loadChunk(World world, int x, int z) throws IOException {
        return this.chunkLoaderRegion.loadChunk(world, x, z);
    }

    @Override
    public void saveChunk(World world, Chunk chunk) throws IOException {
        lockChunksToSave.lock();
        try {
            if (!chunksToSave.contains(chunk)) {
                chunksToSave.add(chunk);
                worldsToSave.add(world);
                chunkLoaders.add(this.chunkLoaderRegion);
                notEmpty.signal();
            }
        }
        finally {
            lockChunksToSave.unlock();
        }
    }

    @Override
    public boolean isSaving() {
        return !chunksToSave.isEmpty();
    }

    static {
        chunkSaveThread.setName("Chunk Save Thread");
        chunkSaveThread.start();
        System.out.println("Spawned new chunk save thread!");
    }

    private static class ChunkSaveThread
    extends Thread {
        public volatile boolean shouldStop = false;

        private ChunkSaveThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.shouldStop) {
                lockChunksToSave.lock();
                try {
                    if (!chunksToSave.isEmpty()) {
                        Chunk chunk = chunksToSave.remove();
                        World world = worldsToSave.remove();
                        ChunkLoaderRegion chunkLoaderRegion = chunkLoaders.remove();
                        chunkLoaderRegion.saveChunk(world, chunk);
                        continue;
                    }
                    notEmpty.await();
                }
                catch (IOException | InterruptedException e) {
                    LOGGER.error("Exception while attempting to save chunks in async loader", e);
                }
                finally {
                    lockChunksToSave.unlock();
                }
            }
        }
    }
}

