/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.save;

import java.io.File;
import java.util.List;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.chunk.ChunkLoader;
import net.minecraft.core.world.chunk.ChunkLoaderRegionAsync;
import net.minecraft.core.world.save.ISaveFormat;
import net.minecraft.core.world.save.LevelData;
import net.minecraft.core.world.save.LevelStorageBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LevelStorageCore
extends LevelStorageBase {
    public LevelStorageCore(ISaveFormat saveFormat, File savesDir, String worldDirName) {
        super(saveFormat, savesDir, worldDirName);
    }

    @Override
    @Nullable
    public ChunkLoader getChunkLoader(@NotNull Dimension dimension) {
        File dimDir = this.saveFormat.getDimensionRootDir(this.worldDirName, dimension);
        dimDir.mkdirs();
        return new ChunkLoaderRegionAsync(dimDir);
    }

    @Override
    public void saveLevelDataAndPlayerData(@NotNull LevelData levelData, @NotNull List<Player> playerList) {
        levelData.setSaveVersion(this.saveFormat.getSaveVersion());
        super.saveLevelDataAndPlayerData(levelData, playerList);
    }
}

