/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.zip.DataFormatException;
import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.settings.ListValueSettingNode;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import net.minecraft.core.world.type.WorldType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BiomeSettingNode
extends ValueGenericSettingNode<Biome>
implements ListValueSettingNode<Biome> {
    public BiomeSettingNode(@NotNull String key, @NotNull Text name) {
        super(key, name, Biome.class);
    }

    @Override
    @NotNull
    public Biome getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.getValues(dimension, config).get(0);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Biome> getValues(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        @NotNull WorldType worldType = config.getWorldType(dimension);
        return Arrays.asList(worldType.allBiomes());
    }

    @Override
    @NotNull
    public Text getValueText(@NotNull Biome value) {
        return new TranslatableText(value.translationKey);
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@NotNull Biome value) {
        return new StringTag(Objects.requireNonNull(Registries.BIOMES.getKey(value)));
    }

    @Override
    @NotNull
    public Biome deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof StringTag) {
            @NotNull StringTag stringTag = (StringTag)tag;
            @Nullable Biome biome = Registries.BIOMES.getItem((String)stringTag.getValue());
            if (biome != null) {
                return biome;
            }
            throw new DataFormatException("Illegal biome ID in tag!");
        }
        throw new DataFormatException("Tag was wrong type!");
    }
}

