/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.settings.impl;

import com.mojang.nbt.tags.StringTag;
import com.mojang.nbt.tags.Tag;
import java.util.List;
import java.util.zip.DataFormatException;
import net.minecraft.core.lang.text.Text;
import net.minecraft.core.lang.text.TranslatableText;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.config.season.SeasonConfigCycle;
import net.minecraft.core.world.config.season.SeasonConfigSingle;
import net.minecraft.core.world.save.WorldConfigurationReader;
import net.minecraft.core.world.season.Season;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.settings.ListValueSettingNode;
import net.minecraft.core.world.settings.ValueGenericSettingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeasonSettingNode
extends ValueGenericSettingNode<Season>
implements ListValueSettingNode<Season> {
    public SeasonSettingNode(@NotNull String key, @NotNull Text name) {
        super(key, name, Season.class);
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Season> getValues(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        @NotNull SeasonConfig seasonConfig = config.getWorldType(dimension).getSeasonConfig();
        if (seasonConfig instanceof SeasonConfigCycle) {
            @NotNull SeasonConfigCycle cycle = (SeasonConfigCycle)seasonConfig;
            return cycle.getSeasons();
        }
        if (seasonConfig instanceof SeasonConfigSingle) {
            @NotNull SeasonConfigSingle single = (SeasonConfigSingle)seasonConfig;
            return List.of(single.getSingleSeason());
        }
        throw new IllegalStateException("Illegal SeasonConfig!");
    }

    @Override
    @NotNull
    public Season getDefaultValue(@NotNull Dimension dimension, @NotNull WorldConfigurationReader config) {
        return this.getValues(dimension, config).get(0);
    }

    @Override
    @NotNull
    public Text getValueText(@Nullable Season value) {
        if (value == null) {
            return new TranslatableText("world_settings.single_season.values.disabled");
        }
        return new TranslatableText(value.getLanguageKey() + ".name");
    }

    @Override
    @NotNull
    public Tag<?> serializeValue(@Nullable Season value) {
        if (value == null) {
            return new StringTag("");
        }
        return new StringTag(value.getId());
    }

    @Override
    @NotNull
    public Season deserializeValue(@NotNull Tag<?> tag) throws DataFormatException {
        if (tag instanceof StringTag) {
            @NotNull StringTag stringTag = (StringTag)tag;
            @Nullable Season season = Seasons.getSeason((String)stringTag.getValue());
            if (season != null) {
                return season;
            }
            throw new DataFormatException("Illegal season ID in tag!");
        }
        throw new DataFormatException("Tag was wrong type!");
    }
}

