/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.nbt.UnknownTagException;
import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListTag
extends Tag<List<Tag<?>>>
implements Iterable<Tag<?>> {
    private byte tagType;

    public ListTag() {
        this(new ArrayList());
    }

    public ListTag(List<Tag<?>> array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        this.tagType = !((List)this.getValue()).isEmpty() ? ((Tag)((List)this.getValue()).get(0)).getId() : (byte)1;
        dos.writeByte(this.tagType);
        dos.writeInt(((List)this.getValue()).size());
        for (int i = 0; i < ((List)this.getValue()).size(); ++i) {
            ((Tag)((List)this.getValue()).get(i)).write(dos);
        }
    }

    @Override
    public void fromJson(@NotNull JsonElement element) throws JsonParseException {
        if (!element.isJsonObject()) {
            throw new JsonParseException("ListTag JsonElement must be a json object!");
        }
        JsonObject asObject = element.getAsJsonObject();
        if (!asObject.has("type")) {
            throw new JsonParseException("ListTag must have a defined type!");
        }
        Tag.TagID type = Tag.TagID.fromIdString(asObject.get("type").getAsString());
        ((List)this.getValue()).clear();
        if (asObject.has("list")) {
            JsonArray list = asObject.getAsJsonArray("list");
            for (JsonElement e : list) {
                Tag<?> entry = type.getNewTag();
                entry.fromJson(e);
                this.addTag(entry);
            }
        }
    }

    @Override
    @NotNull
    public JsonElement toJson() {
        JsonObject output = new JsonObject();
        output.addProperty("type", Tag.TagID.fromId(this.tagType).getIdString());
        JsonArray list = new JsonArray(((List)this.getValue()).size());
        for (Tag tag : (List)this.getValue()) {
            list.add(tag.toJson());
        }
        output.add("list", list);
        return output;
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.tagType = dis.readByte();
        int length = dis.readInt();
        this.setValue(new ArrayList());
        for (int i = 0; i < length; ++i) {
            try {
                Tag<?> tag = Tag.TagID.fromId(this.tagType).getNewTag();
                tag.read(dis);
                ((List)this.getValue()).add(tag);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnknownTagException("Unknown tag type '" + this.tagType + "'!");
            }
        }
    }

    @Override
    public byte getId() {
        return Tag.TagID.TAG_LIST.getId();
    }

    public String toString() {
        if (((List)this.getValue()).size() > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((List)this.getValue()).size() + " elements ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (Tag d : (List)this.getValue()) {
            sb.append(d).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void addTag(Tag<?> tag) {
        this.tagType = tag.getId();
        ((List)this.getValue()).add(tag);
    }

    @NotNull
    public Tag<?> tagAt(int index) {
        return (Tag)((List)this.getValue()).get(index);
    }

    public int tagCount() {
        return ((List)this.getValue()).size();
    }

    @Override
    @NotNull
    public Iterator<Tag<?>> iterator() {
        return ((List)this.getValue()).iterator();
    }
}

