/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.BlockLogicFluid;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.Fluid;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.material.Materials;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.world.Dimension;
import net.minecraft.core.world.World;
import net.minecraft.core.world.pos.TilePos;
import net.minecraft.core.world.pos.TilePosc;
import org.jetbrains.annotations.NotNull;

public class FluidWater
implements Fluid {
    @Override
    public int tickDelay() {
        return 5;
    }

    @Override
    public void animationTick(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        boolean isTop;
        int data = world.getBlockData(tilePos) & 0xF;
        TilePos up = tilePos.up(new TilePos());
        boolean bl = isTop = world.getBlockMaterial(up) == Materials.AIR && !world.isBlockOpaqueCube(up);
        if (rand.nextInt(64) == 0 && data > 0 && data < 8) {
            world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (float)tilePos.x() + 0.5f, (float)tilePos.y() + 0.5f, (float)tilePos.z() + 0.5f, "liquid.water", rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() * 1.0f + 0.5f);
        }
        if (world.dimension == Dimension.NETHER && isTop && data == 0 && rand.nextInt(4) == 0) {
            world.spawnParticle("smoke", (double)tilePos.x() + Math.random(), (float)tilePos.y() + 0.875f, (double)tilePos.z() + Math.random(), 0.0, 0.0, 0.0, 1);
        }
    }

    @Override
    public boolean checkForHarden(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Material encountered) {
        if (encountered == Materials.LAVA) {
            int data = world.getBlockData(tilePos) & 0xF;
            if (data == 0) {
                world.setBlockTypeNotify(tilePos, Blocks.COBBLE_LIMESTONE);
                BlockLogicFluid.fizz(world, tilePos);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldTick() {
        return false;
    }

    @Override
    public void updateTickStill(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
    }

    @Override
    public byte getFlowDecayMod(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos) {
        return 1;
    }

    @Override
    public boolean canBecomeSource(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePosc tilePos, @NotNull Random rand) {
        return world.dimension != Dimension.NETHER;
    }

    @Override
    public void onFlowIntoBlock(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, int meta) {
        world.getBlockType(tilePos).dropWithCause(world, EnumDropCause.WORLD, tilePos, world.getBlockData(tilePos), null, null);
    }

    @Override
    public boolean canSpreadTo(@NotNull BlockLogicFluid logicFluid, @NotNull World world, @NotNull TilePos tilePos, @NotNull Material material) {
        return material != Materials.LAVA;
    }
}

